/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.zend2.util;

import java.io.File;
import java.util.regex.Pattern;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.editor.PhpType;
import org.netbeans.spi.project.support.ant.PropertyUtils;

public final class Zend2Utils {
    private static final String CONTROLLER_DIRECTORY = "Controller";
    private static final String CONTROLLER_FILE_SUFFIX = "Controller.php";
    public static final String CONTROLLER_CLASS_SUFFIX = "Controller";
    private static final String CONTROLLER_METHOD_SUFFIX = "Action";
    private static final String VIEW_DIRECTORY = "view";
    private static final String FILE_VIEW_EXTENSION = ".phtml";
    private static final String CONTROLLER_RELATIVE_FILE = "../../../src/%s/Controller/%s.php";
    private static final String VIEW_RELATIVE_FILE = "../../../view/%s/%s/%s.phtml";
    private static final String DASH = "-";

    private Zend2Utils() {
    }

    public static boolean isViewWithAction(File file) {
        return Zend2Utils.isView(file) && Zend2Utils.getController(file) != null;
    }

    public static boolean isView(File file) {
        if (file == null) {
            return false;
        }
        if (!file.isFile() || !file.getName().endsWith(FILE_VIEW_EXTENSION)) {
            return false;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        if ((parent = parent.getParentFile()) == null) {
            return false;
        }
        parent = parent.getParentFile();
        return VIEW_DIRECTORY.equals(parent.getName());
    }

    public static File getView(File controller, PhpBaseElement phpElement) {
        if (phpElement instanceof PhpType.Method) {
            String namespace = Zend2Utils.getNamespaceFromController(controller);
            String viewFolderName = Zend2Utils.getViewFolderName(controller.getName());
            String viewName = Zend2Utils.getViewName(phpElement.getName());
            File view = PropertyUtils.resolveFile((File)controller.getParentFile(), (String)String.format(VIEW_RELATIVE_FILE, Zend2Utils.dashize(namespace), viewFolderName, viewName));
            if (view.isFile()) {
                return view;
            }
        }
        return null;
    }

    static String getViewName(String actionName) {
        if (!actionName.endsWith(CONTROLLER_METHOD_SUFFIX)) {
            return null;
        }
        return Zend2Utils.dashize(actionName.replace(CONTROLLER_METHOD_SUFFIX, ""));
    }

    static String getViewFolderName(String controllerName) {
        return Zend2Utils.dashize(controllerName.replace(CONTROLLER_FILE_SUFFIX, ""));
    }

    public static boolean isController(File file) {
        return file.isFile() && file.getName().endsWith(CONTROLLER_FILE_SUFFIX) && file.getParentFile().getName().equals("Controller");
    }

    public static File getController(File view) {
        String namespace = Zend2Utils.getNamespaceFromView(view);
        String controllerName = Zend2Utils.getControllerName(view);
        File controller = PropertyUtils.resolveFile((File)view.getParentFile(), (String)String.format(CONTROLLER_RELATIVE_FILE, namespace, controllerName));
        if (controller.isFile()) {
            return controller;
        }
        return null;
    }

    static String getNamespaceFromView(File view) {
        return Zend2Utils.undashize(view.getParentFile().getParentFile().getName(), false);
    }

    static String getNamespaceFromController(File controller) {
        return controller.getParentFile().getParentFile().getName();
    }

    static String getControllerName(File view) {
        return Zend2Utils.getControllerName(view.getParentFile().getName());
    }

    static String getControllerName(String viewFolderName) {
        return Zend2Utils.undashize(viewFolderName, false) + "Controller";
    }

    public static String getActionName(File view) {
        return Zend2Utils.getActionName(view.getName().substring(0, view.getName().length() - FILE_VIEW_EXTENSION.length()));
    }

    static String getActionName(String viewName) {
        return Zend2Utils.undashize(viewName, true) + CONTROLLER_METHOD_SUFFIX;
    }

    static String dashize(String input) {
        StringBuilder sb = new StringBuilder(2 * input.length());
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (i != 0) {
                    sb.append(DASH);
                }
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    static String undashize(String input, boolean firstLowerCase) {
        StringBuilder sb = new StringBuilder(input.length());
        boolean first = firstLowerCase;
        for (String part : input.split(Pattern.quote(DASH))) {
            if (first) {
                first = false;
                sb.append(part);
                continue;
            }
            sb.append(part.substring(0, 1).toUpperCase());
            sb.append(part.substring(1));
        }
        return sb.toString();
    }
}

