/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.api.framework.BadgeIcon;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpModuleProperties;
import org.netbeans.modules.php.api.queries.PhpVisibilityQuery;
import org.netbeans.modules.php.api.queries.Queries;
import org.netbeans.modules.php.smarty.Bundle;
import org.netbeans.modules.php.smarty.SmartyPhpModuleCustomizerExtender;
import org.netbeans.modules.php.smarty.ui.notification.AutodetectionPanel;
import org.netbeans.modules.php.spi.framework.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.framework.PhpModuleActionsExtender;
import org.netbeans.modules.php.spi.framework.PhpModuleCustomizerExtender;
import org.netbeans.modules.php.spi.framework.PhpModuleExtender;
import org.netbeans.modules.php.spi.framework.PhpModuleIgnoredFilesExtender;
import org.netbeans.modules.php.spi.framework.commands.FrameworkCommandSupport;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class SmartyPhpFrameworkProvider
extends PhpFrameworkProvider {
    protected static final RequestProcessor RP = new RequestProcessor(SmartyPhpFrameworkProvider.class);
    private static final Logger LOGGER = Logger.getLogger(SmartyPhpFrameworkProvider.class.getName());
    public static final String PROP_SMARTY_AVAILABLE = "smarty-framework";
    private static final String ICON_PATH = "org/netbeans/modules/php/smarty/resources/smarty-badge-8.png";
    private static final SmartyPhpFrameworkProvider INSTANCE = new SmartyPhpFrameworkProvider();
    private final BadgeIcon badgeIcon = new BadgeIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/php/smarty/resources/smarty-badge-8.png"), SmartyPhpFrameworkProvider.class.getResource("/org/netbeans/modules/php/smarty/resources/smarty-badge-8.png"));

    public static SmartyPhpFrameworkProvider getInstance() {
        return INSTANCE;
    }

    private SmartyPhpFrameworkProvider() {
        super("Smarty PHP Web Framework", NbBundle.getMessage(SmartyPhpFrameworkProvider.class, (String)"LBL_FrameworkName"), NbBundle.getMessage(SmartyPhpFrameworkProvider.class, (String)"LBL_FrameworkDescription"));
    }

    public BadgeIcon getBadgeIcon() {
        return this.badgeIcon;
    }

    public static boolean hasSmartyTemplateExtension(FileObject fo) {
        return FileUtil.getMIMEType((FileObject)fo, (String[])new String[]{"text/x-tpl", null}) != null;
    }

    public static FileObject locate(PhpModule phpModule, String relativePath, boolean subdirs) {
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        if (sourceDirectory == null) {
            return null;
        }
        FileObject fileObject = sourceDirectory.getFileObject(relativePath);
        if (fileObject != null || !subdirs) {
            return fileObject;
        }
        for (FileObject child : sourceDirectory.getChildren()) {
            fileObject = child.getFileObject(relativePath);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    public boolean isInPhpModule(PhpModule phpModule) {
        Boolean enabled = SmartyPhpFrameworkProvider.getSmartyPropertyEnabled(phpModule);
        return enabled != null && enabled != false;
    }

    public PhpModuleExtender createPhpModuleExtender(PhpModule phpModule) {
        return null;
    }

    public PhpModuleProperties getPhpModuleProperties(PhpModule phpModule) {
        FileObject testUnit;
        PhpModuleProperties properties = new PhpModuleProperties();
        FileObject web = SmartyPhpFrameworkProvider.locate(phpModule, "web", true);
        if (web != null) {
            properties = properties.setWebRoot(web);
        }
        if ((testUnit = SmartyPhpFrameworkProvider.locate(phpModule, "test/unit", true)) != null) {
            properties = properties.setTests(testUnit);
        }
        return properties;
    }

    public PhpModuleActionsExtender getActionsExtender(PhpModule phpModule) {
        return null;
    }

    public PhpModuleIgnoredFilesExtender getIgnoredFilesExtender(PhpModule phpModule) {
        return null;
    }

    public FrameworkCommandSupport getFrameworkCommandSupport(PhpModule phpModule) {
        return null;
    }

    public PhpModuleCustomizerExtender createPhpModuleCustomizerExtender(PhpModule phpModule) {
        return new SmartyPhpModuleCustomizerExtender(phpModule);
    }

    public void phpModuleOpened(final PhpModule phpModule) {
        if (SmartyPhpFrameworkProvider.getSmartyPropertyEnabled(phpModule) == null) {
            try {
                ParserManager.parseWhenScanFinished((String)"text/x-php5", (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        RP.post((Runnable)new SmartyAutodetectionJob(phpModule));
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static boolean detectSmartyTemplate(FileObject fo, PhpVisibilityQuery visibilityQuery) {
        if (!fo.isValid() || !visibilityQuery.isVisible(fo)) {
            return false;
        }
        assert (fo.isFolder());
        for (FileObject child : fo.getChildren()) {
            if (!(child.isFolder() ? SmartyPhpFrameworkProvider.detectSmartyTemplate(child, visibilityQuery) : SmartyPhpFrameworkProvider.hasSmartyTemplateExtension(child))) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    private static Boolean getSmartyPropertyEnabled(PhpModule phpModule) {
        Preferences preferences = phpModule.getPreferences(SmartyPhpFrameworkProvider.class, true);
        String available = preferences.get(PROP_SMARTY_AVAILABLE, null);
        if (available == null) {
            return null;
        }
        return Boolean.valueOf(available);
    }

    private static class SmartyAutodetectionJob
    implements Runnable {
        private final PhpModule phpModule;

        public SmartyAutodetectionJob(PhpModule phpModule) {
            this.phpModule = phpModule;
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            LOGGER.log(Level.FINEST, "Smarty templates autodetection started.");
            FileObject sourceDirectory = this.phpModule.getSourceDirectory();
            PhpVisibilityQuery visibilityQuery = Queries.getVisibilityQuery((PhpModule)this.phpModule);
            if (sourceDirectory != null && SmartyPhpFrameworkProvider.detectSmartyTemplate(sourceDirectory, visibilityQuery)) {
                NotificationDisplayer.getDefault().notify(Bundle.SmartyPhpFrameworkProvider_tit_smarty_template_autodetection(), NotificationDisplayer.Priority.LOW.getIcon(), (JComponent)new AutodetectionPanel(this.phpModule), (JComponent)new AutodetectionPanel(this.phpModule), NotificationDisplayer.Priority.LOW);
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Smarty templates autodetection took {0}ms.", System.currentTimeMillis() - startTime);
            }
        }
    }
}

