/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchInfoUtils;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.php.api.documentation.PhpDocumentations;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.Bundle;
import org.netbeans.modules.php.project.ComputeTestMethodAnnotations;
import org.netbeans.modules.php.project.CreateFromTemplateAttributesImpl;
import org.netbeans.modules.php.project.Frameworks;
import org.netbeans.modules.php.project.ImportantFilesImpl;
import org.netbeans.modules.php.project.PhpActionProvider;
import org.netbeans.modules.php.project.PhpConfigurationProvider;
import org.netbeans.modules.php.project.PhpEditorExtender;
import org.netbeans.modules.php.project.PhpLanguagePropertiesAccessor;
import org.netbeans.modules.php.project.PhpModuleImpl;
import org.netbeans.modules.php.project.PhpProjectEncodingQueryImpl;
import org.netbeans.modules.php.project.PhpProjectOperations;
import org.netbeans.modules.php.project.PhpProjectValidator;
import org.netbeans.modules.php.project.PhpSharabilityQuery;
import org.netbeans.modules.php.project.PhpSources;
import org.netbeans.modules.php.project.PhpTemplates;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectBrowserProviderImpl;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ProjectUpgrader;
import org.netbeans.modules.php.project.SourceRoots;
import org.netbeans.modules.php.project.TestingProviders;
import org.netbeans.modules.php.project.UpdateHelper;
import org.netbeans.modules.php.project.UpdateImplementation;
import org.netbeans.modules.php.project.annotations.ProjectUserAnnotationsProvider;
import org.netbeans.modules.php.project.api.PhpSeleniumProvider;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.classpath.ClassPathProviderImpl;
import org.netbeans.modules.php.project.classpath.IncludePathClassPathProvider;
import org.netbeans.modules.php.project.copysupport.CopySupport;
import org.netbeans.modules.php.project.internalserver.InternalWebServer;
import org.netbeans.modules.php.project.problems.ProjectPropertiesProblemProvider;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.actions.support.DebugStarterFactory;
import org.netbeans.modules.php.project.ui.codecoverage.PhpCoverageProvider;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.project.ui.customizer.IgnorePathSupport;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.logicalview.PhpLogicalViewProvider;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.project.util.UsageLogging;
import org.netbeans.modules.php.spi.executable.DebugStarter;
import org.netbeans.modules.php.spi.framework.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.framework.PhpModuleIgnoredFilesExtender;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.modules.php.spi.testing.PhpTestingProviders;
import org.netbeans.modules.web.browser.api.BrowserSupport;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.spi.PageInspectorCustomizer;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProvider;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProviders;
import org.netbeans.modules.web.common.api.CssPreprocessor;
import org.netbeans.modules.web.common.api.CssPreprocessors;
import org.netbeans.modules.web.common.api.CssPreprocessorsListener;
import org.netbeans.modules.web.common.api.UsageLogger;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.common.spi.ProjectWebRootProvider;
import org.netbeans.modules.web.common.spi.ServerURLMappingImplementation;
import org.netbeans.modules.web.common.ui.api.CssPreprocessorsUI;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.FilterPropertyProvider;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.netbeans.spi.search.SearchInfoDefinitionFactory;
import org.netbeans.spi.search.SubTreeSearchOptions;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class PhpProject
implements Project {
    static final Logger LOGGER = Logger.getLogger(PhpProject.class.getName());
    public static final String PROJECT_ICON = "org/netbeans/modules/php/project/ui/resources/phpProject.png";
    final AntProjectHelper helper;
    final UpdateHelper updateHelper;
    private final ReferenceHelper refHelper;
    private final PropertyEvaluator eval;
    private final Lookup lookup;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private final SourceRoots seleniumRoots;
    private final SearchFilterDefinition searchFilterDef = new PhpSearchFilterDef();
    volatile FileObject webRootDirectory;
    volatile String name;
    private final AntProjectListener phpAntProjectListener = new PhpAntProjectListener();
    private final PropertyChangeListener projectPropertiesListener = new ProjectPropertiesListener();
    Set<BasePathSupport.Item> ignoredFolders;
    final Object ignoredFoldersLock = new Object();
    final ChangeSupport ignoredFoldersChangeSupport = new ChangeSupport((Object)this);
    final Frameworks frameworks;
    final TestingProviders testingProviders;
    private final ChangeListener frameworksListener;
    private final SourceDirectoryFileChangeListener sourceDirectoryFileChangeListener = new SourceDirectoryFileChangeListener();
    public static final String PROP_FRAMEWORKS = "frameworks";
    public static final String PROP_WEB_ROOT = "webRoot";
    final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final Set<PropertyChangeListener> propertyChangeListeners = Collections.newSetFromMap(new WeakHashMap());
    final CssPreprocessorsListener cssPreprocessorsListener = new CssPreprocessorsListener(){

        public void preprocessorsChanged() {
        }

        public void optionsChanged(CssPreprocessor cssPreprocessor) {
            PhpProject.this.recompileSources(cssPreprocessor);
        }

        public void customizerChanged(Project project, CssPreprocessor cssPreprocessor) {
            if (project.equals(PhpProject.this)) {
                PhpProject.this.recompileSources(cssPreprocessor);
            }
        }

        public void processingErrorOccured(Project project, CssPreprocessor cssPreprocessor, String error) {
        }
    };
    private final WindowSystemListener windowSystemListener = new WindowSystemListener(){

        public void beforeLoad(WindowSystemEvent event) {
        }

        public void afterLoad(WindowSystemEvent event) {
        }

        public void beforeSave(WindowSystemEvent event) {
            ((ClientSideDevelopmentSupport)PhpProject.this.getLookup().lookup(ClientSideDevelopmentSupport.class)).close();
        }

        public void afterSave(WindowSystemEvent event) {
        }
    };

    public PhpProject(AntProjectHelper helper) {
        assert (helper != null);
        this.helper = helper;
        this.updateHelper = new UpdateHelper(UpdateImplementation.NULL, helper);
        AuxiliaryConfiguration configuration = helper.createAuxiliaryConfiguration();
        this.eval = this.createEvaluator();
        this.refHelper = new ReferenceHelper(helper, configuration, this.getEvaluator());
        this.sourceRoots = SourceRoots.Builder.create(this.updateHelper, this.eval, Bundle.PhpProject_sourceRoots_sources()).setProperties("src.dir").build();
        this.testRoots = SourceRoots.Builder.create(this.updateHelper, this.eval, Bundle.PhpProject_sourceRoots_tests()).setPropertyNumericPrefix("test.src.dir").setTests(true).build();
        this.seleniumRoots = SourceRoots.Builder.create(this.updateHelper, this.eval, Bundle.PhpProject_sourceRoots_selenium()).setPropertyNumericPrefix("selenium.src.dir").setTests(true).build();
        PhpModuleImpl phpModule = new PhpModuleImpl(this);
        this.frameworks = new Frameworks(phpModule);
        this.testingProviders = TestingProviders.create(this);
        this.lookup = this.createLookup(configuration, phpModule);
        this.addWeakPropertyEvaluatorListener(this.projectPropertiesListener);
        helper.addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this.phpAntProjectListener, (Object)helper));
        this.sourceRoots.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PhpProject.this.removeSourceDirListener();
                PhpProject.this.addSourceDirListener();
                PhpProject.this.resetFrameworks();
            }
        });
        this.frameworksListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PhpProject.this.fireFrameworksChange();
            }
        };
        this.frameworks.addChangeListener(WeakListeners.change((ChangeListener)this.frameworksListener, (Object)this.frameworks));
        WindowManager windowManager = WindowManager.getDefault();
        windowManager.addWindowSystemListener((WindowSystemListener)WeakListeners.create(WindowSystemListener.class, (EventListener)this.windowSystemListener, (Object)windowManager));
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    PropertyEvaluator getEvaluator() {
        return this.eval;
    }

    void addWeakPropertyEvaluatorListener(PropertyChangeListener listener) {
        this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)listener, (Object)this.eval));
    }

    void addWeakIgnoredFilesListener(ChangeListener listener) {
        this.ignoredFoldersChangeSupport.addChangeListener(WeakListeners.change((ChangeListener)listener, (Object)this.ignoredFoldersChangeSupport));
        VisibilityQuery visibilityQuery = VisibilityQuery.getDefault();
        visibilityQuery.addChangeListener(WeakListeners.change((ChangeListener)listener, (Object)visibilityQuery));
    }

    boolean addWeakPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyChangeListeners.add(listener)) {
            return false;
        }
        this.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)listener, (Object)this.propertyChangeSupport));
        return true;
    }

    void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public SearchFilterDefinition getSearchFilterDefinition() {
        return this.searchFilterDef;
    }

    private PropertyEvaluator createEvaluator() {
        PropertyEvaluator baseEval1 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/config.properties")});
        PropertyEvaluator baseEval2 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/private.properties")});
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/config.properties"), new ConfigPropertyProvider(baseEval1, "nbproject/private/configs", this.helper), this.helper.getPropertyProvider("nbproject/private/private.properties"), this.helper.getProjectLibrariesPropertyProvider(), PropertyUtils.userPropertiesProvider((PropertyEvaluator)baseEval2, (String)"user.properties.file", (File)FileUtil.toFile((FileObject)this.getProjectDirectory())), new ConfigPropertyProvider(baseEval1, "nbproject/configs", this.helper), this.helper.getPropertyProvider("nbproject/project.properties")});
    }

    public FileObject getProjectDirectory() {
        return this.getHelper().getProjectDirectory();
    }

    public SourceRoots getSourceRoots() {
        return this.sourceRoots;
    }

    public SourceRoots getTestRoots() {
        return this.testRoots;
    }

    public SourceRoots getSeleniumRoots() {
        return this.seleniumRoots;
    }

    @CheckForNull
    FileObject getSourcesDirectory() {
        int n = 0;
        FileObject[] fileObjectArray = this.sourceRoots.getRoots();
        int n2 = fileObjectArray.length;
        if (n < n2) {
            FileObject root = fileObjectArray[n];
            return root;
        }
        return null;
    }

    FileObject[] getTestsDirectories() {
        return this.testRoots.getRoots();
    }

    FileObject[] getSeleniumDirectories() {
        return this.seleniumRoots.getRoots();
    }

    FileObject getSeleniumDirectory() {
        int n = 0;
        FileObject[] fileObjectArray = this.seleniumRoots.getRoots();
        int n2 = fileObjectArray.length;
        if (n < n2) {
            FileObject root = fileObjectArray[n];
            return root;
        }
        return null;
    }

    FileObject getWebRootDirectory() {
        if (this.webRootDirectory == null) {
            this.webRootDirectory = this.resolveWebRootDirectory();
        }
        return this.webRootDirectory;
    }

    private FileObject resolveWebRootDirectory() {
        if (PhpProjectValidator.isFatallyBroken(this)) {
            return null;
        }
        FileObject sources = this.getSourcesDirectory();
        assert (sources != null);
        String webRootProperty = this.eval.getProperty("web.root");
        if (webRootProperty == null) {
            return sources;
        }
        FileObject webRootDir = sources.getFileObject(webRootProperty);
        if (webRootDir != null) {
            return webRootDir;
        }
        LOGGER.log(Level.INFO, "Web root directory {0} not found for project {1}", new Object[]{webRootProperty, this.getName()});
        return sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSourceDirListener() {
        FileObject sourcesDirectory = this.getSourcesDirectory();
        if (sourcesDirectory == null) {
            return;
        }
        if (sourcesDirectory.equals(this.sourceDirectoryFileChangeListener.getSourceDir())) {
            return;
        }
        SourceDirectoryFileChangeListener sourceDirectoryFileChangeListener = this.sourceDirectoryFileChangeListener;
        synchronized (sourceDirectoryFileChangeListener) {
            this.sourceDirectoryFileChangeListener.setSourceDir(sourcesDirectory);
            FileUtil.addRecursiveListener((FileChangeListener)this.sourceDirectoryFileChangeListener, (File)FileUtil.toFile((FileObject)sourcesDirectory), (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return PhpProject.this.isVisible(pathname);
                }
            }, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSourceDirListener() {
        FileObject sourceDir = this.sourceDirectoryFileChangeListener.getSourceDir();
        if (sourceDir == null) {
            return;
        }
        SourceDirectoryFileChangeListener sourceDirectoryFileChangeListener = this.sourceDirectoryFileChangeListener;
        synchronized (sourceDirectoryFileChangeListener) {
            try {
                FileUtil.removeRecursiveListener((FileChangeListener)this.sourceDirectoryFileChangeListener, (File)FileUtil.toFile((FileObject)sourceDir));
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            finally {
                this.sourceDirectoryFileChangeListener.setSourceDir(null);
            }
        }
    }

    void recompileSources(CssPreprocessor cssPreprocessor) {
        assert (cssPreprocessor != null);
        FileObject sourcesDirectory = this.getSourcesDirectory();
        if (sourcesDirectory == null) {
            return;
        }
        CssPreprocessors.getDefault().process(cssPreprocessor, (Project)this, sourcesDirectory);
    }

    public PhpModule getPhpModule() {
        PhpModule phpModule = (PhpModule)this.getLookup().lookup(PhpModuleImpl.class);
        assert (phpModule != null);
        return phpModule;
    }

    boolean isVisible(File file) {
        if (this.getIgnoredFiles().contains(file)) {
            return false;
        }
        return VisibilityQuery.getDefault().isVisible(file);
    }

    boolean isVisible(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            if (this.getIgnoredFileObjects().contains(fileObject)) {
                return false;
            }
            return VisibilityQuery.getDefault().isVisible(fileObject);
        }
        return this.isVisible(file);
    }

    public Set<File> getIgnoredFiles() {
        HashSet<File> ignored = new HashSet<File>();
        this.addIgnoredProjectFiles(ignored);
        this.addIgnoredFrameworkFiles(ignored);
        return ignored;
    }

    public Set<FileObject> getIgnoredFileObjects() {
        HashSet<FileObject> ignoredFileObjects = new HashSet<FileObject>();
        for (File file : this.getIgnoredFiles()) {
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo == null) continue;
            ignoredFileObjects.add(fo);
        }
        return ignoredFileObjects;
    }

    private void addIgnoredProjectFiles(final Set<File> ignored) {
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void run() {
                Object object = PhpProject.this.ignoredFoldersLock;
                synchronized (object) {
                    if (PhpProject.this.ignoredFolders == null) {
                        PhpProject.this.ignoredFolders = PhpProject.this.resolveIgnoredFolders("ignore.path");
                    }
                    assert (PhpProject.this.ignoredFolders != null) : "Ignored folders cannot be null";
                    for (BasePathSupport.Item item : PhpProject.this.ignoredFolders) {
                        if (item.isBroken()) continue;
                        ignored.add(new File(item.getAbsoluteFilePath(PhpProject.this.helper.getProjectDirectory())));
                    }
                }
                return null;
            }
        });
    }

    private void resetIgnoredFolders() {
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void run() {
                Object object = PhpProject.this.ignoredFoldersLock;
                synchronized (object) {
                    PhpProject.this.ignoredFolders = null;
                }
                return null;
            }
        });
    }

    private void addIgnoredFrameworkFiles(Set<File> ignored) {
        PhpModule phpModule = this.getPhpModule();
        for (PhpFrameworkProvider provider : this.getFrameworks()) {
            PhpModuleIgnoredFilesExtender ignoredFilesExtender = provider.getIgnoredFilesExtender(phpModule);
            if (ignoredFilesExtender == null) continue;
            for (File file : ignoredFilesExtender.getIgnoredFiles()) {
                assert (file != null) : "Ignored file = null found in " + provider.getIdentifier();
                assert (file.isAbsolute()) : "Not absolute file found in " + provider.getIdentifier();
                ignored.add(file);
            }
        }
    }

    public Set<FileObject> getCodeAnalysisExcludeFileObjects() {
        HashSet<FileObject> excludedFileObjects = new HashSet<FileObject>();
        Set<BasePathSupport.Item> excluded = this.resolveIgnoredFolders("code.analysis.excludes");
        assert (excluded != null) : "Ignored folders cannot be null";
        for (BasePathSupport.Item item : excluded) {
            File file;
            FileObject fo;
            if (item.isBroken() || (fo = FileUtil.toFileObject((File)(file = new File(item.getAbsoluteFilePath(this.helper.getProjectDirectory()))))) == null) continue;
            excludedFileObjects.add(fo);
        }
        return excludedFileObjects;
    }

    private Set<BasePathSupport.Item> resolveIgnoredFolders(String propertyName) {
        IgnorePathSupport ignorePathSupport = new IgnorePathSupport(this.eval, this.refHelper, this.helper);
        HashSet<BasePathSupport.Item> ignored = new HashSet<BasePathSupport.Item>();
        EditableProperties properties = this.helper.getProperties("nbproject/project.properties");
        Iterator<BasePathSupport.Item> itemsIterator = ignorePathSupport.itemsIterator(properties.getProperty(propertyName));
        while (itemsIterator.hasNext()) {
            ignored.add(itemsIterator.next());
        }
        return ignored;
    }

    public List<PhpFrameworkProvider> getFrameworks() {
        return this.frameworks.getFrameworks();
    }

    public void resetFrameworks() {
        List<PhpFrameworkProvider> oldFrameworkProviders = this.getFrameworks();
        this.frameworks.resetFrameworks();
        List<PhpFrameworkProvider> newFrameworkProviders = this.getFrameworks();
        if (!oldFrameworkProviders.equals(newFrameworkProviders)) {
            this.fireFrameworksChange();
        }
    }

    void fireFrameworksChange() {
        this.propertyChangeSupport.firePropertyChange(PROP_FRAMEWORKS, null, null);
        this.fireIgnoredFilesChange();
    }

    public List<PhpTestingProvider> getTestingProviders() {
        return this.testingProviders.getTestingProviders();
    }

    public String getName() {
        if (this.name == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    Element data = PhpProject.this.getHelper().getPrimaryConfigurationData(true);
                    NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/php-project/1", "name");
                    if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                        PhpProject.this.name = ((Text)nl.item(0)).getNodeValue();
                    }
                    if (PhpProject.this.name == null) {
                        PhpProject.this.name = "???";
                    }
                    return null;
                }
            });
        }
        assert (this.name != null);
        return this.name;
    }

    public void setName(final String name) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                Element nameEl;
                Element data = PhpProject.this.getHelper().getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/php-project/1", "name");
                if (nl.getLength() == 1) {
                    nameEl = (Element)nl.item(0);
                    NodeList deadKids = nameEl.getChildNodes();
                    while (deadKids.getLength() > 0) {
                        nameEl.removeChild(deadKids.item(0));
                    }
                } else {
                    nameEl = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/php-project/1", "name");
                    data.insertBefore(nameEl, data.getChildNodes().item(0));
                }
                nameEl.appendChild(data.getOwnerDocument().createTextNode(name));
                PhpProject.this.getHelper().putPrimaryConfigurationData(data, true);
            }
        });
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(this.getClass().getName());
        buffer.append(" [ project directory: ");
        buffer.append(this.getProjectDirectory());
        buffer.append(" ]");
        return buffer.toString();
    }

    public AntProjectHelper getHelper() {
        return this.helper;
    }

    public CopySupport getCopySupport() {
        return (CopySupport)this.getLookup().lookup(CopySupport.class);
    }

    private Lookup createLookup(AuxiliaryConfiguration configuration, PhpModule phpModule) {
        PhpProjectEncodingQueryImpl phpProjectEncodingQueryImpl = new PhpProjectEncodingQueryImpl(this.getEvaluator());
        Lookup base = Lookups.fixed((Object[])new Object[]{this, CopySupport.getInstance(this), new SeleniumProvider(), new PhpCoverageProvider(this), new Info(), configuration, new PhpOpenedHook(), new PhpProjectXmlSavedHook(), new PhpActionProvider(this), new PhpConfigurationProvider(this), phpModule, PhpLanguagePropertiesAccessor.getDefault().createForProject(this), new PhpEditorExtender(this), this.helper.createCacheDirectoryProvider(), this.helper.createAuxiliaryProperties(), new ClassPathProviderImpl(this, this.getSourceRoots(), this.getTestRoots(), this.getSeleniumRoots()), new PhpLogicalViewProvider(this), new CustomizerProviderImpl(this), PhpSharabilityQuery.create(this.helper, this.getEvaluator(), this.getSourceRoots(), this.getTestRoots(), this.getSeleniumRoots()), LookupProviderSupport.createSharabilityQueryMerger(), new PhpProjectOperations(this), phpProjectEncodingQueryImpl, new CreateFromTemplateAttributesImpl(this.getHelper(), phpProjectEncodingQueryImpl), new PhpTemplates(), new PhpSources(this, this.getHelper(), this.getEvaluator(), this.getSourceRoots(), this.getTestRoots(), this.getSeleniumRoots()), this.getHelper(), this.getEvaluator(), PhpSearchInfo.create(this), new PhpSubTreeSearchOptions(), new PhpTestingProvidersImpl(this.testingProviders), InternalWebServer.createForProject(this), CssPreprocessorsUI.getDefault().createProjectProblemsProvider((Project)this), ProjectPropertiesProblemProvider.createForProject(this), UILookupMergerSupport.createProjectProblemsProviderMerger(), new ProjectWebRootProviderImpl(), ClientSideDevelopmentSupport.create(this), ProjectBrowserProviderImpl.create(this), new PhpVisibilityQuery.PhpVisibilityQueryImpl(this), new UsageLogging(), new ImportantFilesImpl(this), new ProjectUserAnnotationsProvider(this)});
        return LookupProviderSupport.createCompositeLookup((Lookup)base, (String)"Projects/org-netbeans-modules-php-project/Lookup");
    }

    public ReferenceHelper getRefHelper() {
        return this.refHelper;
    }

    public void fireIgnoredFilesChange() {
        this.resetIgnoredFolders();
        this.ignoredFoldersChangeSupport.fireChange();
    }

    private final class PhpSearchFilterDef
    extends SearchFilterDefinition {
        private PhpSearchFilterDef() {
        }

        public boolean searchFile(FileObject file) {
            if (!file.isData()) {
                throw new IllegalArgumentException("File expected");
            }
            return PhpVisibilityQuery.forProject(PhpProject.this).isVisible(file);
        }

        public SearchFilterDefinition.FolderResult traverseFolder(FileObject folder) {
            if (!folder.isFolder()) {
                throw new IllegalArgumentException("Folder expected");
            }
            if (PhpVisibilityQuery.forProject(PhpProject.this).isVisible(folder)) {
                return SearchFilterDefinition.FolderResult.TRAVERSE;
            }
            return SearchFilterDefinition.FolderResult.DO_NOT_TRAVERSE;
        }
    }

    private final class PhpAntProjectListener
    implements AntProjectListener {
        private PhpAntProjectListener() {
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            PhpProject.this.name = null;
        }

        public void propertiesChanged(AntProjectEvent ev) {
        }
    }

    private final class ProjectPropertiesListener
    implements PropertyChangeListener {
        private ProjectPropertiesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("ignore.path".equals(propertyName)) {
                PhpProject.this.fireIgnoredFilesChange();
            } else if ("web.root".equals(propertyName) || "src.dir".equals(propertyName)) {
                FileObject oldWebRoot = PhpProject.this.webRootDirectory;
                PhpProject.this.webRootDirectory = null;
                PhpProject.this.propertyChangeSupport.firePropertyChange(PhpProject.PROP_WEB_ROOT, oldWebRoot, PhpProject.this.getWebRootDirectory());
            }
        }
    }

    private final class SourceDirectoryFileChangeListener
    implements FileChangeListener {
        private volatile FileObject sourceDir;

        private SourceDirectoryFileChangeListener() {
        }

        @CheckForNull
        public FileObject getSourceDir() {
            return this.sourceDir;
        }

        public void setSourceDir(FileObject sourceDir) {
            this.sourceDir = sourceDir;
        }

        public void fileFolderCreated(FileEvent fe) {
            FileObject file = fe.getFile();
            if (!this.isVisible(file)) {
                return;
            }
            this.frameworksReset(file);
            this.processChange(file);
        }

        public void fileDataCreated(FileEvent fe) {
            FileObject file = fe.getFile();
            if (!this.isVisible(file)) {
                return;
            }
            this.frameworksReset(file);
            this.browserReload(file);
            this.processChange(file);
        }

        public void fileChanged(FileEvent fe) {
            FileObject file = fe.getFile();
            if (!this.isVisible(file)) {
                return;
            }
            this.browserReload(file);
            this.processChange(file);
        }

        public void fileDeleted(FileEvent fe) {
            FileObject file = fe.getFile();
            if (!this.isVisible(file)) {
                return;
            }
            this.frameworksReset(file);
            this.browserReload(file);
            this.processChange(file);
        }

        public void fileRenamed(FileRenameEvent fe) {
            FileObject file = fe.getFile();
            if (!this.isVisible(file)) {
                return;
            }
            this.frameworksReset(file);
            this.processChange(file, fe.getName(), fe.getExt());
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        private boolean isVisible(FileObject file) {
            return PhpProjectUtils.isVisible(PhpVisibilityQuery.forProject(PhpProject.this), file);
        }

        private void frameworksReset(FileObject file) {
            FileObject sourcesDirectory = PhpProject.this.getSourcesDirectory();
            if (sourcesDirectory == null) {
                return;
            }
            if (file.getParent().equals(sourcesDirectory)) {
                LOGGER.fine("file change, frameworks back to null");
                PhpProject.this.resetFrameworks();
            }
        }

        private void browserReload(FileObject file) {
            ClientSideDevelopmentSupport easelSupport = (ClientSideDevelopmentSupport)PhpProject.this.getLookup().lookup(ClientSideDevelopmentSupport.class);
            assert (easelSupport != null);
            easelSupport.reload(file);
        }

        private void processChange(FileObject fileObject) {
            CssPreprocessors.getDefault().process((Project)PhpProject.this, fileObject);
        }

        private void processChange(FileObject fileObject, String originalName, String originalExtension) {
            CssPreprocessors.getDefault().process((Project)PhpProject.this, fileObject, originalName, originalExtension);
        }
    }

    private static final class ConfigPropertyProvider
    extends FilterPropertyProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator baseEval;
        private final String prefix;
        private final AntProjectHelper helper;

        public ConfigPropertyProvider(PropertyEvaluator baseEval, String prefix, AntProjectHelper helper) {
            super(ConfigPropertyProvider.computeDelegate(baseEval, prefix, helper));
            this.baseEval = baseEval;
            this.prefix = prefix;
            this.helper = helper;
            baseEval.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if ("config".equals(ev.getPropertyName())) {
                this.setDelegate(ConfigPropertyProvider.computeDelegate(this.baseEval, this.prefix, this.helper));
            }
        }

        private static PropertyProvider computeDelegate(PropertyEvaluator baseEval, String prefix, AntProjectHelper helper) {
            String config = baseEval.getProperty("config");
            if (config != null) {
                return helper.getPropertyProvider(prefix + "/" + config + ".properties");
            }
            return PropertyUtils.fixedPropertyProvider(Collections.emptyMap());
        }
    }

    private final class SeleniumProvider
    implements PhpSeleniumProvider {
        private SeleniumProvider() {
        }

        @Override
        public FileObject getTestDirectory(boolean showCustomizer) {
            return ProjectPropertiesSupport.getSeleniumDirectory(PhpProject.this, showCustomizer);
        }

        @Override
        public void runAllTests() {
            ConfigAction.get(ConfigAction.Type.SELENIUM, PhpProject.this).runProject();
        }

        @Override
        public boolean isSupportEnabled(FileObject[] activatedFOs) {
            if (activatedFOs.length == 0) {
                return false;
            }
            PhpProject onlyOneProjectAllowed = null;
            for (FileObject fileObj : activatedFOs) {
                if (fileObj == null) {
                    return false;
                }
                if (fileObj.isData() && !FileUtils.isPhpFile((FileObject)fileObj)) {
                    return false;
                }
                PhpProject phpProject = PhpProjectUtils.getPhpProject(fileObj);
                if (phpProject == null) {
                    return false;
                }
                if (PhpProjectValidator.isFatallyBroken(phpProject)) {
                    return false;
                }
                if (onlyOneProjectAllowed == null) {
                    onlyOneProjectAllowed = phpProject;
                } else if (!onlyOneProjectAllowed.equals(phpProject)) {
                    return false;
                }
                if (fileObj == phpProject.getProjectDirectory()) {
                    return true;
                }
                FileObject sources = ProjectPropertiesSupport.getSourcesDirectory(phpProject);
                if (sources == null || sources.equals(fileObj)) {
                    return false;
                }
                if (CommandUtils.isUnderSources(phpProject, fileObj) && !CommandUtils.isUnderTests(phpProject, fileObj, false) && !CommandUtils.isUnderSelenium(phpProject, fileObj, false)) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<Object> getTestSourceRoots(Collection<SourceGroup> createdSourceRoots, FileObject refFileObject) {
            ArrayList<Object> folders = new ArrayList<Object>();
            Project p = FileOwnerQuery.getOwner((FileObject)refFileObject);
            if (p instanceof PhpProject) {
                SourceGroup[] sourceGroups;
                List<FileObject> seleniumDirectories = ProjectPropertiesSupport.getSeleniumDirectories((PhpProject)p, true);
                for (SourceGroup sg : sourceGroups = PhpProjectUtils.getSourceGroups((PhpProject)p)) {
                    if (sg.contains(refFileObject) || !seleniumDirectories.contains(sg.getRootFolder())) continue;
                    folders.add(sg);
                }
            }
            return folders;
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        private Info() {
        }

        public String getDisplayName() {
            return PhpProject.this.getName();
        }

        public Icon getIcon() {
            return ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)PhpProject.PROJECT_ICON));
        }

        public String getName() {
            return PropertyUtils.getUsablePropertyName((String)this.getDisplayName());
        }

        public Project getProject() {
            return PhpProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        void firePropertyChange(String prop) {
            this.propertyChangeSupport.firePropertyChange(prop, null, null);
        }
    }

    private final class PhpOpenedHook
    extends ProjectOpenedHook {
        private PhpOpenedHook() {
        }

        protected void projectOpened() {
            JsTestingProvider jsTestingProvider;
            new ProjectUpgrader(PhpProject.this).upgrade();
            PhpProject.this.addSourceDirListener();
            CssPreprocessors.getDefault().addCssPreprocessorsListener(PhpProject.this.cssPreprocessorsListener);
            PhpProject.this.frameworks.projectOpened();
            this.readFolders();
            PhpProject.this.getTestingProviders();
            PhpDocumentations.getDocumentations();
            PhpProject.this.getName();
            PhpOptions.getInstance().ensurePhpGlobalIncludePath();
            ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)PhpProject.this.lookup.lookup(ClassPathProviderImpl.class);
            ClassPath[] bootClassPaths = cpProvider.getProjectClassPaths("classpath/php-boot");
            GlobalPathRegistry.getDefault().register("classpath/php-boot", bootClassPaths);
            GlobalPathRegistry.getDefault().register("classpath/php-project-boot", cpProvider.getProjectClassPaths("classpath/php-project-boot"));
            GlobalPathRegistry.getDefault().register("classpath/php-source", cpProvider.getProjectClassPaths("classpath/php-source"));
            for (ClassPath classPath : bootClassPaths) {
                IncludePathClassPathProvider.addProjectIncludePath(classPath);
            }
            PhpCoverageProvider coverageProvider = (PhpCoverageProvider)PhpProject.this.getLookup().lookup(PhpCoverageProvider.class);
            if (coverageProvider.isEnabled()) {
                PhpCoverageProvider.notifyProjectOpened(PhpProject.this);
            }
            if ((jsTestingProvider = JsTestingProviders.getDefault().getJsTestingProvider((Project)PhpProject.this, false)) != null) {
                jsTestingProvider.projectOpened((Project)PhpProject.this);
            }
            this.checkAutoconfigured();
            ComputeTestMethodAnnotations.getInstance().register();
            PhpProject.this.getCopySupport().projectOpened();
            PhpProjectUtils.logUsage(PhpProject.class, "USG_PROJECT_OPEN_PHP", Arrays.asList(PhpProjectUtils.getFrameworksForUsage(PhpProject.this.frameworks.getFrameworks())));
            LOGGER.finest("PROJECT_OPENED_FINISHED");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void projectClosed() {
            try {
                PhpProject.this.removeSourceDirListener();
                CssPreprocessors.getDefault().removeCssPreprocessorsListener(PhpProject.this.cssPreprocessorsListener);
                PhpProject.this.frameworks.projectClosed();
                ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)PhpProject.this.lookup.lookup(ClassPathProviderImpl.class);
                ClassPath[] bootClassPaths = cpProvider.getProjectClassPaths("classpath/php-boot");
                GlobalPathRegistry.getDefault().unregister("classpath/php-boot", bootClassPaths);
                GlobalPathRegistry.getDefault().unregister("classpath/php-project-boot", cpProvider.getProjectClassPaths("classpath/php-project-boot"));
                GlobalPathRegistry.getDefault().unregister("classpath/php-source", cpProvider.getProjectClassPaths("classpath/php-source"));
                for (ClassPath classPath : bootClassPaths) {
                    IncludePathClassPathProvider.removeProjectIncludePath(classPath);
                }
                ((InternalWebServer)PhpProject.this.lookup.lookup(InternalWebServer.class)).stop();
                ((ClientSideDevelopmentSupport)PhpProject.this.lookup.lookup(ClientSideDevelopmentSupport.class)).close();
                JsTestingProvider jsTestingProvider = JsTestingProviders.getDefault().getJsTestingProvider((Project)PhpProject.this, false);
                if (jsTestingProvider != null) {
                    jsTestingProvider.projectClosed((Project)PhpProject.this);
                }
            }
            finally {
                ComputeTestMethodAnnotations.getInstance().unregister();
                PhpProject.this.getCopySupport().projectClosed();
                LOGGER.finest("PROJECT_CLOSED_FINISHED");
            }
        }

        private void readFolders() {
            PhpProject.this.webRootDirectory = null;
            PhpProject.this.resetIgnoredFolders();
            PhpProject.this.getIgnoredFiles();
            PhpProject.this.getSourceRoots().getRoots();
            PhpProject.this.getTestRoots().getRoots();
            PhpProject.this.getSeleniumRoots().getRoots();
        }

        private void checkAutoconfigured() {
            PhpProjectProperties projectProperties = new PhpProjectProperties(PhpProject.this);
            if (projectProperties.isAutoconfigured()) {
                NotificationDisplayer.getDefault().notify(Bundle.PhpOpenedHook_notification_autoconfigured_title(ProjectUtils.getInformation((Project)PhpProject.this).getDisplayName()), NotificationDisplayer.Priority.LOW.getIcon(), Bundle.PhpOpenedHook_notification_autoconfigured_details(), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PhpProjectUtils.openCustomizer(PhpProject.this, "Sources");
                    }
                }, NotificationDisplayer.Priority.LOW);
                projectProperties.setAutoconfigured(false);
                projectProperties.save();
            }
        }
    }

    public final class PhpProjectXmlSavedHook
    extends ProjectXmlSavedHook {
        protected void projectXmlSaved() throws IOException {
            Info info = (Info)PhpProject.this.getLookup().lookup(Info.class);
            assert (info != null);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    private static final class PhpSearchInfo
    extends SearchInfoDefinition
    implements PropertyChangeListener {
        private static final Logger LOGGER = Logger.getLogger(PhpSearchInfo.class.getName());
        private final PhpProject project;
        private SearchInfo delegate = null;

        private PhpSearchInfo(PhpProject project) {
            this.project = project;
        }

        public static SearchInfoDefinition create(PhpProject project) {
            PhpSearchInfo phpSearchInfo = new PhpSearchInfo(project);
            project.getSourceRoots().addPropertyChangeListener(phpSearchInfo);
            project.getTestRoots().addPropertyChangeListener(phpSearchInfo);
            project.getSeleniumRoots().addPropertyChangeListener(phpSearchInfo);
            return phpSearchInfo;
        }

        private SearchInfo createDelegate() {
            SearchInfo searchInfo = SearchInfoUtils.createSearchInfoForRoots((FileObject[])this.getRoots(), (boolean)false, (SearchFilterDefinition[])new SearchFilterDefinition[]{this.project.getSearchFilterDefinition(), SearchInfoDefinitionFactory.SHARABILITY_FILTER});
            return searchInfo;
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator<FileObject> filesToSearch(SearchScopeOptions searchScopeOptions, SearchListener listener, AtomicBoolean terminated) {
            return this.getDelegate().getFilesToSearch(searchScopeOptions, listener, terminated).iterator();
        }

        public List<SearchRoot> getSearchRoots() {
            return this.getDelegate().getSearchRoots();
        }

        private FileObject[] getRoots() {
            LinkedList<FileObject> roots = new LinkedList<FileObject>();
            this.addRoots(roots, this.project.getSourceRoots());
            this.addRoots(roots, this.project.getTestRoots());
            this.addRoots(roots, this.project.getSeleniumRoots());
            this.addIncludePath(roots, PhpSourcePath.getIncludePath(this.project.getSourcesDirectory()));
            return roots.toArray(new FileObject[0]);
        }

        private void addRoots(List<FileObject> roots, SourceRoots sourceRoots) {
            for (FileObject root : sourceRoots.getRoots()) {
                if (!root.isFolder()) {
                    LOGGER.log(Level.WARNING, "Not folder {0} for source roots {1}", new Object[]{root, Arrays.toString(sourceRoots.getRootNames())});
                    continue;
                }
                roots.add(root);
            }
        }

        private void addIncludePath(List<FileObject> roots, List<FileObject> includePath) {
            for (FileObject folder : includePath) {
                if (!folder.isFolder()) {
                    LOGGER.log(Level.WARNING, "Not folder {0} for Include path {1}", new Object[]{folder, includePath});
                    continue;
                }
                roots.add(folder);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (SourceRoots.PROP_ROOTS.equals(evt.getPropertyName())) {
                PhpSearchInfo phpSearchInfo = this;
                synchronized (phpSearchInfo) {
                    this.delegate = this.createDelegate();
                }
            }
        }

        private synchronized SearchInfo getDelegate() {
            if (this.delegate == null) {
                this.delegate = this.createDelegate();
            }
            return this.delegate;
        }
    }

    private final class PhpSubTreeSearchOptions
    extends SubTreeSearchOptions {
        private List<SearchFilterDefinition> filterList = this.createList();

        public List<SearchFilterDefinition> getFilters() {
            return this.filterList;
        }

        private List<SearchFilterDefinition> createList() {
            ArrayList<SearchFilterDefinition> list = new ArrayList<SearchFilterDefinition>(2);
            list.add(PhpProject.this.getSearchFilterDefinition());
            list.add(SearchInfoDefinitionFactory.SHARABILITY_FILTER);
            return Collections.unmodifiableList(list);
        }
    }

    private static final class PhpTestingProvidersImpl
    implements PhpTestingProviders {
        private final TestingProviders testingProviders;

        public PhpTestingProvidersImpl(TestingProviders testingProviders) {
            assert (testingProviders != null);
            this.testingProviders = testingProviders;
        }

        public List<PhpTestingProvider> getEnabledTestingProviders() {
            return this.testingProviders.getTestingProviders();
        }
    }

    private final class ProjectWebRootProviderImpl
    implements ProjectWebRootProvider {
        private ProjectWebRootProviderImpl() {
        }

        public FileObject getWebRoot(FileObject file) {
            FileObject webRoot = ProjectPropertiesSupport.getWebRootDirectory(PhpProject.this);
            if (webRoot == null) {
                return null;
            }
            if (webRoot.equals(file) || FileUtil.isParentOf((FileObject)webRoot, (FileObject)file)) {
                return webRoot;
            }
            return null;
        }

        public Collection<FileObject> getWebRoots() {
            FileObject webRoot = ProjectPropertiesSupport.getWebRootDirectory(PhpProject.this);
            if (webRoot == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(webRoot);
        }
    }

    public static final class ClientSideDevelopmentSupport
    implements ServerURLMappingImplementation,
    PageInspectorCustomizer,
    PropertyChangeListener {
        private static final RequestProcessor RP = new RequestProcessor(ClientSideDevelopmentSupport.class);
        private final UsageLogger browserUsageLogger = UsageLogger.projectBrowserUsageLogger((String)"org.netbeans.ui.metrics.php");
        final PhpProject project;
        private final RequestProcessor.Task reloadTask;
        private volatile String projectRootUrl;
        private volatile String browserId;
        private volatile Boolean browserReloadOnSave = null;
        private BrowserSupport browserSupport = null;
        private boolean browserSupportInitialized = false;
        volatile JButton customizerButton = null;

        private ClientSideDevelopmentSupport(PhpProject project) {
            assert (project != null);
            this.project = project;
            this.reloadTask = RP.create(new Runnable(){

                @Override
                public void run() {
                    this.reload();
                }
            });
        }

        public static ClientSideDevelopmentSupport create(PhpProject project) {
            ClientSideDevelopmentSupport serverMapping = new ClientSideDevelopmentSupport(project);
            ProjectPropertiesSupport.addWeakPropertyEvaluatorListener(project, serverMapping);
            return serverMapping;
        }

        public URL toServer(int projectContext, FileObject projectFile) {
            this.initProjectUrl();
            if (this.projectRootUrl == null) {
                return null;
            }
            FileObject webRoot = this.project.getWebRootDirectory();
            if (webRoot == null) {
                return null;
            }
            String relPath = FileUtil.getRelativePath((FileObject)webRoot, (FileObject)projectFile);
            if (relPath == null) {
                return null;
            }
            try {
                URL u = new URL(this.projectRootUrl + relPath);
                WebBrowser browser = this.getWebBrowser();
                if (browser != null) {
                    u = browser.toBrowserURL((Project)this.project, projectFile, u);
                }
                return u;
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }

        public FileObject fromServer(int projectContext, URL serverURL) {
            String url;
            if ((serverURL = WebUtils.stringToUrl((String)WebUtils.urlToString((URL)serverURL, (boolean)true))) == null) {
                return null;
            }
            this.initProjectUrl();
            if (this.projectRootUrl == null) {
                return null;
            }
            FileObject webRoot = this.project.getWebRootDirectory();
            if (webRoot == null) {
                return null;
            }
            WebBrowser browser = this.getWebBrowser();
            if (browser != null) {
                serverURL = browser.fromBrowserURL((Project)this.project, serverURL);
            }
            if ((url = CommandUtils.urlToString(serverURL, true)).startsWith(this.projectRootUrl)) {
                return webRoot.getFileObject(url.substring(this.projectRootUrl.length()));
            }
            return null;
        }

        public boolean isHighlightSelectionEnabled() {
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        public void showFileUrl(URL url, FileObject file) {
            BrowserSupport support;
            WebBrowser browser = this.getWebBrowser();
            if (browser != null) {
                url = browser.toBrowserURL((Project)this.project, file, url);
            }
            if ((support = this.getBrowserSupport()) != null) {
                support.load(url, file);
            } else {
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            }
            if (browser == null) {
                browser = BrowserUISupport.getDefaultBrowserChoice((boolean)true);
            }
            this.browserUsageLogger.log(new Object[]{"org.netbeans.modules.php.project", browser.getId(), browser.getBrowserFamily().name()});
        }

        private void initProjectUrl() {
            if (this.projectRootUrl == null) {
                this.projectRootUrl = this.getProjectRootUrl();
            }
        }

        private String getProjectRootUrl() {
            try {
                Object url = CommandUtils.urlToString(CommandUtils.getBaseURL(this.project, true), true);
                if (!((String)url).endsWith("/")) {
                    url = (String)url + "/";
                }
                return url;
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }

        public boolean canReload(FileObject fo) {
            this.initBrowser();
            DebugStarter debugStarter = DebugStarterFactory.getInstance();
            if (debugStarter != null && debugStarter.isAlreadyRunning()) {
                return false;
            }
            BrowserSupport support = this.getBrowserSupport();
            if (support == null || support.ignoreChange(fo)) {
                return false;
            }
            return this.browserReloadOnSave;
        }

        public void reload(FileObject file) {
            if (this.canReload(file)) {
                this.reloadTask.schedule(200);
            }
        }

        void reload() {
            assert (RP.isRequestProcessorThread());
            BrowserSupport support = this.getBrowserSupport();
            if (support == null) {
                return;
            }
            if (!support.isWebBrowserPaneOpen()) {
                return;
            }
            if (!this.project.getCopySupport().waitFinished(Bundle.ClientSideDevelopmentSupport_reload_copySupportRunning(), 5000L, this.getCustomizerButton())) {
                return;
            }
            support.reload();
        }

        public void close() {
            BrowserSupport support = this.getBrowserSupport();
            if (support != null) {
                support.close(true);
            }
        }

        private JButton getCustomizerButton() {
            if (this.customizerButton != null) {
                return this.customizerButton;
            }
            this.customizerButton = (JButton)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<JButton>(){

                public JButton run() {
                    assert (EventQueue.isDispatchThread());
                    JButton button = new JButton(Bundle.ClientSideDevelopmentSupport_reload_customize());
                    button.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PhpProjectUtils.openCustomizer(project, "Browser");
                        }
                    });
                    return button;
                }
            });
            return this.customizerButton;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("url".equals(propertyName)) {
                this.projectRootUrl = null;
            } else if ("browser.id".equals(propertyName)) {
                this.browserUsageLogger.reset();
                this.resetBrowser();
                this.resetBrowserSupport();
            } else if ("browser.reload.on.save".equals(propertyName)) {
                this.resetBrowserReloadOnSave();
            }
        }

        private void initBrowser() {
            if (this.browserId == null) {
                this.browserId = this.project.getEvaluator().getProperty("browser.id");
            }
            if (this.browserReloadOnSave == null) {
                WebBrowser browser;
                this.browserReloadOnSave = this.browserId == null ? Boolean.valueOf(false) : ((browser = BrowserUISupport.getBrowser((String)this.browserId)) != null && browser.hasNetBeansIntegration() ? Boolean.valueOf(ProjectPropertiesSupport.getBrowserReloadOnSave(this.project)) : Boolean.valueOf(false));
            }
            assert (this.browserReloadOnSave != null);
        }

        private void resetBrowser() {
            this.browserId = null;
            this.resetBrowserReloadOnSave();
        }

        private void resetBrowserReloadOnSave() {
            this.browserReloadOnSave = null;
        }

        private synchronized void resetBrowserSupport() {
            if (this.browserSupport != null) {
                this.browserSupport.close(false);
            }
            this.browserSupport = null;
            this.browserSupportInitialized = false;
        }

        private synchronized BrowserSupport getBrowserSupport() {
            if (this.browserSupportInitialized) {
                return this.browserSupport;
            }
            this.browserSupportInitialized = true;
            WebBrowser browser = this.getWebBrowser();
            if (browser == null) {
                this.browserSupport = null;
                return null;
            }
            this.browserSupport = BrowserSupport.create((WebBrowser)browser);
            return this.browserSupport;
        }

        @CheckForNull
        private WebBrowser getWebBrowser() {
            this.initBrowser();
            if (this.browserId == null) {
                return null;
            }
            return BrowserUISupport.getBrowser((String)this.browserId);
        }
    }
}

