/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sync;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.project.connections.sync.Bundle;
import org.netbeans.modules.php.project.connections.sync.SummaryPanel;
import org.netbeans.modules.php.project.connections.sync.SyncItem;
import org.netbeans.modules.php.project.connections.sync.SyncPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ProgressPanel
extends JPanel {
    private static final long serialVersionUID = -46789965146754L;
    private static final int NO_SYNC_UNITS = 1;
    final SummaryPanel summaryPanel;
    final ProgressHandle progressHandle;
    volatile boolean syncRunning = false;
    JButton actionButton = null;
    NotificationLineSupport notificationLineSupport = null;
    Dialog dialog = null;
    JLabel progressMessageLabel = null;
    volatile boolean error = false;
    private int workUnits = 0;
    private JCheckBox autoCloseCheckBox;
    private JPanel progressMessagePanelHolder;
    private JPanel progressPanelHolder;
    private JPanel summaryPanelHolder;

    public ProgressPanel(SyncPanel.SyncInfo syncInfo) {
        assert (SwingUtilities.isEventDispatchThread());
        assert (syncInfo != null);
        this.summaryPanel = new SummaryPanel(syncInfo.upload, syncInfo.download, syncInfo.delete, syncInfo.noop);
        this.progressHandle = ProgressHandle.createHandle((String)Bundle.ProgressPanel_progress_title());
        this.progressMessageLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)this.progressHandle);
        this.progressMessageLabel.setText(" ");
        this.initComponents();
        this.summaryPanelHolder.add((Component)this.summaryPanel, "Center");
        this.progressPanelHolder.add((Component)ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progressHandle), "Center");
        this.progressMessagePanelHolder.add((Component)this.progressMessageLabel, "Center");
        this.revalidate();
        this.repaint();
    }

    public void createPanel(AtomicBoolean cancel) {
        assert (SwingUtilities.isEventDispatchThread());
        this.actionButton = new JButton();
        this.actionButton.addActionListener(new ActionButtionListener(cancel));
        Mnemonics.setLocalizedText((AbstractButton)this.actionButton, (String)Bundle.ProgressPanel_button_cancel());
        DialogDescriptor descriptor = new DialogDescriptor((Object)this, Bundle.ProgressPanel_title(), true, new Object[]{this.actionButton}, (Object)this.actionButton, 0, null, null);
        descriptor.setValid(false);
        descriptor.setClosingOptions(new Object[0]);
        descriptor.setAdditionalOptions(new Object[]{this.autoCloseCheckBox});
        this.notificationLineSupport = descriptor.createNotificationLineSupport();
        this.dialog = DialogDisplayer.getDefault().createDialog(descriptor);
    }

    public void start(List<SyncItem> items) {
        this.syncRunning = true;
        int units = 0;
        for (SyncItem syncItem : items) {
            if (!syncItem.getOperation().hasProgress()) continue;
            units = (int)((long)units + syncItem.getSize() / 1000L);
        }
        this.progressHandle.start(units == 0 ? 1 : units);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressPanel.this.dialog.setVisible(true);
            }
        });
    }

    public void cancel() {
        this.finishInternal(Bundle.ProgressPanel_cancel(), true);
    }

    public void finish() {
        this.finishInternal(Bundle.ProgressPanel_success(), false);
    }

    private void finishInternal(final String message, final boolean cancel) {
        this.syncRunning = false;
        this.finishProgress(cancel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressPanel.this.progressMessageLabel.setText(Bundle.ProgressPanel_details_output());
                Mnemonics.setLocalizedText((AbstractButton)ProgressPanel.this.actionButton, (String)Bundle.ProgressPanel_button_ok());
                if (!ProgressPanel.this.error) {
                    if (ProgressPanel.this.autoCloseCheckBox.isSelected()) {
                        ProgressPanel.this.dialog.dispose();
                    } else if (cancel) {
                        ProgressPanel.this.notificationLineSupport.setWarningMessage(message);
                    } else {
                        ProgressPanel.this.notificationLineSupport.setInformationMessage(message);
                    }
                }
            }
        });
    }

    public void downloadErrorOccured() {
        this.summaryPanel.downloadError();
        this.errorOccurred();
    }

    public void uploadErrorOccured() {
        this.summaryPanel.uploadError();
        this.errorOccurred();
    }

    public void deleteErrorOccured() {
        this.summaryPanel.deleteError();
        this.errorOccurred();
    }

    private void errorOccurred() {
        if (this.error) {
            return;
        }
        this.error = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressPanel.this.notificationLineSupport.setErrorMessage(Bundle.ProgressPanel_error());
            }
        });
    }

    public void decreaseUploadNumber(SyncItem syncItem) {
        this.progress(syncItem, Bundle.ProgressPanel_uploading(syncItem.getName()));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressPanel.this.summaryPanel.decreaseUploadNumber();
            }
        });
    }

    public void decreaseDownloadNumber(SyncItem syncItem) {
        this.progress(syncItem, Bundle.ProgressPanel_downloading(syncItem.getName()));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressPanel.this.summaryPanel.decreaseDownloadNumber();
            }
        });
    }

    public void setDeleteNumber(final int number) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressPanel.this.summaryPanel.setDeleteNumber(number);
            }
        });
    }

    public void decreaseNoopNumber() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressPanel.this.summaryPanel.decreaseNoopNumber();
            }
        });
    }

    private void progress(SyncItem syncItem, String message) {
        if (syncItem.getOperation().hasProgress()) {
            this.workUnits = (int)((long)this.workUnits + syncItem.getSize() / 1000L);
            this.progressHandle.progress(message, this.workUnits);
        }
    }

    private void finishProgress(boolean cancel) {
        if (this.workUnits == 0) {
            this.progressHandle.progress(" ", 1);
        } else {
            this.progressHandle.progress(" ");
        }
        if (!cancel) {
            this.progressHandle.finish();
        }
    }

    private void initComponents() {
        this.autoCloseCheckBox = new JCheckBox();
        this.summaryPanelHolder = new JPanel();
        this.progressPanelHolder = new JPanel();
        this.progressMessagePanelHolder = new JPanel();
        Mnemonics.setLocalizedText((AbstractButton)this.autoCloseCheckBox, (String)NbBundle.getMessage(ProgressPanel.class, (String)"ProgressPanel.autoCloseCheckBox.text"));
        this.summaryPanelHolder.setLayout(new BorderLayout());
        this.progressPanelHolder.setLayout(new BorderLayout());
        this.progressMessagePanelHolder.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.summaryPanelHolder, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressPanelHolder, -1, 383, Short.MAX_VALUE).addComponent(this.progressMessagePanelHolder, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.summaryPanelHolder, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.progressPanelHolder, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressMessagePanelHolder, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private final class ActionButtionListener
    implements ActionListener {
        private final AtomicBoolean cancel;

        public ActionButtionListener(AtomicBoolean cancel) {
            this.cancel = cancel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ProgressPanel.this.syncRunning) {
                this.cancel.set(true);
            } else {
                ProgressPanel.this.progressHandle.finish();
                ProgressPanel.this.dialog.dispose();
            }
        }
    }
}

