/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer.files;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.web.clientproject.api.json.JsonFile;
import org.openide.filesystems.FileObject;

public final class ComposerLock {
    private static final Logger LOGGER = Logger.getLogger(ComposerLock.class.getName());
    public static final String FILE_NAME = "composer.lock";
    public static final String PROP_PACKAGES = "PACKAGES";
    public static final String PROP_PACKAGES_DEV = "PACKAGES_DEV";
    public static final String FIELD_PACKAGES = "packages";
    public static final String FIELD_PACKAGES_DEV = "packages-dev";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_VERSION = "version";
    private final JsonFile composerLock;

    public ComposerLock(FileObject directory) {
        this(directory, FILE_NAME);
    }

    ComposerLock(FileObject directory, String filename) {
        assert (directory != null);
        assert (filename != null);
        this.composerLock = new JsonFile(filename, directory, JsonFile.WatchedFields.create().add(PROP_PACKAGES, new String[]{FIELD_PACKAGES}).add(PROP_PACKAGES_DEV, new String[]{FIELD_PACKAGES_DEV}));
    }

    public File getFile() {
        return this.composerLock.getFile();
    }

    public boolean exists() {
        return this.composerLock.exists();
    }

    public void addPropertyChangeListener(PropertyChangeListener composerLockListener) {
        this.composerLock.addPropertyChangeListener(composerLockListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener composerLockListener) {
        this.composerLock.removePropertyChangeListener(composerLockListener);
    }

    public ComposerPackages getPackages() {
        List packages = (List)this.composerLock.getContentValue(List.class, new String[]{FIELD_PACKAGES});
        List packagesDev = (List)this.composerLock.getContentValue(List.class, new String[]{FIELD_PACKAGES_DEV});
        return new ComposerPackages(this.getPackages(packages), this.getPackages(packagesDev));
    }

    @CheckForNull
    private Map<String, String> getPackages(@NullAllowed List<Map<String, Object>> data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(data.size() * 2);
        for (Map<String, Object> pckg : data) {
            result.put(String.valueOf(pckg.get(FIELD_NAME)), String.valueOf(pckg.get(FIELD_VERSION)));
        }
        return result;
    }

    public static final class ComposerPackages {
        public final Map<String, String> packages = new ConcurrentHashMap<String, String>();
        public final Map<String, String> packagesDev = new ConcurrentHashMap<String, String>();

        ComposerPackages(@NullAllowed Map<String, String> packages, @NullAllowed Map<String, String> packagesDev) {
            if (packages != null) {
                this.packages.putAll(packages);
            }
            if (packagesDev != null) {
                this.packagesDev.putAll(packagesDev);
            }
        }

        public boolean isEmpty() {
            return this.packages.isEmpty() && this.packagesDev.isEmpty();
        }

        public int getCount() {
            return this.packages.size() + this.packagesDev.size();
        }

        public String toString() {
            return "ComposerPackages{packages=" + this.packages + ", packagesDev=" + this.packagesDev + "}";
        }
    }
}

