/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.codeception.preferences;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.codeception.CodeceptionTestingProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class CodeceptionPreferences {
    private static final String CUSTOM_CODECEPT_ENABLED = "custom.codecept.enabled";
    private static final String CUSTOM_CODECEPT_PATH = "custom.codecept.path";
    public static final String CUSTOM_CODECEPTION_YML_ENABLED = "custom.codeception.yml.enabled";
    public static final String CUSTOM_CODECEPTION_YML_PATH = "custom.codeception.yml.path";
    private static final String ASK_FOR_ADDITIONAL_PARAMS = "additional.params.ask";
    private static final ConcurrentMap<PhpModule, Preferences> CACHE = new ConcurrentHashMap<PhpModule, Preferences>();

    private CodeceptionPreferences() {
    }

    public static boolean isCustomCodeceptEnabled(PhpModule phpModule) {
        return CodeceptionPreferences.getPreference(phpModule).getBoolean(CUSTOM_CODECEPT_ENABLED, false);
    }

    public static void setCustomCodeceptEnabled(PhpModule phpModule, boolean customCodeceptEnabled) {
        CodeceptionPreferences.getPreference(phpModule).putBoolean(CUSTOM_CODECEPT_ENABLED, customCodeceptEnabled);
    }

    @CheckForNull
    public static String getCustomCodeceptPath(PhpModule phpModule) {
        return CodeceptionPreferences.resolvePath(phpModule, CodeceptionPreferences.getPreference(phpModule).get(CUSTOM_CODECEPT_PATH, null));
    }

    public static void setCustomCodeceptPath(PhpModule phpModule, String codeceptPath) {
        CodeceptionPreferences.getPreference(phpModule).put(CUSTOM_CODECEPT_PATH, CodeceptionPreferences.relativizePath(phpModule, codeceptPath));
    }

    public static boolean isCustomCodeceptionYmlEnabled(PhpModule phpModule) {
        return CodeceptionPreferences.getPreference(phpModule).getBoolean(CUSTOM_CODECEPTION_YML_ENABLED, false);
    }

    public static void setCustomCodeceptionYmlEnabled(PhpModule phpModule, boolean customCodeceptionYmlEnabled) {
        CodeceptionPreferences.getPreference(phpModule).putBoolean(CUSTOM_CODECEPTION_YML_ENABLED, customCodeceptionYmlEnabled);
    }

    @CheckForNull
    public static String getCustomCodeceptionYmlPath(PhpModule phpModule) {
        return CodeceptionPreferences.resolvePath(phpModule, CodeceptionPreferences.getPreference(phpModule).get(CUSTOM_CODECEPTION_YML_PATH, null));
    }

    public static void setCustomCodeceptionYmlPath(PhpModule phpModule, String codeceptPath) {
        CodeceptionPreferences.getPreference(phpModule).put(CUSTOM_CODECEPTION_YML_PATH, CodeceptionPreferences.relativizePath(phpModule, codeceptPath));
    }

    public static boolean askForAdditionalParameters(PhpModule phpModule) {
        return CodeceptionPreferences.getPreference(phpModule).getBoolean(ASK_FOR_ADDITIONAL_PARAMS, false);
    }

    public static void setAskForAdditionalParameters(PhpModule phpModule, boolean ask) {
        CodeceptionPreferences.getPreference(phpModule).putBoolean(ASK_FOR_ADDITIONAL_PARAMS, ask);
    }

    public static void addPreferenceChangeListener(PhpModule phpModule, PreferenceChangeListener listener) {
        CodeceptionPreferences.getPreference(phpModule).addPreferenceChangeListener(listener);
    }

    public static void removePreferenceChangeListener(PhpModule phpModule, PreferenceChangeListener listener) {
        CodeceptionPreferences.getPreference(phpModule).removePreferenceChangeListener(listener);
    }

    private static Preferences getPreference(PhpModule phpModule) {
        Preferences currentPreferences;
        Preferences preferences = (Preferences)CACHE.get(phpModule);
        if (preferences == null && (currentPreferences = CACHE.putIfAbsent(phpModule, preferences = phpModule.getPreferences(CodeceptionTestingProvider.class, true))) != null) {
            preferences = currentPreferences;
        }
        assert (preferences != null);
        return preferences;
    }

    private static String relativizePath(PhpModule phpModule, String filePath) {
        if (!StringUtils.hasText((String)filePath)) {
            return "";
        }
        File file = new File(filePath);
        String path = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)phpModule.getProjectDirectory()), (File)file);
        if (path == null) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    private static String resolvePath(PhpModule phpModule, String filePath) {
        if (!StringUtils.hasText((String)filePath)) {
            return null;
        }
        return PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)phpModule.getProjectDirectory()), (String)filePath).getAbsolutePath();
    }
}

