/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.analyzer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.php.analysis.commands.CodeSniffer;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.options.ValidatorCodeSnifferParameter;
import org.netbeans.modules.php.analysis.ui.AnalysisDefaultDocumentListener;
import org.netbeans.modules.php.analysis.ui.CodeSnifferStandardsComboBoxModel;
import org.netbeans.modules.php.analysis.util.AnalysisUiUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CodeSnifferCustomizerPanel
extends JPanel {
    private static final long serialVersionUID = 46872132457657L;
    private static final RequestProcessor RP = new RequestProcessor(CodeSnifferCustomizerPanel.class);
    public static final String ENABLED = "codeSniffer.enabled";
    public static final String PATH = "codeSniffer.path";
    public static final String STANDARD = "codeSniffer.standard";
    final CodeSnifferStandardsComboBoxModel standardsModel = new CodeSnifferStandardsComboBoxModel();
    final Analyzer.CustomizerContext<Void, CodeSnifferCustomizerPanel> context;
    final Preferences settings;
    private JButton codeSnifferBrowseButton;
    private JLabel codeSnifferLabel;
    private JButton codeSnifferSearchButton;
    private JTextField codeSnifferTextField;
    private JCheckBox enabledCheckBox;
    private JComboBox<String> standardComboBox;
    private JLabel standardLabel;

    public CodeSnifferCustomizerPanel(Analyzer.CustomizerContext<Void, CodeSnifferCustomizerPanel> context) {
        assert (context != null);
        this.context = context;
        this.settings = context.getSettings();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.initEnabledCheckBox();
        this.initCodeSnifferTextField();
        this.initStandardComboBox();
        RP.schedule(() -> EventQueue.invokeLater(() -> {
            this.setAllComponetsEnabled(this.enabledCheckBox.isSelected());
            this.context.setError(null);
            if (this.enabledCheckBox.isSelected()) {
                this.validateData();
            }
        }), 1000L, TimeUnit.MILLISECONDS);
    }

    private void initEnabledCheckBox() {
        assert (EventQueue.isDispatchThread());
        this.enabledCheckBox.setSelected(this.settings.getBoolean(ENABLED, false));
        this.enabledCheckBox.addItemListener(e -> {
            this.setAllComponetsEnabled(this.enabledCheckBox.isSelected());
            this.setCodeSnifferEnabled();
            if (!this.enabledCheckBox.isSelected()) {
                this.context.setError(null);
            } else {
                this.validateData();
            }
        });
    }

    private void initCodeSnifferTextField() {
        assert (EventQueue.isDispatchThread());
        this.codeSnifferTextField.setText(this.settings.get(PATH, AnalysisOptions.getInstance().getCodeSnifferPath()));
        this.codeSnifferTextField.getDocument().addDocumentListener(new AnalysisDefaultDocumentListener(() -> {
            String codeSnifferPath = this.getValidCodeSnifferPath();
            ValidationResult result = new AnalysisOptionsValidator().validateCodeSnifferPath(codeSnifferPath).getResult();
            if (this.validateData(result)) {
                this.setCodeSnifferPath();
                CodeSniffer.clearCachedStandards();
                this.setStandards(this.getCodeSnifferStandard(), codeSnifferPath);
            }
        }));
    }

    private void initStandardComboBox() {
        assert (EventQueue.isDispatchThread());
        this.standardComboBox.setModel(this.standardsModel);
        this.standardsModel.fetchStandards(this.standardComboBox, this.settings.get(PATH, null), () -> this.standardComboBox.addItemListener(e -> {
            if (this.enabledCheckBox.isSelected()) {
                this.validateAndSetStandard();
            }
        }));
        this.standardsModel.setSelectedItem(this.settings.get(STANDARD, AnalysisOptions.getInstance().getCodeSnifferStandard()));
    }

    void validateAndSetStandard() {
        if (this.validateData()) {
            this.setStandard();
        }
    }

    private boolean validateData(ValidationResult result) {
        if (result.hasErrors()) {
            this.context.setError(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            return false;
        }
        if (result.hasWarnings()) {
            this.context.setError(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            return false;
        }
        this.context.setError(null);
        return true;
    }

    private boolean validateData() {
        ValidationResult result = new AnalysisOptionsValidator().validateCodeSniffer(ValidatorCodeSnifferParameter.create(this)).getResult();
        return this.validateData(result);
    }

    public String getCodeSnifferPath() {
        return this.codeSnifferTextField.getText().trim();
    }

    @CheckForNull
    public String getValidCodeSnifferPath() {
        if (StringUtils.hasText((String)this.getCodeSnifferPath())) {
            return this.getCodeSnifferPath();
        }
        return AnalysisOptions.getInstance().getCodeSnifferPath();
    }

    @CheckForNull
    public String getCodeSnifferStandard() {
        if (!this.standardComboBox.isEnabled()) {
            return null;
        }
        return this.standardsModel.getSelectedStandard();
    }

    private void setStandard() {
        this.settings.put(STANDARD, this.standardsModel.getSelectedStandard());
    }

    private void setCodeSnifferEnabled() {
        this.settings.putBoolean(ENABLED, this.enabledCheckBox.isSelected());
    }

    private void setCodeSnifferPath() {
        this.settings.put(PATH, this.getCodeSnifferPath());
    }

    private void setAllComponetsEnabled(boolean isEnabled) {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (component == this.enabledCheckBox) continue;
            component.setEnabled(isEnabled);
        }
    }

    void setStandards(String selectedCodeSnifferStandard, String customCodeSnifferPath) {
        this.standardsModel.fetchStandards(this.standardComboBox, customCodeSnifferPath, null);
        this.standardsModel.setSelectedItem(selectedCodeSnifferStandard);
    }

    private void initComponents() {
        this.standardLabel = new JLabel();
        this.standardComboBox = new JComboBox();
        this.enabledCheckBox = new JCheckBox();
        this.codeSnifferLabel = new JLabel();
        this.codeSnifferTextField = new JTextField();
        this.codeSnifferBrowseButton = new JButton();
        this.codeSnifferSearchButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.standardLabel, (String)NbBundle.getMessage(CodeSnifferCustomizerPanel.class, (String)"CodeSnifferCustomizerPanel.standardLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.enabledCheckBox, (String)NbBundle.getMessage(CodeSnifferCustomizerPanel.class, (String)"CodeSnifferCustomizerPanel.enabledCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.codeSnifferLabel, (String)NbBundle.getMessage(CodeSnifferCustomizerPanel.class, (String)"CodeSnifferCustomizerPanel.codeSnifferLabel.text"));
        this.codeSnifferTextField.setText(NbBundle.getMessage(CodeSnifferCustomizerPanel.class, (String)"CodeSnifferCustomizerPanel.codeSnifferTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.codeSnifferBrowseButton, (String)NbBundle.getMessage(CodeSnifferCustomizerPanel.class, (String)"CodeSnifferCustomizerPanel.codeSnifferBrowseButton.text"));
        this.codeSnifferBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeSnifferCustomizerPanel.this.codeSnifferBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.codeSnifferSearchButton, (String)NbBundle.getMessage(CodeSnifferCustomizerPanel.class, (String)"CodeSnifferCustomizerPanel.codeSnifferSearchButton.text"));
        this.codeSnifferSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeSnifferCustomizerPanel.this.codeSnifferSearchButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.codeSnifferLabel).addComponent(this.standardLabel).addComponent(this.enabledCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.standardComboBox, -2, -1, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.codeSnifferTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeSnifferBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeSnifferSearchButton)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.enabledCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codeSnifferLabel).addComponent(this.codeSnifferTextField, -2, -1, -2).addComponent(this.codeSnifferBrowseButton).addComponent(this.codeSnifferSearchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.standardLabel).addComponent(this.standardComboBox, -2, -1, -2))));
    }

    private void codeSnifferBrowseButtonActionPerformed(ActionEvent evt) {
        File file = AnalysisUiUtils.browseCodeSniffer();
        if (file != null) {
            this.codeSnifferTextField.setText(file.getAbsolutePath());
        }
    }

    private void codeSnifferSearchButtonActionPerformed(ActionEvent evt) {
        String codeSniffer = AnalysisUiUtils.searchCodeSniffer();
        if (codeSniffer != null) {
            this.codeSnifferTextField.setText(codeSniffer);
        }
    }
}

