/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.atoum.coverage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.atoum.commands.Atoum;
import org.netbeans.modules.php.atoum.coverage.CloverLogParser;
import org.netbeans.modules.php.atoum.coverage.CoverageImpl;
import org.netbeans.modules.php.spi.testing.coverage.Coverage;
import org.netbeans.modules.php.spi.testing.run.TestRunInfo;

public final class CoverageProvider {
    private static final Logger LOGGER = Logger.getLogger(CoverageProvider.class.getName());
    private final PhpModule phpModule;

    public CoverageProvider(PhpModule phpModule) {
        assert (phpModule != null);
        this.phpModule = phpModule;
    }

    @CheckForNull
    public Coverage getCoverage(TestRunInfo runInfo) {
        CoverageImpl coverageImpl;
        assert (runInfo.isCoverageEnabled());
        Atoum atoum = Atoum.getForPhpModule(this.phpModule, false);
        if (atoum == null) {
            return null;
        }
        File coverageLog = atoum.getCoverageLog();
        if (coverageLog == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(coverageLog), StandardCharsets.UTF_8));
        try {
            coverageImpl = new CoverageImpl(CloverLogParser.parse(reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exc) {
                LOGGER.log(Level.WARNING, null, exc);
                return null;
            }
        }
        ((Reader)reader).close();
        return coverageImpl;
    }
}

