/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.util;

import java.awt.Image;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.ProjectProblems;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.ui.SearchPanel;
import org.netbeans.modules.php.api.util.Bundle;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class UiUtils {
    public static final String OPTIONS_PATH = "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory";
    public static final String FRAMEWORKS_AND_TOOLS_SUB_PATH = "FrameworksAndTools";
    public static final String FRAMEWORKS_AND_TOOLS_OPTIONS_PATH = "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools";
    public static final String CUSTOMIZER_PATH = "org-netbeans-modules-php-project";
    public static final String GENERAL_OPTIONS_SUBCATEGORY = "General";
    private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
    private static final String OPENED_ICON_KEY_UIMANAGER = "Tree.openIcon";
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";
    private static final String OPENED_ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.openedIcon";
    private static final String ICON_PATH = "org/netbeans/modules/php/api/ui/resources/defaultFolder.gif";
    private static final String OPENED_ICON_PATH = "org/netbeans/modules/php/api/ui/resources/defaultFolderOpen.gif";

    private UiUtils() {
    }

    public static void invalidScriptProvided(@NonNull String message) {
        UiUtils.invalidScriptProvided(message, null);
    }

    public static void invalidScriptProvided(@NonNull String message, @NullAllowed String optionsSubcategory) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        UiUtils.informAndOpenOptions((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0), optionsSubcategory);
    }

    public static void invalidScriptProvided(@NonNull PhpModule phpModule, @NonNull String customizerCategory, @NullAllowed String message) {
        Parameters.notNull((CharSequence)"phpModule", (Object)phpModule);
        Parameters.notNull((CharSequence)"customizerCategory", (Object)customizerCategory);
        NotifyDescriptor.Message descriptor = null;
        if (message != null) {
            descriptor = new NotifyDescriptor.Message((Object)message, 0);
        }
        UiUtils.openCustomizer(phpModule, customizerCategory, descriptor);
    }

    public static void processExecutionException(@NonNull ExecutionException exc) {
        UiUtils.processExecutionException(exc, null);
    }

    public static void processExecutionException(final @NonNull ExecutionException exc, final @NullAllowed String optionsSubcategory) {
        Parameters.notNull((CharSequence)"exc", (Object)exc);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UiUtils.informAndOpenOptions(UiUtils.createNotifyDescriptor(exc), optionsSubcategory);
            }
        });
    }

    public static void processExecutionException(final @NonNull ExecutionException exc, final @NonNull PhpModule phpModule, final @NonNull String customizerCategory) {
        Parameters.notNull((CharSequence)"exc", (Object)exc);
        Parameters.notNull((CharSequence)"phpModule", (Object)phpModule);
        Parameters.notNull((CharSequence)"customizerCategory", (Object)customizerCategory);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UiUtils.openCustomizer(phpModule, customizerCategory, UiUtils.createNotifyDescriptor(exc));
            }
        });
    }

    public static void showGeneralOptions() {
        UiUtils.showOptions(null);
    }

    public static void showOptions(@NullAllowed String optionsSubcategory) {
        String path = OPTIONS_PATH;
        if (!StringUtils.hasText(optionsSubcategory)) {
            optionsSubcategory = GENERAL_OPTIONS_SUBCATEGORY;
        }
        OptionsDisplayer.getDefault().open(path + "/" + optionsSubcategory);
    }

    public static Image getTreeFolderIcon(boolean opened) {
        Image base = (Image)UIManager.get(opened ? OPENED_ICON_KEY_UIMANAGER_NB : ICON_KEY_UIMANAGER_NB);
        if (base == null) {
            Icon baseIcon = UIManager.getIcon(opened ? OPENED_ICON_KEY_UIMANAGER : ICON_KEY_UIMANAGER);
            base = baseIcon != null ? ImageUtilities.icon2Image((Icon)baseIcon) : ImageUtilities.loadImage((String)(opened ? OPENED_ICON_PATH : ICON_PATH), (boolean)false);
        }
        return base;
    }

    public static void warnBrokenProject(PhpModule phpModule) {
        Parameters.notNull((CharSequence)"phpModule", (Object)phpModule);
        assert (phpModule.isBroken()) : "Not broken php module " + phpModule.getName();
        String name = phpModule.getDisplayName();
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)Bundle.UiUtils_metadata_corrupted(name), name, 0, 2);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.YES_OPTION) {
            Project project = FileOwnerQuery.getOwner((FileObject)phpModule.getProjectDirectory());
            assert (project != null) : "Must found project for " + phpModule.getProjectDirectory();
            ProjectProblems.showCustomizer((Project)project);
        }
    }

    static NotifyDescriptor createNotifyDescriptor(ExecutionException exc) {
        assert (exc != null);
        Throwable cause = exc.getCause();
        assert (cause != null);
        return new NotifyDescriptor.Message((Object)NbBundle.getMessage(UiUtils.class, (String)"MSG_ExceptionDuringRunScript", (Object)cause.getLocalizedMessage()), 0);
    }

    static void openCustomizer(@NonNull PhpModule phpModule, @NonNull String customizerCategory, @NullAllowed NotifyDescriptor descriptor) {
        assert (phpModule != null);
        assert (customizerCategory != null);
        if (descriptor != null) {
            DialogDisplayer.getDefault().notify(descriptor);
        }
        ((CustomizerProvider2)phpModule.getLookup().lookup(CustomizerProvider2.class)).showCustomizer(customizerCategory, null);
    }

    static void informAndOpenOptions(NotifyDescriptor descriptor, String optionsSubcategory) {
        assert (descriptor != null);
        DialogDisplayer.getDefault().notify(descriptor);
        UiUtils.showOptions(optionsSubcategory);
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PhpOptionsPanelRegistration {
        public String id();

        public String displayName();

        public String keywords() default "";

        public String keywordsCategory() default "";

        public int position() default 0x7FFFFFFF;
    }

    public static final class SearchWindow {
        private SearchWindow() {
        }

        @CheckForNull
        public static String search(SearchWindowSupport support) {
            Parameters.notNull((CharSequence)"support", (Object)support);
            SearchPanel panel = SearchPanel.create(support);
            if (panel.open()) {
                return panel.getSelectedItem();
            }
            return null;
        }

        public static interface SearchWindowSupport {
            public List<String> detect();

            public String getWindowTitle();

            public String getListTitle();

            public String getPleaseWaitPart();

            public String getNoItemsFound();
        }
    }
}

