/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.Parameters;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean hasText(String input) {
        return input != null && !input.trim().isEmpty();
    }

    public static boolean isEmpty(String input) {
        return input == null || input.isEmpty();
    }

    public static String implode(Collection<String> items, String delimiter) {
        Parameters.notNull((CharSequence)"items", items);
        Parameters.notNull((CharSequence)"delimiter", (Object)delimiter);
        if (items.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(200);
        boolean first = true;
        for (String s : items) {
            if (!first) {
                buffer.append(delimiter);
            }
            buffer.append(s);
            first = false;
        }
        return buffer.toString();
    }

    public static List<String> explode(@NullAllowed String string, String delimiter) {
        Parameters.notEmpty((CharSequence)"delimiter", (CharSequence)delimiter);
        if (!StringUtils.hasText(string)) {
            return Collections.emptyList();
        }
        assert (string != null);
        return Arrays.asList(string.split(Pattern.quote(delimiter)));
    }

    public static Pattern getPattern(String text) {
        Parameters.notNull((CharSequence)"text", (Object)text);
        return StringUtils.getPattern0(text, ".*", ".*");
    }

    public static Pattern getExactPattern(String text) {
        Parameters.notNull((CharSequence)"text", (Object)text);
        return StringUtils.getPattern0(text, "^", "$");
    }

    public static String webalize(String input) {
        StringBuilder sb = new StringBuilder(input.length() * 2);
        int dash = 45;
        int lastChar = 0;
        for (int i = 0; i < input.length(); ++i) {
            boolean addDash = false;
            int ch = input.charAt(i);
            if (Character.isLetterOrDigit((char)ch)) {
                if (Character.isUpperCase((char)ch)) {
                    addDash = true;
                    ch = Character.toLowerCase((char)ch);
                }
            } else {
                ch = 45;
            }
            if (ch == 45 && (lastChar == 45 || sb.length() == 0)) continue;
            if (addDash && lastChar != 45 && sb.length() > 0) {
                sb.append('-');
            }
            sb.append((char)ch);
            lastChar = ch;
        }
        if (lastChar == 45) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String capitalize(String input) {
        Parameters.notEmpty((CharSequence)"input", (CharSequence)input);
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public static String decapitalize(String input) {
        Parameters.notEmpty((CharSequence)"input", (CharSequence)input);
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    private static Pattern getPattern0(String text, String prefix, String suffix) {
        assert (text != null);
        assert (prefix != null);
        assert (suffix != null);
        if (text.contains("?") || text.contains("*")) {
            String pattern = text.replace("\\", "").replace(".", "\\.").replace("-", "\\-").replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("?", ".").replace("*", ".*");
            return Pattern.compile(prefix + pattern + suffix, 2);
        }
        return null;
    }
}

