/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.spi.executable;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public interface DebugStarter {
    public void start(Project var1, Callable<Cancellable> var2, Properties var3);

    public boolean isAlreadyRunning();

    public void stop();

    public static final class Properties {
        private final FileObject startFile;
        private final boolean closeSession;
        private final List<Pair<String, String>> pathMapping;
        private final Pair<String, Integer> debugProxy;
        private final String encoding;

        private Properties(Builder builder) {
            Parameters.notNull((CharSequence)"startFile", (Object)builder.startFile);
            Parameters.notNull((CharSequence)"pathMapping", (Object)builder.pathMapping);
            Parameters.notNull((CharSequence)"encoding", (Object)builder.encoding);
            this.startFile = builder.startFile;
            this.closeSession = builder.closeSession;
            this.pathMapping = builder.pathMapping;
            this.debugProxy = builder.debugProxy;
            this.encoding = builder.encoding;
        }

        public FileObject getStartFile() {
            return this.startFile;
        }

        public boolean isCloseSession() {
            return this.closeSession;
        }

        public List<Pair<String, String>> getPathMapping() {
            return this.pathMapping;
        }

        @CheckForNull
        public Pair<String, Integer> getDebugProxy() {
            return this.debugProxy;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public static final class Builder {
            private FileObject startFile;
            private boolean closeSession;
            private List<Pair<String, String>> pathMapping = Collections.emptyList();
            private Pair<String, Integer> debugProxy;
            private String encoding;

            public Builder setStartFile(@NonNull FileObject startFile) {
                this.startFile = startFile;
                return this;
            }

            public Builder setCloseSession(boolean closeSession) {
                this.closeSession = closeSession;
                return this;
            }

            public Builder setPathMapping(@NonNull List<Pair<String, String>> pathMapping) {
                this.pathMapping = pathMapping;
                return this;
            }

            public Builder setDebugProxy(@NullAllowed Pair<String, Integer> debugProxy) {
                this.debugProxy = debugProxy;
                return this;
            }

            public Builder setEncoding(@NonNull String encoding) {
                this.encoding = encoding;
                return this;
            }

            public Properties build() {
                return new Properties(this);
            }
        }
    }
}

