/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.server.config;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersionAPI;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;
import org.netbeans.modules.payara.tooling.server.config.Config;
import org.netbeans.modules.payara.tooling.server.config.ConfigBuilder;
import org.netbeans.modules.payara.tooling.server.config.ServerConfigException;

public class ConfigBuilderProvider {
    private static final Config.Next CONFIG_V4 = new Config.Next(4, ConfigBuilderProvider.class.getResource("PayaraV4.xml"));
    private static final Config.Next CONFIG_V5 = new Config.Next(5, ConfigBuilderProvider.class.getResource("PayaraV5.xml"));
    private static final Config.Next CONFIG_V6 = new Config.Next(6, ConfigBuilderProvider.class.getResource("PayaraV6.xml"));
    private static final Config config = new Config(CONFIG_V4, CONFIG_V5, CONFIG_V6);
    private static final Map<PayaraServer, ConfigBuilder> builders = new HashMap<PayaraServer, ConfigBuilder>();

    @Deprecated
    public static URL getBuilderConfig(PayaraVersion version) {
        return ConfigBuilderProvider.config.configFiles[ConfigBuilderProvider.config.index[version.ordinal()]];
    }

    public static URL getPlatformBuilderConfig(PayaraPlatformVersionAPI version) {
        return ConfigBuilderProvider.config.libraryConfigFiles.get(version.getMajor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigBuilder getBuilder(PayaraServer server) {
        ConfigBuilder builder;
        if (server == null) {
            throw new ServerConfigException("Payara server entity shall not be null");
        }
        Map<PayaraServer, ConfigBuilder> map = builders;
        synchronized (map) {
            builder = builders.get(server);
            if (builder != null) {
                return builder;
            }
            String serverHome = server.getServerHome();
            builder = new ConfigBuilder(config, serverHome, serverHome, serverHome);
            builders.put(server, builder);
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyBuilder(PayaraServer server) {
        if (server == null) {
            throw new ServerConfigException("Payara server entity shall not be null");
        }
        Map<PayaraServer, ConfigBuilder> map = builders;
        synchronized (map) {
            builders.remove(server);
        }
    }
}

