/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.payara.tooling.data.JDKVersion;
import org.netbeans.modules.payara.tooling.data.StartupArgs;
import org.openide.util.Exceptions;

public class StartupArgsEntity
implements StartupArgs {
    private List<String> payaraArgs;
    private List<String> javaArgs;
    private Map<String, String> environmentVars;
    private String javaHome;
    private JDKVersion javaVersion;

    public StartupArgsEntity() {
    }

    public StartupArgsEntity(List<String> payaraArgs, List<String> javaArgs, Map<String, String> environmentVars, String javaHome) {
        this.payaraArgs = payaraArgs;
        this.javaArgs = javaArgs;
        this.environmentVars = environmentVars;
        this.javaHome = javaHome;
    }

    @Override
    public List<String> getPayaraArgs() {
        return this.payaraArgs;
    }

    public void setPayaraArgs(List<String> payaraArgs) {
        this.payaraArgs = payaraArgs;
    }

    @Override
    public List<String> getJavaArgs() {
        return this.javaArgs;
    }

    public void getJavaArgs(List<String> javaArgs) {
        this.javaArgs = javaArgs;
    }

    @Override
    public Map<String, String> getEnvironmentVars() {
        return this.environmentVars;
    }

    public void setEnvironmentVars(Map<String, String> environmentVars) {
        this.environmentVars = environmentVars;
    }

    @Override
    public String getJavaHome() {
        return this.javaHome;
    }

    public void getJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    @Override
    public JDKVersion getJavaVersion() {
        if (this.javaVersion == null && this.javaHome != null) {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(this.javaHome, "release")));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    if (!line.startsWith("JAVA_VERSION")) continue;
                    this.javaVersion = JDKVersion.toValue(line.substring(line.indexOf("\"") + 1, line.lastIndexOf("\"")));
                    break;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this.javaVersion;
    }
}

