/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.eecommon.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomainEditor {
    private static final Logger LOGGER = Logger.getLogger("payara-eecommon");
    private static final String HTTP_PROXY_HOST = "-Dhttp.proxyHost=";
    private static final String HTTP_PROXY_PORT = "-Dhttp.proxyPort=";
    private static final String HTTPS_PROXY_HOST = "-Dhttps.proxyHost=";
    private static final String HTTPS_PROXY_PORT = "-Dhttps.proxyPort=";
    private static final String HTTP_PROXY_NO_HOST = "-Dhttp.nonProxyHosts=";
    private static String SAMPLE_DATASOURCE = "jdbc/__default";
    private static String SAMPLE_CONNPOOL = "H2Pool";
    private static String NBPROFILERNAME = "NetBeansProfiler";
    private static String CONST_USER = "User";
    private static String CONST_PASSWORD = "Password";
    private static String CONST_URL = "URL";
    private static String CONST_LOWER_DATABASE_NAME = "databaseName";
    private static String CONST_LOWER_PORT_NUMBER = "portNumber";
    private static String CONST_DATABASE_NAME = "DatabaseName";
    private static String CONST_PORT_NUMBER = "PortNumber";
    private static String CONST_SID = "SID";
    private static String CONST_SERVER_NAME = "serverName";
    private static String CONST_DRIVER_CLASS = "driverClass";
    private static String CONST_NAME = "name";
    private static String CONST_VALUE = "value";
    private static String CONST_DS_CLASS = "datasource-classname";
    private static String CONST_RES_TYPE = "res-type";
    private static String CONST_JVM_OPTIONS = "jvm-options";
    private static String CONST_JNDINAME = "jndi-name";
    private static String CONST_PROP = "property";
    private static String CONST_POOLNAME = "pool-name";
    private static String CONST_ENABLED = "enabled";
    private static String CONST_OBJTYPE = "object-type";
    private static String CONST_JDBC = "jdbc-resource";
    private static String CONST_CP = "jdbc-connection-pool";
    private static String CONST_AO = "admin-object-resource";
    private static String XML_ENTITY = "<?xml version=\"1.0\" encoding=\"{0}\"?>";
    private String dmLoc;
    private String dmName;
    static final String[] sysDatasources = new String[]{"jdbc/__TimerPool", "jdbc/__CallFlowPool"};

    public DomainEditor(String domainLocation, String domainName) {
        this.dmLoc = domainLocation;
        this.dmName = domainName;
    }

    public String getDomainLocation() {
        String domainScriptFilePath = this.dmLoc + "/" + this.dmName + "/config/domain.xml";
        return domainScriptFilePath;
    }

    public Document getDomainDocument() {
        String domainLoc = this.getDomainLocation();
        Document domainScriptDocument = this.getDomainDocument(domainLoc);
        return domainScriptDocument;
    }

    public Document getDomainDocument(String domainLoc) {
        Document domainScriptDocument = this.loadDomainScriptFile(domainLoc);
        return domainScriptDocument;
    }

    public boolean addProfilerElements(Document domainDoc, String nativeLibraryPath, String[] jvmOptions) {
        String domainPath = this.getDomainLocation();
        this.removeProfiler(domainDoc);
        if (nativeLibraryPath != null || jvmOptions != null) {
            NodeList javaConfigNodeList;
            Element profilerElement = domainDoc.createElement("profiler");
            profilerElement.setAttribute("enabled", "true");
            profilerElement.setAttribute(CONST_NAME, NBPROFILERNAME);
            if (nativeLibraryPath != null) {
                profilerElement.setAttribute("native-library-path", nativeLibraryPath);
            }
            if (jvmOptions != null) {
                for (int i = 0; i < jvmOptions.length; ++i) {
                    Element jvmOptionsElement = domainDoc.createElement(CONST_JVM_OPTIONS);
                    Text tt = domainDoc.createTextNode(this.formatJvmOption(jvmOptions[i]));
                    jvmOptionsElement.appendChild(tt);
                    profilerElement.appendChild(jvmOptionsElement);
                }
            }
            if ((javaConfigNodeList = domainDoc.getElementsByTagName("java-config")) == null || javaConfigNodeList.getLength() == 0) {
                LOGGER.log(Level.INFO, "Cannot find 'java-config' section in domain config file {0}", domainPath);
                return false;
            }
            Node javaConfigNode = javaConfigNodeList.item(0);
            if (javaConfigNode.getFirstChild() != null) {
                javaConfigNode.insertBefore(profilerElement, javaConfigNode.getFirstChild());
            } else {
                javaConfigNode.appendChild(profilerElement);
            }
        }
        return this.saveDomainScriptFile(domainDoc, domainPath);
    }

    public boolean removeProfilerElements(Document domainDoc) {
        boolean eleRemoved = this.removeProfiler(domainDoc);
        if (eleRemoved) {
            return this.saveDomainScriptFile(domainDoc, this.getDomainLocation());
        }
        return true;
    }

    private boolean removeProfiler(Document domainDoc) {
        NodeList profilerElementNodeList = domainDoc.getElementsByTagName("profiler");
        if (profilerElementNodeList != null && profilerElementNodeList.getLength() > 0) {
            int i;
            Vector<Node> nodes = new Vector<Node>();
            for (i = 0; i < profilerElementNodeList.getLength(); ++i) {
                Node n = profilerElementNodeList.item(i);
                Node a = n.getAttributes().getNamedItem(CONST_NAME);
                if (a == null || !a.getNodeValue().equals(NBPROFILERNAME)) continue;
                nodes.add(n);
            }
            for (i = 0; i < nodes.size(); ++i) {
                Node nd = (Node)nodes.get(i);
                nd.getParentNode().removeChild(nd);
            }
            return true;
        }
        return false;
    }

    public String[] getHttpProxyOptions() {
        ArrayList<String> httpProxyOptions = new ArrayList<String>();
        Document domainDoc = this.getDomainDocument();
        NodeList javaConfigNodeList = domainDoc.getElementsByTagName("java-config");
        if (javaConfigNodeList == null || javaConfigNodeList.getLength() == 0) {
            return httpProxyOptions.toArray(new String[httpProxyOptions.size()]);
        }
        NodeList jvmOptionNodeList = domainDoc.getElementsByTagName(CONST_JVM_OPTIONS);
        for (int i = 0; i < jvmOptionNodeList.getLength(); ++i) {
            Node childNode;
            String childValue;
            Node nd = jvmOptionNodeList.item(i);
            if (!nd.hasChildNodes() || (childValue = (childNode = nd.getFirstChild()).getNodeValue()).indexOf(HTTP_PROXY_HOST) == -1 && childValue.indexOf(HTTP_PROXY_PORT) == -1 && childValue.indexOf(HTTPS_PROXY_HOST) == -1 && childValue.indexOf(HTTPS_PROXY_PORT) == -1 && childValue.indexOf(HTTP_PROXY_NO_HOST) == -1) continue;
            httpProxyOptions.add(childValue);
        }
        String[] opts = new String[httpProxyOptions.size()];
        return httpProxyOptions.toArray(opts);
    }

    public boolean setHttpProxyOptions(String[] httpProxyOptions) {
        Document domainDoc = this.getDomainDocument();
        NodeList javaConfigNodeList = domainDoc.getElementsByTagName("java-config");
        if (javaConfigNodeList == null || javaConfigNodeList.getLength() == 0) {
            return false;
        }
        this.removeProxyOptions(domainDoc, javaConfigNodeList.item(0));
        for (int j = 0; j < httpProxyOptions.length; ++j) {
            String option = httpProxyOptions[j];
            Element jvmOptionsElement = domainDoc.createElement(CONST_JVM_OPTIONS);
            Text proxyOption = domainDoc.createTextNode(option);
            jvmOptionsElement.appendChild(proxyOption);
            javaConfigNodeList.item(0).appendChild(jvmOptionsElement);
        }
        return this.saveDomainScriptFile(domainDoc, this.getDomainLocation(), false);
    }

    private boolean removeProxyOptions(Document domainDoc, Node javaConfigNode) {
        int i;
        NodeList jvmOptionNodeList = domainDoc.getElementsByTagName(CONST_JVM_OPTIONS);
        Vector<Node> nodes = new Vector<Node>();
        for (i = 0; i < jvmOptionNodeList.getLength(); ++i) {
            Node childNode;
            String childValue;
            Node nd = jvmOptionNodeList.item(i);
            if (!nd.hasChildNodes() || (childValue = (childNode = nd.getFirstChild()).getNodeValue()).indexOf(HTTP_PROXY_HOST) == -1 && childValue.indexOf(HTTP_PROXY_PORT) == -1 && childValue.indexOf(HTTPS_PROXY_HOST) == -1 && childValue.indexOf(HTTPS_PROXY_PORT) == -1 && childValue.indexOf(HTTP_PROXY_NO_HOST) == -1) continue;
            nodes.add(nd);
        }
        for (i = 0; i < nodes.size(); ++i) {
            javaConfigNode.removeChild((Node)nodes.get(i));
        }
        return this.saveDomainScriptFile(domainDoc, this.getDomainLocation(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Document loadDomainScriptFile(String domainScriptFilePath) {
        Document document;
        InputStreamReader reader;
        block11: {
            reader = null;
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setValidating(false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            dBuilder.setEntityResolver(new InnerResolver());
            reader = new FileReader(new File(domainScriptFilePath));
            InputSource source = new InputSource(reader);
            document = dBuilder.parse(source);
            if (reader == null) break block11;
            try {
                reader.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Cannot close reader for {0}: {1}", new String[]{domainScriptFilePath, ex.getLocalizedMessage()});
            }
        }
        return document;
        catch (Exception e) {
            Document document2;
            block12: {
                try {
                    LOGGER.log(Level.WARNING, "Unable to parse domain config file {0}", domainScriptFilePath);
                    document2 = null;
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.INFO, "Cannot close reader for {0}: {1}", new String[]{domainScriptFilePath, ex.getLocalizedMessage()});
                        }
                    }
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, "Cannot close reader for {0}: {1}", new String[]{domainScriptFilePath, ex.getLocalizedMessage()});
                }
            }
            return document2;
        }
    }

    private boolean saveDomainScriptFile(Document domainScriptDocument, String domainScriptFilePath) {
        return this.saveDomainScriptFile(domainScriptDocument, domainScriptFilePath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveDomainScriptFile(Document domainScriptDocument, String domainScriptFilePath, boolean indent) {
        boolean result = false;
        OutputStreamWriter domainXmlWriter = null;
        Charset charset = Charset.defaultCharset();
        try {
            domainXmlWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(domainScriptFilePath), charset.name());
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                if (indent) {
                    transformer.setOutputProperty("indent", "yes");
                }
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("standalone", "no");
                if (domainScriptDocument.getDoctype() != null) {
                    transformer.setOutputProperty("doctype-public", domainScriptDocument.getDoctype().getPublicId());
                    transformer.setOutputProperty("doctype-system", domainScriptDocument.getDoctype().getSystemId());
                }
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                DOMSource domSource = new DOMSource(domainScriptDocument);
                StreamResult streamResult = new StreamResult(domainXmlWriter);
                transformer.transform(domSource, streamResult);
                result = true;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unable to save domain config file {0}", domainScriptFilePath);
                result = false;
            }
        }
        catch (IOException ioex) {
            LOGGER.log(Level.INFO, "Cannot create output stream for domain config file {0}", domainScriptFilePath);
            result = false;
        }
        finally {
            try {
                if (domainXmlWriter != null) {
                    domainXmlWriter.close();
                }
            }
            catch (IOException ioex2) {
                LOGGER.log(Level.INFO, "Cannot close output stream for {0}", domainScriptFilePath);
            }
        }
        return result;
    }

    private String formatJvmOption(String jvmOption) {
        if (jvmOption.indexOf("\"") != -1) {
            if (jvmOption.indexOf("\\\"") != -1 && jvmOption.indexOf("-agentpath") != -1) {
                String modifiedOption = jvmOption.replaceAll("\\\\\"", "#");
                modifiedOption = modifiedOption.replaceAll("\\\"", "");
                modifiedOption = modifiedOption.replaceAll("#", "\"");
                String osType = System.getProperty("os.name");
                if (osType.startsWith("Mac OS")) {
                    modifiedOption = "\"" + modifiedOption.replaceAll("\\\"", "\\\\\"") + "\"";
                }
                return modifiedOption;
            }
            return jvmOption.replace('\"', ' ');
        }
        return jvmOption;
    }

    public HashMap<String, Map> getSunDatasourcesFromXml() {
        HashMap<String, Map> dSources = new HashMap<String, Map>();
        Document domainDoc = this.getDomainDocument();
        if (domainDoc != null) {
            HashMap<String, NamedNodeMap> dsMap = this.getDataSourcesAttrMap(domainDoc);
            HashMap<String, Node> cpMap = this.getConnPoolsNodeMap(domainDoc);
            dsMap.keySet().removeAll(Arrays.asList(sysDatasources));
            String[] ds = dsMap.keySet().toArray(new String[dsMap.size()]);
            for (int i = 0; i < ds.length; ++i) {
                String jndiName = ds[i];
                NamedNodeMap dsAttrMap = dsMap.get(jndiName);
                String poolName = dsAttrMap.getNamedItem(CONST_POOLNAME).getNodeValue();
                dSources.put(jndiName, this.getPoolValues(cpMap, poolName));
            }
        }
        return dSources;
    }

    private Map<String, String> getPoolValues(Map<String, Node> cpMap, String poolName) {
        HashMap<String, String> pValues = new HashMap<String, String>();
        Node cpNode = cpMap.get(poolName);
        NamedNodeMap cpAttrMap = cpNode.getAttributes();
        Node dsClassName = cpAttrMap.getNamedItem(CONST_DS_CLASS);
        Node resType = cpAttrMap.getNamedItem(CONST_RES_TYPE);
        Element cpElement = (Element)cpNode;
        NodeList propsNodeList = cpElement.getElementsByTagName(CONST_PROP);
        HashMap<String, String> map = new HashMap<String, String>();
        for (int j = 0; j < propsNodeList.getLength(); ++j) {
            Node propNode = propsNodeList.item(j);
            NamedNodeMap propsMap = propNode.getAttributes();
            String mkey = propsMap.getNamedItem(CONST_NAME).getNodeValue();
            String mkeyValue = propsMap.getNamedItem(CONST_VALUE).getNodeValue();
            if (mkey.equalsIgnoreCase(CONST_USER)) {
                pValues.put(CONST_USER, mkeyValue);
                continue;
            }
            if (mkey.equalsIgnoreCase(CONST_PASSWORD)) {
                pValues.put(CONST_PASSWORD, mkeyValue);
                continue;
            }
            if (mkey.equalsIgnoreCase(CONST_URL)) {
                pValues.put(CONST_URL, mkeyValue);
                continue;
            }
            if (mkey.equalsIgnoreCase(CONST_SERVER_NAME)) {
                pValues.put(CONST_SERVER_NAME, mkeyValue);
                continue;
            }
            map.put(mkey, mkeyValue);
        }
        pValues.put(CONST_LOWER_DATABASE_NAME, (String)map.get(CONST_LOWER_DATABASE_NAME));
        pValues.put(CONST_PORT_NUMBER, (String)map.get(CONST_PORT_NUMBER));
        pValues.put(CONST_LOWER_PORT_NUMBER, (String)map.get(CONST_LOWER_PORT_NUMBER));
        pValues.put(CONST_DATABASE_NAME, (String)map.get(CONST_DATABASE_NAME));
        pValues.put(CONST_SID, (String)map.get(CONST_SID));
        pValues.put(CONST_DRIVER_CLASS, (String)map.get(CONST_DRIVER_CLASS));
        if (dsClassName != null) {
            pValues.put("dsClassName", dsClassName.getNodeValue());
        }
        if (resType != null) {
            pValues.put("resType", resType.getNodeValue());
        }
        return pValues;
    }

    public HashMap<String, Map> getConnPoolsFromXml() {
        HashMap<String, Map> pools = new HashMap<String, Map>();
        Document domainDoc = this.getDomainDocument();
        if (domainDoc != null) {
            HashMap<String, Node> cpMap = this.getConnPoolsNodeMap(domainDoc);
            String[] cp = cpMap.keySet().toArray(new String[cpMap.size()]);
            for (int i = 0; i < cp.length; ++i) {
                String name = cp[i];
                pools.put(name, this.getPoolValues(cpMap, name));
            }
        }
        return pools;
    }

    private HashMap<String, NamedNodeMap> getDataSourcesAttrMap(Document domainDoc) {
        HashMap<String, NamedNodeMap> dataSourceMap = new HashMap<String, NamedNodeMap>();
        this.updateWithSampleDataSource(domainDoc);
        NodeList dataSourceNodeList = domainDoc.getElementsByTagName(CONST_JDBC);
        for (int i = 0; i < dataSourceNodeList.getLength(); ++i) {
            Node dsNode = dataSourceNodeList.item(i);
            NamedNodeMap dsAttrMap = dsNode.getAttributes();
            String jndiName = dsAttrMap.getNamedItem(CONST_JNDINAME).getNodeValue();
            dataSourceMap.put(jndiName, dsAttrMap);
        }
        return dataSourceMap;
    }

    public void createSampleDatasource() {
        Document domainDoc = this.getDomainDocument();
        if (domainDoc != null) {
            this.updateWithSampleDataSource(domainDoc);
        }
    }

    private boolean updateWithSampleDataSource(Document domainDoc) {
        boolean sampleExists = false;
        NodeList dataSourceNodeList = domainDoc.getElementsByTagName(CONST_JDBC);
        for (int i = 0; i < dataSourceNodeList.getLength(); ++i) {
            Node dsNode = dataSourceNodeList.item(i);
            NamedNodeMap dsAttrMap = dsNode.getAttributes();
            String jndiName = dsAttrMap.getNamedItem(CONST_JNDINAME).getNodeValue();
            if (!jndiName.equals(SAMPLE_DATASOURCE)) continue;
            sampleExists = true;
        }
        if (!sampleExists) {
            return this.createSampleDatasource(domainDoc);
        }
        return true;
    }

    private boolean createSampleDatasource(Document domainDoc) {
        NodeList resourcesNodeList = domainDoc.getElementsByTagName("resources");
        NodeList serverNodeList = domainDoc.getElementsByTagName("server");
        if (resourcesNodeList == null || resourcesNodeList.getLength() == 0 || serverNodeList == null || serverNodeList.getLength() == 0) {
            return true;
        }
        Node resourcesNode = resourcesNodeList.item(0);
        HashMap<String, Node> cpMap = this.getConnPoolsNodeMap(domainDoc);
        if (!cpMap.containsKey(SAMPLE_CONNPOOL)) {
            if (cpMap.isEmpty()) {
                LOGGER.log(Level.INFO, "Cannot create sample datasource {0}", SAMPLE_DATASOURCE);
                return false;
            }
            Node oldNode = (Node)cpMap.values().iterator().next();
            Node cpNode = oldNode.cloneNode(false);
            NamedNodeMap cpAttrMap = cpNode.getAttributes();
            if (cpAttrMap.getNamedItem(CONST_NAME) != null) {
                cpAttrMap.getNamedItem(CONST_NAME).setNodeValue(SAMPLE_CONNPOOL);
            }
            if (cpAttrMap.getNamedItem(CONST_DS_CLASS) != null) {
                cpAttrMap.getNamedItem(CONST_DS_CLASS).setNodeValue("org.h2.jdbcx.JdbcDataSource");
            }
            if (cpAttrMap.getNamedItem(CONST_RES_TYPE) != null) {
                cpAttrMap.getNamedItem(CONST_RES_TYPE).setNodeValue("javax.sql.DataSource");
            }
            HashMap<String, String> poolProps = new HashMap<String, String>();
            poolProps.put(CONST_URL, "jdbc:h2:${com.sun.aas.instanceRoot}/lib/databases/embedded_default;AUTO_SERVER=TRUE");
            Object[] propNames = poolProps.keySet().toArray();
            for (int i = 0; i < propNames.length; ++i) {
                String keyName = (String)propNames[i];
                Element propElement = domainDoc.createElement(CONST_PROP);
                propElement.setAttribute(CONST_NAME, keyName);
                propElement.setAttribute(CONST_VALUE, (String)poolProps.get(keyName));
                cpNode.appendChild(propElement);
            }
            resourcesNode.appendChild(cpNode);
        }
        Element dsElement = domainDoc.createElement(CONST_JDBC);
        dsElement.setAttribute(CONST_JNDINAME, SAMPLE_DATASOURCE);
        dsElement.setAttribute(CONST_POOLNAME, SAMPLE_CONNPOOL);
        dsElement.setAttribute(CONST_OBJTYPE, "user");
        dsElement.setAttribute(CONST_ENABLED, "true");
        if (resourcesNode.getFirstChild() != null) {
            resourcesNode.insertBefore(dsElement, resourcesNode.getFirstChild());
        } else {
            resourcesNode.appendChild(dsElement);
        }
        Element dsResRefElement = domainDoc.createElement("resource-ref");
        dsResRefElement.setAttribute("ref", SAMPLE_DATASOURCE);
        dsResRefElement.setAttribute(CONST_ENABLED, "true");
        Node serverNode = serverNodeList.item(0);
        if (serverNode.getLastChild() != null) {
            serverNode.insertBefore(dsResRefElement, serverNode.getLastChild());
        } else {
            serverNode.appendChild(dsResRefElement);
        }
        return this.saveDomainScriptFile(domainDoc, this.getDomainLocation());
    }

    private HashMap<String, Node> getConnPoolsNodeMap(Document domainDoc) {
        HashMap<String, Node> connPoolMap = new HashMap<String, Node>();
        NodeList connPoolNodeList = domainDoc.getElementsByTagName(CONST_CP);
        for (int i = 0; i < connPoolNodeList.getLength(); ++i) {
            Node cpNode = connPoolNodeList.item(i);
            NamedNodeMap cpAttrMap = cpNode.getAttributes();
            String cpName = cpAttrMap.getNamedItem(CONST_NAME).getNodeValue();
            connPoolMap.put(cpName, cpNode);
        }
        return connPoolMap;
    }

    public HashMap<String, String> getAdminObjectResourcesFromXml() {
        HashMap<String, String> aoResources = new HashMap<String, String>();
        Document domainDoc = this.getDomainDocument();
        if (domainDoc != null) {
            NodeList adminObjectNodeList = domainDoc.getElementsByTagName(CONST_AO);
            for (int i = 0; i < adminObjectNodeList.getLength(); ++i) {
                Node aoNode = adminObjectNodeList.item(i);
                NamedNodeMap aoAttrMap = aoNode.getAttributes();
                String jndiName = aoAttrMap.getNamedItem(CONST_JNDINAME).getNodeValue();
                Node type = aoAttrMap.getNamedItem(CONST_RES_TYPE);
                if (type == null) continue;
                aoResources.put(jndiName, type.getNodeValue());
            }
        }
        return aoResources;
    }

    static class InnerResolver
    implements EntityResolver {
        private final Charset charset = Charset.defaultCharset();

        InnerResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            String xmlEntity = MessageFormat.format(XML_ENTITY, this.charset.name());
            StringReader reader = new StringReader(xmlEntity);
            InputSource source = new InputSource(reader);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
    }
}

