/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.payara.common.PayaraLogger;
import org.netbeans.modules.payara.common.status.AuthFailureStateListener;
import org.netbeans.modules.payara.common.status.MonitoringInitStateListener;
import org.netbeans.modules.payara.tooling.PayaraStatus;
import org.netbeans.modules.payara.tooling.PayaraStatusListener;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.data.PayaraServerStatus;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;
import org.openide.util.NbBundle;

public class PayaraState {
    private static final Logger LOGGER = PayaraLogger.get(PayaraState.class);
    private static final int INIT_MONITORING_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean monitor(PayaraServer instance) {
        boolean added;
        PayaraServerStatus status = PayaraStatus.get((PayaraServer)instance);
        if (status == null) {
            MonitoringInitStateListener listener = new MonitoringInitStateListener();
            added = PayaraStatus.add((PayaraServer)instance, (PayaraStatusListener)listener, (boolean)false, (PayaraStatus[])new PayaraStatus[]{PayaraStatus.OFFLINE, PayaraStatus.STARTUP, PayaraStatus.ONLINE, PayaraStatus.SHUTDOWN});
            if (added) {
                if (instance.getVersion() != null) {
                    AuthFailureStateListener authListener = new AuthFailureStateListener(instance.getVersion().ordinal() >= PayaraVersion.PF_4_1_144.ordinal());
                    PayaraStatus.addChangeListener((PayaraServer)instance, (PayaraStatusListener)authListener, (PayaraStatus[])new PayaraStatus[]{PayaraStatus.STARTUP});
                    PayaraStatus.addErrorListener((PayaraServer)instance, (PayaraStatusListener)authListener);
                }
                try {
                    long startTime = System.currentTimeMillis();
                    long waitTime = 5000L;
                    MonitoringInitStateListener monitoringInitStateListener = listener;
                    synchronized (monitoringInitStateListener) {
                        while (!listener.isWakeUp() && waitTime > 0L) {
                            listener.wait(waitTime);
                            waitTime = 5000L + startTime - System.currentTimeMillis();
                        }
                    }
                }
                catch (InterruptedException ie) {
                    LOGGER.log(Level.FINE, "Interrupted while waiting on server monitoring");
                }
                finally {
                    PayaraStatus.removeListener((PayaraServer)instance, (PayaraStatusListener)listener);
                }
            }
        } else {
            added = false;
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForKnownState(PayaraServer instance, MonitoringInitStateListener listener, long timeout) {
        try {
            long startTime = System.currentTimeMillis();
            long waitTime = timeout;
            MonitoringInitStateListener monitoringInitStateListener = listener;
            synchronized (monitoringInitStateListener) {
                while (!listener.isWakeUp() && waitTime > 0L) {
                    listener.wait(waitTime);
                    waitTime = timeout + startTime - System.currentTimeMillis();
                }
            }
        }
        catch (InterruptedException ie) {
            LOGGER.log(Level.FINE, "Interrupted while waiting on server monitoring");
        }
        finally {
            PayaraStatus.removeListener((PayaraServer)instance, (PayaraStatusListener)listener);
        }
    }

    public static PayaraServerStatus getStatus(PayaraServer instance, long timeout) {
        MonitoringInitStateListener listener = timeout > 0L ? new MonitoringInitStateListener() : null;
        PayaraServerStatus status = PayaraStatus.get((PayaraServer)instance, (PayaraStatusListener)listener);
        if (status == null) {
            PayaraState.monitor(instance);
            status = PayaraStatus.get((PayaraServer)instance);
            if (status == null) {
                throw new IllegalStateException(NbBundle.getMessage(PayaraState.class, (String)"PayaraState.getStatus.statusNull"));
            }
        } else if (listener != null && listener.isActive()) {
            PayaraState.waitForKnownState(instance, listener, timeout);
        }
        return status;
    }

    public static PayaraServerStatus getStatus(PayaraServer instance) {
        return PayaraState.getStatus(instance, 0L);
    }

    public static boolean isOnline(PayaraServer instance) {
        return PayaraState.getStatus(instance).getStatus() == PayaraStatus.ONLINE;
    }

    public static boolean isOffline(PayaraServer instance) {
        return PayaraState.getStatus(instance).getStatus() == PayaraStatus.OFFLINE;
    }

    public static boolean canStart(PayaraServer instance) {
        PayaraServerStatus status = PayaraState.getStatus(instance);
        switch (status.getStatus()) {
            case UNKNOWN: 
            case ONLINE: 
            case SHUTDOWN: 
            case STARTUP: {
                return false;
            }
        }
        return true;
    }

    public static enum Mode {
        DEFAULT,
        STARTUP,
        REFRESH;


        public String toString() {
            switch (this) {
                case DEFAULT: {
                    return "DEFAULT";
                }
                case STARTUP: {
                    return "STARTUP";
                }
                case REFRESH: {
                    return "REFRESH";
                }
            }
            throw new IllegalStateException("Unknown Mode value");
        }
    }
}

