/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netserver.websocket;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.charset.Charset;
import java.util.logging.Level;
import org.netbeans.modules.netserver.websocket.AbstractWSHandler7;
import org.netbeans.modules.netserver.websocket.WebSocketServerImpl;

class WebSocketHandler7
extends AbstractWSHandler7<WebSocketServerImpl> {
    private SelectionKey myKey;

    public WebSocketHandler7(WebSocketServerImpl webSocketServer, SelectionKey key) {
        super(webSocketServer);
        this.myKey = key;
    }

    @Override
    public void sendHandshake() throws IOException {
        String acceptKey = this.createAcceptKey(this.getKey());
        if (acceptKey == null) {
            this.close();
            return;
        }
        StringBuilder builder = new StringBuilder("HTTP/1.1 101 Web Socket Protocol Handshake");
        builder.append("\r\n");
        builder.append("Upgrade: WebSocket");
        builder.append("\r\n");
        builder.append("Connection: Upgrade");
        builder.append("\r\n");
        builder.append("Sec-WebSocket-Origin: ");
        String origin = ((WebSocketServerImpl)this.getWebSocketPoint()).getContext(this.myKey).getHeaders().get("Sec-WebSocket-Origin");
        if (origin == null) {
            origin = ((WebSocketServerImpl)this.getWebSocketPoint()).getContext(this.myKey).getHeaders().get("Origin");
        }
        if (origin != null) {
            builder.append(origin);
        }
        builder.append("\r\n");
        builder.append("Sec-WebSocket-Accept");
        builder.append(": ");
        builder.append(acceptKey);
        builder.append("\r\n");
        builder.append("\r\n");
        ((WebSocketServerImpl)this.getWebSocketPoint()).send(builder.toString().getBytes(Charset.forName("UTF-8")), this.myKey);
    }

    @Override
    protected boolean isClient() {
        return false;
    }

    @Override
    protected SelectionKey getKey() {
        return this.myKey;
    }

    @Override
    protected void readDelegate(byte[] bytes, int dataType) {
        ((WebSocketServerImpl)this.getWebSocketPoint()).getWebSocketReadHandler().read(this.getKey(), bytes, dataType);
    }

    @Override
    protected boolean verifyMask(boolean hasMask) throws IOException {
        if (!hasMask) {
            WebSocketServerImpl.LOG.log(Level.WARNING, "Unexpected client data. Frame is not masked");
            this.close();
            return false;
        }
        return true;
    }

    private String createAcceptKey(SelectionKey key) {
        String originalKey = ((WebSocketServerImpl)this.getWebSocketPoint()).getContext(key).getHeaders().get("Sec-WebSocket-Key");
        if (originalKey == null) {
            return null;
        }
        return this.generateAcceptKey(originalKey);
    }
}

