/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netserver.api;

public final class ProtocolDraft {
    private final Draft draft;
    private final int version;

    private ProtocolDraft(Draft draft) {
        this.draft = draft;
        this.version = 0;
    }

    private ProtocolDraft(int version) {
        this.draft = null;
        this.version = version;
    }

    private ProtocolDraft() {
        this.draft = null;
        this.version = 0;
    }

    public static ProtocolDraft getProtocol(int number) {
        if (number == 75) {
            return new ProtocolDraft(Draft.Draft75);
        }
        if (number == 76) {
            return new ProtocolDraft(Draft.Draft76);
        }
        if (number >= 7 && number < 13) {
            return new ProtocolDraft(number);
        }
        if (number >= 13 && number <= 17) {
            return new ProtocolDraft();
        }
        throw new IllegalArgumentException();
    }

    public static ProtocolDraft getRFC() {
        return new ProtocolDraft();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProtocolDraft) {
            ProtocolDraft protocol = (ProtocolDraft)obj;
            return this.draft == protocol.draft && this.version == protocol.version;
        }
        return false;
    }

    public int hashCode() {
        if (this.draft == Draft.Draft75) {
            return 75;
        }
        if (this.draft == Draft.Draft76) {
            return 76;
        }
        return this.version;
    }

    public Draft getDraft() {
        return this.draft;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isRFC() {
        return this.draft == null && this.version == 0;
    }

    public static enum Draft {
        Draft75,
        Draft76;

    }
}

