/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.kde;

import org.netbeans.modules.keyring.kde.CommonKWalletProvider;
import org.netbeans.spi.keyring.KeyringProvider;

public class KWalletProvider
implements KeyringProvider {
    private static final String KWALLET_VERSION = "netbeans.keyring.kwallet.version";
    private static final String PATH_VERSION = "netbeans.keyring.kwallet.path.version";
    private KeyringProvider keyringProvider = null;

    public boolean enabled() {
        return this.getKeyringProvider().enabled();
    }

    public char[] read(String key) {
        return this.getKeyringProvider().read(key);
    }

    public void save(String key, char[] password, String description) {
        this.getKeyringProvider().save(key, password, description);
    }

    public void delete(String key) {
        this.getKeyringProvider().delete(key);
    }

    private KeyringProvider getKeyringProvider() {
        if (this.keyringProvider == null) {
            String kwalletVersion = System.getProperty(KWALLET_VERSION);
            if (kwalletVersion == null) {
                kwalletVersion = "5";
            } else if (kwalletVersion.equals("4")) {
                kwalletVersion = "";
            }
            String pathVersion = System.getProperty(PATH_VERSION);
            if (pathVersion == null) {
                pathVersion = kwalletVersion;
            }
            this.keyringProvider = new CommonKWalletProvider(kwalletVersion, pathVersion);
            if (!(kwalletVersion.isEmpty() || pathVersion.isEmpty() || this.keyringProvider.enabled())) {
                this.keyringProvider = new CommonKWalletProvider("", "");
            }
        }
        return this.keyringProvider;
    }
}

