/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.ui.actions;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.openide.filesystems.FileObject;

final class TestClassInfoTask
implements CancellableTask<CompilationController> {
    private FileObject fileObject;
    private final int caretPosition;
    private String className;
    private String methodName;
    private static final String JUNIT4_ANNOTATION = "org.junit.Test";
    private static final String JUNIT5_ANNOTATION = "org.junit.platform.commons.annotation.Testable";
    private static final String TESTCASE = "junit.framework.TestCase";

    TestClassInfoTask(int caretPosition) {
        this.caretPosition = caretPosition;
    }

    public void cancel() {
    }

    public void run(CompilationController controller) throws Exception {
        Element element;
        TreePath tp;
        Elements elements;
        TypeElement testcase;
        controller.toPhase(JavaSource.Phase.RESOLVED);
        this.fileObject = controller.getFileObject();
        TypeElement typeElement2 = null;
        List topLevelElements = controller.getTopLevelElements();
        for (TypeElement typeElement2 : topLevelElements) {
            if (typeElement2.getKind() != ElementKind.CLASS) continue;
            this.className = typeElement2.getSimpleName().toString();
            break;
        }
        boolean junit3 = (testcase = (elements = controller.getElements()).getTypeElement(TESTCASE)) != null && typeElement2 != null ? controller.getTypes().isSubtype(typeElement2.asType(), testcase.asType()) : false;
        for (tp = controller.getTreeUtilities().pathFor(this.caretPosition); tp != null && tp.getLeaf().getKind() != Tree.Kind.METHOD; tp = tp.getParentPath()) {
        }
        if (tp != null && (element = controller.getTrees().getElement(tp)) != null) {
            String mn = element.getSimpleName().toString();
            if (junit3) {
                this.methodName = mn.startsWith("test") ? mn : null;
            } else {
                List<? extends AnnotationMirror> allAnnotationMirrors = elements.getAllAnnotationMirrors(element);
                if (this.isJunit4Test(allAnnotationMirrors) || this.isJunit5Testable(allAnnotationMirrors)) {
                    this.methodName = mn;
                }
            }
        }
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    String getClassName() {
        return this.className;
    }

    String getMethodName() {
        return this.methodName;
    }

    private boolean isJunit4Test(List<? extends AnnotationMirror> allAnnotationMirrors) {
        for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
            TypeElement typeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!typeElement.getQualifiedName().contentEquals(JUNIT4_ANNOTATION)) continue;
            return true;
        }
        return false;
    }

    private boolean isJunit5Testable(List<? extends AnnotationMirror> allAnnotationMirrors) {
        ArrayDeque<? extends AnnotationMirror> pendingMirrorsToCheck = new ArrayDeque<AnnotationMirror>(allAnnotationMirrors);
        HashSet<? extends AnnotationMirror> alreadyAddedMirrorsToCheck = new HashSet<AnnotationMirror>(allAnnotationMirrors);
        while (pendingMirrorsToCheck.peek() != null) {
            AnnotationMirror annotationMirror = (AnnotationMirror)pendingMirrorsToCheck.poll();
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (annotationElement.getQualifiedName().contentEquals(JUNIT5_ANNOTATION)) {
                return true;
            }
            List<? extends AnnotationMirror> parentAnnotationMirrors = annotationElement.getAnnotationMirrors();
            Set newlySeenParentAnnotationMirrors = parentAnnotationMirrors.stream().filter(parentAnnotationMirror -> !alreadyAddedMirrorsToCheck.contains(parentAnnotationMirror)).collect(Collectors.toSet());
            pendingMirrorsToCheck.addAll(newlySeenParentAnnotationMirrors);
            alreadyAddedMirrorsToCheck.addAll(newlySeenParentAnnotationMirrors);
        }
        return false;
    }
}

