/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.knockout.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript2.knockout.index.KnockoutCustomElement;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class KnockoutIndex {
    private static final Map<Project, KnockoutIndex> INDEXES = new WeakHashMap<Project, KnockoutIndex>();
    private final QuerySupport querySupport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KnockoutIndex get(Project project) throws IOException {
        if (project == null) {
            return null;
        }
        Map<Project, KnockoutIndex> map = INDEXES;
        synchronized (map) {
            KnockoutIndex index = INDEXES.get(project);
            if (index == null) {
                Collection sourceRoots = QuerySupport.findRoots((Project)project, null, Collections.emptyList(), Collections.emptyList());
                QuerySupport querrySupport = QuerySupport.forRoots((String)"knockoutjs", (int)1, (FileObject[])sourceRoots.toArray(new FileObject[0]));
                index = new KnockoutIndex(querrySupport);
                if (sourceRoots.size() > 0) {
                    INDEXES.put(project, index);
                }
            }
            return index;
        }
    }

    private KnockoutIndex(QuerySupport querrySupport) throws IOException {
        this.querySupport = querrySupport;
    }

    public Collection<KnockoutCustomElement> getCustomElements(String name, boolean exact) {
        Collection result = null;
        try {
            result = this.querySupport.query("ce", name, QuerySupport.Kind.PREFIX, new String[]{"ce"});
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (result != null && !result.isEmpty()) {
            ArrayList<KnockoutCustomElement> customElements = new ArrayList<KnockoutCustomElement>();
            for (IndexResult indexResult : result) {
                Collection<KnockoutCustomElement> possibleCustomElements = this.createCustomElements(indexResult);
                for (KnockoutCustomElement customElement : possibleCustomElements) {
                    if ((!exact || !customElement.getName().equals(name)) && (exact || !customElement.getName().startsWith(name))) continue;
                    customElements.add(customElement);
                }
            }
            return customElements;
        }
        return Collections.emptyList();
    }

    public Collection<String> getCustomElementParameters(String elementName) {
        Collection result = null;
        try {
            result = this.querySupport.query("ce", elementName, QuerySupport.Kind.PREFIX, new String[]{"ce"});
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (result != null && !result.isEmpty()) {
            ArrayList<String> parameters = new ArrayList<String>();
            block2: for (IndexResult indexResult : result) {
                Collection<KnockoutCustomElement> possibleCustomElements = this.createCustomElements(indexResult);
                for (KnockoutCustomElement customElement : possibleCustomElements) {
                    if (!customElement.getName().equals(elementName)) continue;
                    parameters.addAll(customElement.getParameters());
                    continue block2;
                }
            }
            return Collections.unmodifiableList(parameters);
        }
        return Collections.emptyList();
    }

    private Collection<KnockoutCustomElement> createCustomElements(IndexResult indexResult) {
        String[] values = indexResult.getValues("ce");
        if (indexResult.getFile() == null) {
            return Collections.emptyList();
        }
        ArrayList<KnockoutCustomElement> result = new ArrayList<KnockoutCustomElement>(values.length);
        for (String value : values) {
            String[] params;
            if (value == null || value.isEmpty() || value.indexOf(58) <= 0) continue;
            String[] split = value.split(":");
            int offset = Integer.parseInt(split[2]);
            ArrayList<String> parameters = new ArrayList<String>();
            if (split.length == 4 && (params = split[3].split(";")).length != 0) {
                parameters.addAll(Arrays.asList(params));
            }
            result.add(new KnockoutCustomElement(split[0], split[1], parameters, indexResult.getFile().toURL(), offset));
        }
        return result;
    }
}

