/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.jquery.editor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelFactory;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttribute;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagType;
import org.netbeans.modules.javascript2.editor.spi.CompletionContext;
import org.netbeans.modules.javascript2.editor.spi.CompletionProvider;
import org.netbeans.modules.javascript2.jquery.PropertyNameDataItem;
import org.netbeans.modules.javascript2.jquery.PropertyNameDataLoader;
import org.netbeans.modules.javascript2.jquery.SelectorItem;
import org.netbeans.modules.javascript2.jquery.SelectorsLoader;
import org.netbeans.modules.javascript2.jquery.editor.JQueryCompletionItem;
import org.netbeans.modules.javascript2.jquery.model.JQueryUtils;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class JQueryCodeCompletion
implements CompletionProvider {
    private static final Logger LOGGER = Logger.getLogger(JQueryCodeCompletion.class.getName());
    public static final String HELP_LOCATION = "docs/jquery-api.xml";
    private static File jQueryApiFile;
    private static final String PROPERTY_NAME_FILE_LOCATION = "docs/jquery-propertyNames.xml";
    private static File propertyNameFile;
    private static Collection<HtmlTagAttribute> allAttributes;
    private int lastTsOffset = 0;
    private static HashMap<String, List<SelectorKind>> contextMap;
    private static Collection<SelectorItem> afterColonList;

    public List<CompletionProposal> complete(CodeCompletionContext ccContext, CompletionContext jsCompletionContext, String prefix) {
        long start = System.currentTimeMillis();
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        ParserResult parserResult = ccContext.getParserResult();
        int offset = ccContext.getCaretOffset();
        this.lastTsOffset = ccContext.getParserResult().getSnapshot().getEmbeddedOffset(offset);
        switch (jsCompletionContext) {
            case IN_STRING: {
                TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)parserResult.getSnapshot().getTokenHierarchy(), (int)offset);
                if (ts != null) {
                    ts.move(this.lastTsOffset);
                    if (ts.moveNext()) {
                        if (ts.token().id() == JsTokenId.STRING_END) {
                            ts.movePrevious();
                        }
                        if (ts.token().id() == JsTokenId.STRING) {
                            prefix = ts.token().text().toString().substring(0, this.lastTsOffset - ts.offset());
                        }
                    }
                }
            }
            case GLOBAL: 
            case EXPRESSION: 
            case OBJECT_PROPERTY: {
                if (!JQueryUtils.isInJQuerySelector(parserResult, this.lastTsOffset)) break;
                this.addSelectors(result, parserResult, prefix, this.lastTsOffset, ccContext);
                break;
            }
            case OBJECT_PROPERTY_NAME: {
                this.completeObjectPropertyName(ccContext, result, prefix);
                break;
            }
        }
        long end = System.currentTimeMillis();
        LOGGER.log(Level.FINE, "Counting jQuery CC took {0}ms ", end - start);
        return result;
    }

    private int findParamIndex(ParserResult parserResult, int offset) {
        TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)parserResult.getSnapshot().getTokenHierarchy(), (int)offset);
        if (ts == null) {
            return -1;
        }
        ts.move(offset);
        if (!ts.moveNext() || !ts.movePrevious()) {
            return -1;
        }
        Token token = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE));
        int paramIndex = 0;
        while (token.id() != JsTokenId.EOL && token.id() != JsTokenId.BRACKET_LEFT_PAREN) {
            if (token.id() == JsTokenId.OPERATOR_COMMA) {
                ++paramIndex;
            } else if (token.id() == JsTokenId.OPERATOR_DOT) {
                return -1;
            }
            token = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE));
        }
        if (token.id() == JsTokenId.BRACKET_LEFT_PAREN) {
            return paramIndex;
        }
        return -1;
    }

    private String findFunctionName(ParserResult parserResult, int offset) {
        TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)parserResult.getSnapshot().getTokenHierarchy(), (int)offset);
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (!ts.moveNext() || !ts.movePrevious()) {
            return null;
        }
        Token token = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE));
        while (token.id() != JsTokenId.EOL && token.id() != JsTokenId.BRACKET_LEFT_PAREN) {
            if (token.id() == JsTokenId.OPERATOR_DOT) {
                return null;
            }
            token = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE));
        }
        if (token.id() == JsTokenId.BRACKET_LEFT_PAREN && ts.movePrevious() && (token = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE))).id() == JsTokenId.IDENTIFIER) {
            return token.text().toString();
        }
        return null;
    }

    public String getHelpDocumentation(ParserResult info, ElementHandle element) {
        if (element != null && element instanceof JQueryCompletionItem.DocSimpleElement) {
            return ((JQueryCompletionItem.DocSimpleElement)element).getDocumentation();
        }
        if (element != null && element.getKind() == ElementKind.CALL) {
            String name = element.getName();
            int index = (name = name.substring(1)).indexOf(40);
            if (index > -1) {
                name = name.substring(0, index);
            }
            return SelectorsLoader.getDocumentation(this.getJQueryAPIFile(), name);
        }
        if (element != null && element.getKind() == ElementKind.METHOD && JQueryUtils.isJQuery(info, this.lastTsOffset)) {
            return SelectorsLoader.getMethodDocumentation(this.getJQueryAPIFile(), element.getName());
        }
        return null;
    }

    private void completeObjectPropertyName(CodeCompletionContext ccContext, List<CompletionProposal> result, String prefix) {
        JsTokenId tokenId;
        TokenHierarchy th = ccContext.getParserResult().getSnapshot().getTokenHierarchy();
        if (th == null) {
            return;
        }
        int carretOffset = ccContext.getCaretOffset();
        int eOffset = ccContext.getParserResult().getSnapshot().getEmbeddedOffset(carretOffset);
        TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)th, (int)eOffset);
        if (ts == null) {
            return;
        }
        ts.move(eOffset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return;
        }
        Token token = null;
        int balance = 1;
        while (ts.movePrevious() && balance > 0) {
            token = ts.token();
            tokenId = (JsTokenId)token.id();
            if (tokenId == JsTokenId.BRACKET_RIGHT_CURLY) {
                ++balance;
                continue;
            }
            if (tokenId != JsTokenId.BRACKET_LEFT_CURLY) continue;
            --balance;
        }
        if (token == null || balance != 0) {
            return;
        }
        token = LexUtilities.findPreviousToken((TokenSequence)ts, Arrays.asList(JsTokenId.IDENTIFIER));
        tokenId = (JsTokenId)token.id();
        StringBuilder sb = new StringBuilder(token.text());
        while ((tokenId == JsTokenId.IDENTIFIER || tokenId == JsTokenId.OPERATOR_DOT) && ts.movePrevious()) {
            token = ts.token();
            tokenId = (JsTokenId)token.id();
            if (tokenId == JsTokenId.OPERATOR_DOT) {
                sb.insert(0, '.');
                continue;
            }
            if (tokenId != JsTokenId.IDENTIFIER) continue;
            sb.insert(0, token.text());
        }
        String fqn = sb.toString();
        Map<String, Collection<PropertyNameDataItem>> data = JQueryCodeCompletion.getPropertyNameData();
        if (fqn.startsWith("$")) {
            fqn = fqn.replace("$", "jQuery");
        }
        Collection<PropertyNameDataItem> items = data.get(fqn);
        int anchorOffset = ccContext.getParserResult().getSnapshot().getOriginalOffset(eOffset) - ccContext.getPrefix().length();
        if (items != null) {
            boolean addComma = this.addComma((TokenSequence<? extends JsTokenId>)ts, eOffset);
            for (PropertyNameDataItem item : items) {
                if (!item.getName().startsWith(prefix)) continue;
                result.add(JQueryCompletionItem.createPropertyNameItem(item, anchorOffset, addComma));
            }
        }
    }

    private static synchronized Map<String, Collection<PropertyNameDataItem>> getPropertyNameData() {
        return PropertyNameDataLoader.getData(JQueryCodeCompletion.getPropertyNameDataFile());
    }

    private static synchronized File getPropertyNameDataFile() {
        if (propertyNameFile == null) {
            propertyNameFile = InstalledFileLocator.getDefault().locate(PROPERTY_NAME_FILE_LOCATION, "org.netbeans.modules.javascript2.jquery", false);
        }
        return propertyNameFile;
    }

    private boolean addComma(TokenSequence<? extends JsTokenId> ts, int eOffset) {
        Token token;
        ts.move(eOffset);
        return ts.moveNext() && ((token = LexUtilities.findNext(ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT))).id() == JsTokenId.IDENTIFIER || token.id() == JsTokenId.STRING_BEGIN);
    }

    private void fillContextMap() {
        contextMap.put(" (", Arrays.asList(SelectorKind.TAG, SelectorKind.ID, SelectorKind.CLASS, SelectorKind.AFTER_COLON));
        contextMap.put("#", Arrays.asList(SelectorKind.ID));
        contextMap.put(".", Arrays.asList(SelectorKind.CLASS));
        contextMap.put("[", Arrays.asList(SelectorKind.TAG_ATTRIBUTE));
        contextMap.put(":", Arrays.asList(SelectorKind.AFTER_COLON));
    }

    private void fillAfterColonList() {
        if (this.getJQueryAPIFile() != null) {
            afterColonList = SelectorsLoader.getSelectors(this.getJQueryAPIFile());
        }
    }

    private synchronized File getJQueryAPIFile() {
        if (jQueryApiFile == null) {
            jQueryApiFile = InstalledFileLocator.getDefault().locate(HELP_LOCATION, "org.netbeans.modules.javascript2.jquery", false);
        }
        return jQueryApiFile;
    }

    private SelectorContext findSelectorContext(String text) {
        int index;
        StringBuilder prefix = new StringBuilder();
        for (index = text.length() - 1; index > -1; --index) {
            char c = text.charAt(index);
            switch (c) {
                case ' ': 
                case '(': 
                case ',': {
                    return new SelectorContext(prefix.toString(), index, Arrays.asList(SelectorKind.TAG, SelectorKind.ID, SelectorKind.CLASS));
                }
                case '#': {
                    return new SelectorContext(prefix.toString(), index, Arrays.asList(SelectorKind.ID));
                }
                case '.': {
                    return new SelectorContext(prefix.toString(), index, Arrays.asList(SelectorKind.CLASS));
                }
                case '[': {
                    return new SelectorContext(prefix.toString(), index, Arrays.asList(SelectorKind.TAG_ATTRIBUTE));
                }
                case ':': {
                    return new SelectorContext(prefix.toString(), index, Arrays.asList(SelectorKind.AFTER_COLON));
                }
            }
            prefix.insert(0, c);
        }
        if (index < 0) {
            return new SelectorContext(prefix.toString(), 0, Arrays.asList(SelectorKind.TAG, SelectorKind.ID, SelectorKind.CLASS, SelectorKind.AFTER_COLON));
        }
        return null;
    }

    private void addSelectors(List<CompletionProposal> result, ParserResult parserResult, String prefix, int offset, CodeCompletionContext ccContex) {
        SelectorContext context;
        char ch;
        TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)parserResult.getSnapshot().getTokenHierarchy(), (int)offset);
        if (ts == null) {
            return;
        }
        ts.move(offset);
        if (!ts.moveNext() || !ts.movePrevious()) {
            return;
        }
        String wrapup = "";
        String prefixText = prefix;
        int anchorOffsetDelta = prefix.length() - ccContex.getPrefix().length();
        if (!(prefixText.isEmpty() || anchorOffsetDelta <= 0 || (ch = prefixText.charAt(anchorOffsetDelta - 1)) != '#' && ch != '.' && ch != ':')) {
            --anchorOffsetDelta;
        }
        if (contextMap.isEmpty()) {
            this.fillContextMap();
        }
        if ((context = this.findSelectorContext(prefixText)) != null) {
            int docOffset = parserResult.getSnapshot().getOriginalOffset(offset) - prefixText.length();
            int anchorOffset = docOffset + anchorOffsetDelta;
            block7: for (SelectorKind selectorKind : context.kinds) {
                switch (selectorKind) {
                    case TAG: {
                        Collection<HtmlTag> tags = this.getHtmlTags(context.prefix);
                        for (HtmlTag htmlTag : tags) {
                            result.add(JQueryCompletionItem.create(htmlTag, anchorOffset, wrapup));
                        }
                        continue block7;
                    }
                    case TAG_ATTRIBUTE: {
                        int index = prefix.lastIndexOf(91);
                        String tagName = "";
                        if (index > 0) {
                            tagName = prefix.substring(0, index);
                        }
                        if (!tagName.isEmpty()) {
                            index = tagName.lastIndexOf(32);
                            if (index > -1) {
                                tagName = tagName.substring(index + 1);
                            }
                            if ((index = tagName.indexOf(46)) > -1) {
                                tagName = tagName.substring(0, index);
                            }
                            if ((index = tagName.indexOf(35)) > -1) {
                                tagName = tagName.substring(0, index);
                            }
                            if ((index = tagName.lastIndexOf(40)) > -1) {
                                tagName = tagName.substring(index + 1);
                            }
                        }
                        if (!(tagName.isEmpty() || tagName.charAt(0) != '.' && tagName.charAt(0) != '#' && tagName.charAt(0) != '(')) {
                            if (ts.token().id() == JsTokenId.STRING_BEGIN) {
                                ts.moveNext();
                            }
                            if (ts.token().id() == JsTokenId.STRING) {
                                String value = ts.token().text().toString();
                                index = value.indexOf(prefix);
                                if (index > -1) {
                                    char ch2;
                                    tagName = value.substring(0, index);
                                    --index;
                                    while (index > -1 && (ch2 = tagName.charAt(index)) != '.' && ch2 != '#' && ch2 != ',' && ch2 != '=' && ch2 != '\"' && ch2 != '\'' && ch2 != '[' && ch2 != ']' && ch2 != '(' && ch2 != ')' && ch2 != ':') {
                                        --index;
                                    }
                                    if (index > -1) {
                                        tagName = tagName.substring(index + 1);
                                    }
                                } else {
                                    tagName = "";
                                }
                            } else {
                                tagName = "";
                            }
                        }
                        String attributePrefix = prefix.substring(context.prefixIndex + 1);
                        anchorOffset = docOffset + prefix.length() - context.prefix.length();
                        Collection<HtmlTagAttribute> attributes = this.getHtmlAttributes(tagName, attributePrefix);
                        for (HtmlTagAttribute htmlTagAttribute : attributes) {
                            result.add(JQueryCompletionItem.create(htmlTagAttribute, anchorOffset, ""));
                        }
                        continue block7;
                    }
                    case ID: {
                        HtmlTagAttribute htmlTagAttribute;
                        Collection<String> tagIds = this.getTagIds(context.prefix, parserResult);
                        htmlTagAttribute = tagIds.iterator();
                        while (htmlTagAttribute.hasNext()) {
                            String tagId = htmlTagAttribute.next();
                            result.add(JQueryCompletionItem.createCSSItem("#" + tagId, anchorOffset, wrapup));
                        }
                        continue block7;
                    }
                    case CLASS: {
                        Collection<String> classes = this.getCSSClasses(context.prefix, parserResult);
                        for (String cl : classes) {
                            result.add(JQueryCompletionItem.createCSSItem("." + cl, anchorOffset, wrapup));
                        }
                        continue block7;
                    }
                    case AFTER_COLON: {
                        if (afterColonList.isEmpty()) {
                            this.fillAfterColonList();
                        }
                        for (SelectorItem selector : afterColonList) {
                            if (!selector.getDisplayText().startsWith(context.prefix)) continue;
                            result.add(JQueryCompletionItem.createJQueryItem(":" + selector.getDisplayText(), anchorOffset, wrapup, selector.getInsertTemplate()));
                        }
                        break;
                    }
                }
            }
        }
    }

    private Collection<String> getTagIds(String tagIdPrefix, ParserResult parserResult) {
        FileObject fo = parserResult.getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return Collections.emptyList();
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        HashSet<String> unique = new HashSet<String>();
        try {
            CssIndex cssIndex = CssIndex.create((Project)project);
            Map findIdsByPrefix = cssIndex.findIdsByPrefix(tagIdPrefix);
            for (Collection ids : findIdsByPrefix.values()) {
                for (String id : ids) {
                    unique.add(id);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return unique;
    }

    private Collection<String> getCSSClasses(String classPrefix, ParserResult parserResult) {
        FileObject fo = parserResult.getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return Collections.emptyList();
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        HashSet<String> unique = new HashSet<String>();
        try {
            CssIndex cssIndex = CssIndex.create((Project)project);
            Map findIdsByPrefix = cssIndex.findClassesByPrefix(classPrefix);
            for (Collection ids : findIdsByPrefix.values()) {
                for (String id : ids) {
                    unique.add(id);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return unique;
    }

    private Collection<HtmlTagAttribute> getHtmlAttributes(String tagName, String prefix) {
        Collection<Object> result = Collections.emptyList();
        HtmlModel htmlModel = HtmlModelFactory.getModel((HtmlVersion)HtmlVersion.HTML5);
        HtmlTag htmlTag = htmlModel.getTag(tagName);
        if (htmlTag != null) {
            if (prefix.isEmpty()) {
                result = tagName.isEmpty() ? this.getAllAttributes(htmlModel) : htmlTag.getAttributes();
            } else {
                Collection<HtmlTagAttribute> attributes = htmlTag.getAttributes();
                if (tagName.isEmpty() || htmlTag.getTagClass() == HtmlTagType.UNKNOWN) {
                    attributes = this.getAllAttributes(htmlModel);
                }
                result = new ArrayList<HtmlTagAttribute>();
                for (HtmlTagAttribute htmlTagAttribute : attributes) {
                    if (!htmlTagAttribute.getName().startsWith(prefix)) continue;
                    result.add(htmlTagAttribute);
                }
            }
        }
        return result;
    }

    private Collection<HtmlTag> getHtmlTags(String prefix) {
        List<HtmlTag> result = Collections.emptyList();
        HtmlModel htmlModel = HtmlModelFactory.getModel((HtmlVersion)HtmlVersion.HTML5);
        Collection allTags = htmlModel.getAllTags();
        if (prefix.isEmpty()) {
            result = allTags;
        } else {
            result = new ArrayList();
            for (HtmlTag htmlTag : allTags) {
                if (!htmlTag.getName().startsWith(prefix)) continue;
                result.add(htmlTag);
            }
        }
        return result;
    }

    private synchronized Collection<HtmlTagAttribute> getAllAttributes(HtmlModel htmlModel) {
        if (allAttributes == null) {
            this.initAllAttributes(htmlModel);
        }
        return allAttributes;
    }

    private synchronized void initAllAttributes(HtmlModel htmlModel) {
        assert (allAttributes == null);
        HashMap<String, HtmlTagAttribute> result = new HashMap<String, HtmlTagAttribute>();
        for (HtmlTag htmlTag : htmlModel.getAllTags()) {
            for (HtmlTagAttribute htmlTagAttribute : htmlTag.getAttributes()) {
                if (result.containsKey(htmlTagAttribute.getName())) continue;
                result.put(htmlTagAttribute.getName(), htmlTagAttribute);
            }
        }
        allAttributes = result.values();
    }

    static {
        contextMap = new HashMap();
        afterColonList = Collections.emptyList();
    }

    private static class SelectorContext {
        String prefix;
        Collection<SelectorKind> kinds;
        int prefixIndex;

        public SelectorContext(String prefix, int prefixIndex, Collection<SelectorKind> kinds) {
            this.prefix = prefix;
            this.kinds = kinds;
            this.prefixIndex = prefixIndex;
        }
    }

    private static enum SelectorKind {
        TAG,
        TAG_ATTRIBUTE,
        CLASS,
        ID,
        TAG_ATTRIBUTE_COMPARATION,
        AFTER_COLON;

    }
}

