/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.sources;

import java.net.URL;
import java.util.Objects;
import org.netbeans.modules.javascript2.debug.sources.SourceContent;
import org.netbeans.modules.javascript2.debug.sources.SourceFS;
import org.openide.filesystems.FileObject;

public final class SourceFilesCache {
    public static final String URL_PROTOCOL = "js-scripts";
    private static final SourceFilesCache DEFAULT = new SourceFilesCache();
    private final SourceFS fs = new SourceFS();

    private SourceFilesCache() {
    }

    public static SourceFilesCache getDefault() {
        return DEFAULT;
    }

    public URL getSourceFile(String name, int hash, String content) {
        return this.getSourceFile(name, hash, (SourceContent)new StringContent(content));
    }

    public URL getSourceFile(String name, int hash, SourceContent content) {
        return this.getSourceFile(name, Integer.toHexString(hash), content);
    }

    public URL getSourceFile(String name, String hash, SourceContent content) {
        Objects.requireNonNull(hash, "hash was null");
        String path = hash + '/' + name;
        FileObject fo = this.fs.findResource(path);
        if (fo == null) {
            fo = this.fs.createFile(path, content);
        }
        return fo.toURL();
    }

    static final class StringContent
    implements SourceContent {
        private final String content;

        public StringContent(String content) {
            this.content = content;
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public long getLength() {
            return this.content.length();
        }
    }
}

