/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.gulp;

import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.gulp.Bundle;
import org.netbeans.modules.javascript.gulp.exec.GulpExecutable;
import org.netbeans.modules.javascript.gulp.file.GulpTasks;
import org.netbeans.modules.javascript.gulp.file.Gulpfile;
import org.netbeans.modules.javascript.gulp.preferences.GulpPreferences;
import org.netbeans.modules.javascript.gulp.util.GulpUtils;
import org.netbeans.modules.web.clientproject.spi.build.BuildToolImplementation;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakListeners;

public final class GulpBuildTool
implements BuildToolImplementation {
    private static final Logger LOGGER = Logger.getLogger(GulpBuildTool.class.getName());
    public static final String IDENTIFIER = "Gulp";
    private final Project project;
    private final Gulpfile projectGulpfile;
    private final GulpTasks projectGulpTasks;
    private final GulpPreferences gulpPreferences;
    final ConcurrentMap<FileObject, GulpTasks> gulpTasks = new ConcurrentHashMap<FileObject, GulpTasks>();
    private final ChangeListener cleanupListener = new CleanupListener();

    public GulpBuildTool(Project project) {
        assert (project != null);
        this.project = project;
        this.projectGulpfile = Gulpfile.create(project.getProjectDirectory());
        this.projectGulpTasks = GulpTasks.create(project, this.projectGulpfile);
        this.gulpPreferences = new GulpPreferences(project);
    }

    @NonNull
    public static GulpBuildTool forProject(Project project) {
        GulpBuildTool buildTool = GulpBuildTool.inProject(project);
        assert (buildTool != null) : "GulpBuildTool should be found in project " + project.getClass().getName() + " (lookup: " + project.getLookup() + ")";
        return buildTool;
    }

    @CheckForNull
    public static GulpBuildTool inProject(Project project) {
        assert (project != null);
        return (GulpBuildTool)project.getLookup().lookup(GulpBuildTool.class);
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getDisplayName() {
        return Bundle.GulpBuildTool_name();
    }

    public Gulpfile getProjectGulpfile() {
        return this.projectGulpfile;
    }

    public GulpTasks getProjectGulpTasks() {
        return this.projectGulpTasks;
    }

    public GulpTasks getGulpTasks(@NullAllowed FileObject gulpfile) {
        if (gulpfile == null || gulpfile.getParent().equals(this.project.getProjectDirectory())) {
            return this.getProjectGulpTasks();
        }
        GulpTasks tasks = (GulpTasks)this.gulpTasks.get(gulpfile);
        if (tasks != null) {
            return tasks;
        }
        Gulpfile file = Gulpfile.create(gulpfile.getParent());
        tasks = GulpTasks.create(this.project, file);
        GulpTasks currentTasks = this.gulpTasks.putIfAbsent(gulpfile, tasks);
        if (currentTasks != null) {
            return currentTasks;
        }
        file.addChangeListener(WeakListeners.change((ChangeListener)this.cleanupListener, (Object)file));
        return tasks;
    }

    public GulpPreferences getGulpPreferences() {
        return this.gulpPreferences;
    }

    public boolean isEnabled() {
        return this.projectGulpfile.exists();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean run(String commandId, boolean waitFinished, boolean warnUser) {
        assert (this.isEnabled()) : this.project.getProjectDirectory().getNameExt();
        assert (this.projectGulpfile.exists()) : this.project.getProjectDirectory().getNameExt();
        String gulpBuild = this.gulpPreferences.getTask(commandId);
        if (gulpBuild != null) {
            GulpExecutable gulp = GulpExecutable.getDefault(this.project, warnUser);
            if (gulp == null) return true;
            GulpUtils.logUsageGulpBuild();
            Future<Integer> result = gulp.run(gulpBuild.split(" "));
            if (!waitFinished) return true;
            try {
                result.get();
                return true;
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.INFO, null, ex);
                return true;
            }
            catch (CancellationException ex) {
                LOGGER.log(Level.FINE, null, ex);
                return true;
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.INFO, null, ex);
                if (!warnUser) return true;
            }
            return true;
        } else {
            Object option;
            if (!warnUser || (option = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.GulpBuildTool_configure(), 0))) != NotifyDescriptor.YES_OPTION) return true;
            ((CustomizerProvider2)this.project.getLookup().lookup(CustomizerProvider2.class)).showCustomizer(IDENTIFIER, null);
        }
        return true;
    }

    private final class CleanupListener
    implements ChangeListener {
        private CleanupListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Iterator iterator = GulpBuildTool.this.gulpTasks.keySet().iterator();
            while (iterator.hasNext()) {
                FileObject gulpfile = (FileObject)iterator.next();
                if (gulpfile.isValid()) continue;
                LOGGER.log(Level.FINE, "Removing invalid gulp file {0}", gulpfile);
                iterator.remove();
            }
        }
    }
}

