/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly;

import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.javaee.wildfly.WildflyClassLoader;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.openide.util.NbBundle;

public class WildflyDeploymentFactory
implements DeploymentFactory {
    public static final String URI_PREFIX = "wildfly-deployer:";
    private static final String DISCONNECTED_URI = "wildfly-deployer:http://localhost:8080&";
    private static final Logger LOGGER = Logger.getLogger(WildflyDeploymentFactory.class.getName());
    private final Map<InstanceProperties, DeploymentFactory> factoryCache = new WeakHashMap<InstanceProperties, DeploymentFactory>();
    private final Map<InstanceProperties, WildflyDeploymentManager> managerCache = new WeakHashMap<InstanceProperties, WildflyDeploymentManager>();
    private final Map<InstanceProperties, WildflyClassLoader> classLoaderCache = new WeakHashMap<InstanceProperties, WildflyClassLoader>();
    private static WildflyDeploymentFactory instance;

    private WildflyDeploymentFactory() {
    }

    public static synchronized WildflyDeploymentFactory getInstance() {
        if (instance == null) {
            instance = new WildflyDeploymentFactory();
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance);
        }
        return instance;
    }

    public synchronized WildflyClassLoader getWildFlyClassLoader(InstanceProperties ip) {
        WildflyClassLoader cl = this.classLoaderCache.get(ip);
        if (cl == null) {
            DeploymentFactory factory = this.factoryCache.get(ip);
            if (factory != null && factory.getClass().getClassLoader() instanceof WildflyClassLoader) {
                cl = (WildflyClassLoader)factory.getClass().getClassLoader();
            }
            if (cl == null) {
                cl = WildflyClassLoader.createWildFlyClassLoader(ip.getProperty("root-dir"));
            }
            this.classLoaderCache.put(ip, cl);
        }
        return cl;
    }

    public boolean handlesURI(String uri) {
        return uri != null && uri.startsWith(URI_PREFIX);
    }

    public DeploymentManager getDeploymentManager(String uri, String uname, String passwd) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException(NbBundle.getMessage(WildflyDeploymentFactory.class, (String)"MSG_INVALID_URI", (Object)uri));
        }
        Class<WildflyDeploymentFactory> clazz = WildflyDeploymentFactory.class;
        synchronized (WildflyDeploymentFactory.class) {
            WildflyDeploymentManager dm;
            InstanceProperties ip = InstanceProperties.getInstanceProperties((String)uri);
            if (ip != null && (dm = this.managerCache.get(ip)) != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return dm;
            }
            try {
                DeploymentFactory df = this.getFactory(uri);
                if (df == null) {
                    throw new DeploymentManagerCreationException(NbBundle.getMessage(WildflyDeploymentFactory.class, (String)"MSG_ERROR_CREATING_DM", (Object)uri));
                }
                String jbURI = uri;
                try {
                    int index1 = uri.indexOf(35);
                    int index2 = uri.indexOf(38);
                    int index = Math.min(index1, index2);
                    jbURI = uri.substring(0, index);
                }
                catch (Exception e) {
                    LOGGER.log(Level.INFO, null, e);
                }
                if (jbURI.endsWith("as7")) {
                    jbURI = jbURI + "&serverHost=" + (ip != null ? ip.getProperty("host") : "localhost");
                }
                WildflyDeploymentManager dm2 = new WildflyDeploymentManager(df, uri, jbURI, uname, passwd);
                if (ip != null) {
                    this.managerCache.put(ip, dm2);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return dm2;
            }
            catch (NoClassDefFoundError e) {
                DeploymentManagerCreationException dmce = new DeploymentManagerCreationException("Classpath is incomplete");
                dmce.initCause((Throwable)e);
                throw dmce;
            }
        }
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException(NbBundle.getMessage(WildflyDeploymentFactory.class, (String)"MSG_INVALID_URI", (Object)uri));
        }
        try {
            InstanceProperties ip = InstanceProperties.getInstanceProperties((String)uri);
            if (ip == null && !DISCONNECTED_URI.equals(uri)) {
                throw new DeploymentManagerCreationException("JBoss instance " + uri + " is not registered in the IDE.");
            }
            if (ip != null) {
                String root = ip.getProperty("root-dir");
                if (root == null || !new File(root).isDirectory()) {
                    throw new DeploymentManagerCreationException("Non existent server root " + root);
                }
                String server = ip.getProperty("server-dir");
                if (server == null || !new File(server).isDirectory()) {
                    throw new DeploymentManagerCreationException("Non existent domain root " + server);
                }
            }
            return new WildflyDeploymentManager(null, uri, null, null, null);
        }
        catch (NoClassDefFoundError e) {
            DeploymentManagerCreationException dmce = new DeploymentManagerCreationException("Classpath is incomplete");
            dmce.initCause((Throwable)e);
            throw dmce;
        }
    }

    public String getProductVersion() {
        return NbBundle.getMessage(WildflyDeploymentFactory.class, (String)"LBL_JBossFactoryVersion");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(WildflyDeploymentFactory.class, (String)"WILDFLY_SERVER_NAME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentFactory getFactory(String instanceURL) {
        WildflyDeploymentFactory jbossFactory = null;
        try {
            InstanceProperties ip = InstanceProperties.getInstanceProperties((String)instanceURL);
            Class<WildflyDeploymentFactory> clazz = WildflyDeploymentFactory.class;
            synchronized (WildflyDeploymentFactory.class) {
                if (ip != null) {
                    jbossFactory = this.factoryCache.get(ip);
                }
                if (jbossFactory == null) {
                    jbossFactory = this;
                    if (ip != null) {
                        this.factoryCache.put(ip, jbossFactory);
                    }
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, null, e);
        }
        {
            return jbossFactory;
        }
    }
}

