/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.mx.project;

import java.awt.Toolkit;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.base.ProcessBuilder;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.modules.java.mx.project.Bundle;
import org.netbeans.modules.java.mx.project.SuiteProject;
import org.netbeans.modules.java.mx.project.SuiteSources;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.LifecycleManager;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

final class SuiteActionProvider
implements ActionProvider {
    private static final String TEST_MX_PATH = System.getProperty("org.netbeans.modules.java.mx.project.test.mxpath");
    private static final RequestProcessor ASYNC = new RequestProcessor("Mx Async", 10);
    private static final List<String> SUPPORTED_ACTIONS = Arrays.asList("clean", "build", "compile.single", "rebuild", "test.single", "run.single", "debug.test.single", "debug.single", "debug.single.method", "run.single.method");
    private final SuiteProject prj;

    SuiteActionProvider(SuiteProject prj) {
        this.prj = prj;
    }

    public String[] getSupportedActions() {
        return SUPPORTED_ACTIONS.toArray(new String[0]);
    }

    public void invokeAction(String action, Lookup context) throws IllegalArgumentException {
        CompletionStage<Integer> running;
        FileObject fo = (FileObject)context.lookup(FileObject.class);
        String testSuffix = "";
        switch (action) {
            case "clean": {
                running = this.runMx(Bundle.MSG_Clean(this.prj.getName()), "clean");
                break;
            }
            case "build": {
                running = this.ensureBuilt(null);
                break;
            }
            case "rebuild": {
                running = this.ensureBuilt(null);
                break;
            }
            case "compile.single": {
                running = this.ensureBuilt(fo);
                break;
            }
            case "run.single.method": {
                SingleMethod m = (SingleMethod)context.lookup(SingleMethod.class);
                if (m != null) {
                    if (fo == null) {
                        fo = m.getFile();
                    }
                    testSuffix = "#" + m.getMethodName();
                }
            }
            case "test.single": 
            case "run.single": {
                if (fo == null) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                running = this.runBuildAndMx(null, Bundle.MSG_Unittest(fo.getName()), "unittest", fo.getName() + testSuffix);
                break;
            }
            case "debug.single.method": {
                SingleMethod m = (SingleMethod)context.lookup(SingleMethod.class);
                if (m != null) {
                    if (fo == null) {
                        fo = m.getFile();
                    }
                    testSuffix = "#" + m.getMethodName();
                }
            }
            case "debug.test.single": 
            case "debug.single": {
                if (fo == null) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                ListeningDICookie ldic = ListeningDICookie.create((int)-1);
                DebuggerInfo di = DebuggerInfo.create((String)"netbeans-jpda-ListeningDICookie", (Object[])new Object[]{ldic});
                ASYNC.post(() -> DebuggerManager.getDebuggerManager().startDebugging(di));
                int port = ldic.getPortNumber();
                running = this.runBuildAndMx(null, Bundle.MSG_Unittest(fo.getName()), "--attach", "" + port, "unittest", fo.getName() + testSuffix);
                break;
            }
            default: {
                throw new UnsupportedOperationException(action);
            }
        }
        if (running != null) {
            ActionProgress progress = ActionProgress.start((Lookup)context);
            running.handle((exitCode, error) -> {
                progress.finished(error == null && exitCode != null && exitCode == 0);
                return null;
            });
        }
    }

    private CompletionStage<Integer> ensureBuilt(FileObject fo) {
        SuiteSources.Group grp;
        if (fo != null && (grp = this.prj.getSources().findGroup(fo)) != null) {
            String name = grp.getDisplayName();
            return this.runMx(Bundle.MSG_BuildOnly(this.prj.getName(), name), "build", "--only", name);
        }
        return this.runMx(Bundle.MSG_Rebuild(this.prj.getName()), "build");
    }

    private CompletionStage<Integer> runBuildAndMx(FileObject fo, String taskName, String ... args) {
        return this.ensureBuilt(fo).thenCompose(exitCode -> this.runMx(taskName, args));
    }

    private CompletableFuture<Integer> runMx(String taskName, String ... args) {
        File suiteDir = FileUtil.toFile((FileObject)this.prj.getProjectDirectory());
        if (!suiteDir.isDirectory()) {
            Toolkit.getDefaultToolkit().beep();
            return CompletableFuture.completedFuture(-1);
        }
        CompletableFuture<Future> taskResult = new CompletableFuture<Future>();
        CompletableFuture<Integer> cf = new CompletableFuture<Integer>();
        LifecycleManager.getDefault().saveAll();
        ExecutionDescriptor descriptor = new ExecutionDescriptor().frontWindow(true).controllable(true).errConvertorFactory(() -> line -> {
            File src;
            String[] segments = line.split(":");
            if (segments.length > 2 && (src = new File(segments[0])).exists()) {
                final int lineNumber = this.parseLineNumber(segments) - 1;
                return Collections.singletonList(ConvertedLine.forText((String)line, (OutputListener)new OutputListener(){

                    public void outputLineSelected(OutputEvent ev) {
                        this.openLine(Line.ShowOpenType.NONE, Line.ShowVisibilityType.FRONT);
                    }

                    public void outputLineAction(OutputEvent ev) {
                        this.openLine(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                    }

                    private boolean openLine(Line.ShowOpenType openType, Line.ShowVisibilityType visibilityType) throws IndexOutOfBoundsException {
                        FileObject fo = FileUtil.toFileObject((File)src);
                        if (fo != null) {
                            Openable open;
                            Lookup lkp = fo.getLookup();
                            LineCookie lines = (LineCookie)lkp.lookup(LineCookie.class);
                            if (lines != null && (open = lines.getLineSet().getOriginal(lineNumber)) != null) {
                                open.show(openType, visibilityType);
                                return true;
                            }
                            open = (Openable)lkp.lookup(Openable.class);
                            if (open != null) {
                                open.open();
                            } else {
                                Toolkit.getDefaultToolkit().beep();
                            }
                        }
                        return false;
                    }

                    public void outputLineCleared(OutputEvent ev) {
                    }
                }));
            }
            return null;
        }).postExecution(exitCode -> cf.complete((Integer)exitCode));
        ProcessBuilder processBuilder = ProcessBuilder.getLocal();
        processBuilder.setWorkingDirectory(suiteDir.getPath());
        String executable = TEST_MX_PATH != null ? TEST_MX_PATH : "mx";
        processBuilder.setExecutable(executable);
        processBuilder.setArguments(Arrays.asList(args));
        ExecutionService service = ExecutionService.newService((Callable)processBuilder, (ExecutionDescriptor)descriptor, (String)taskName);
        Future task = service.run();
        taskResult.complete(task);
        this.prj.registerTask(task);
        return cf;
    }

    private int parseLineNumber(String[] segments) {
        int lineNumber;
        try {
            lineNumber = Integer.parseInt(segments[1]);
        }
        catch (NumberFormatException ex) {
            lineNumber = 1;
        }
        return lineNumber;
    }

    public boolean isActionEnabled(String action, Lookup context) throws IllegalArgumentException {
        FileObject fo = (FileObject)context.lookup(FileObject.class);
        switch (action) {
            case "debug.single.method": 
            case "run.single.method": {
                SingleMethod m = (SingleMethod)context.lookup(SingleMethod.class);
                if (fo == null && m != null) {
                    fo = m.getFile();
                }
            }
            case "compile.single": 
            case "test.single": 
            case "run.single": 
            case "debug.test.single": 
            case "debug.single": {
                return fo != null;
            }
        }
        return SUPPORTED_ACTIONS.contains(action);
    }
}

