/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.problems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.JButton;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class ModulePathsProblemsProvider
implements ProjectProblemsProvider,
PropertyChangeListener,
FileChangeListener {
    private static final String PROP_TEST_MODULE_PATHS_CHECK = "ModulePathsProblems.test.paths.check";
    private static final RequestProcessor RESOLVER = new RequestProcessor(ModulePathsProblemsProvider.class);
    private final J2SEProject project;
    private final PropertyChangeSupport listeners;
    private final Collection<File> moduleInfoListeners;
    private Collection<ProjectProblemsProvider.ProjectProblem> cache;
    private boolean listensOnRoots;
    private boolean listensOnEval;

    public ModulePathsProblemsProvider(@NonNull Lookup baseLkp) {
        this.project = (J2SEProject)baseLkp.lookup(J2SEProject.class);
        if (this.project == null) {
            throw new IllegalArgumentException("No project of type J2SEProject in lookup: " + baseLkp);
        }
        this.moduleInfoListeners = new HashSet<File>();
        this.listeners = new PropertyChangeSupport(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        Collection<ProjectProblemsProvider.ProjectProblem> res;
        ModulePathsProblemsProvider modulePathsProblemsProvider = this;
        synchronized (modulePathsProblemsProvider) {
            res = this.cache;
        }
        if (res == null) {
            HashSet roots;
            SourceRoots test;
            SourceRoots src;
            boolean disabled;
            AuxiliaryProperties props = (AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class);
            boolean bl = disabled = props != null && Boolean.FALSE.toString().equals(props.get(PROP_TEST_MODULE_PATHS_CHECK, true));
            if (disabled) {
                res = Collections.emptySet();
                src = null;
                test = null;
                roots = null;
            } else {
                src = this.project.getSourceRoots();
                test = this.project.getTestSourceRoots();
                roots = new HashSet();
                boolean modularSources = ModulePathsProblemsProvider.hasModuleInfo(src, roots);
                boolean modularTests = ModulePathsProblemsProvider.hasModuleInfo(test, roots);
                res = test.getRoots().length == 0 ? Collections.emptySet() : ModulePathsProblemsProvider.createProblems(this.project, modularSources, modularTests);
            }
            ModulePathsProblemsProvider modulePathsProblemsProvider2 = this;
            synchronized (modulePathsProblemsProvider2) {
                if (!this.listensOnEval) {
                    this.listensOnEval = true;
                    this.project.evaluator().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.project.evaluator()));
                }
                if (src != null && test != null && !this.listensOnRoots) {
                    this.listensOnRoots = true;
                    src.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)src));
                    test.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)test));
                }
                if (roots != null) {
                    HashSet<File> toRemove = new HashSet<File>(this.moduleInfoListeners);
                    toRemove.removeAll(roots);
                    roots.removeAll(this.moduleInfoListeners);
                    for (File f : toRemove) {
                        FileUtil.removeFileChangeListener((FileChangeListener)this, (File)J2SEProjectUtil.getModuleInfo(f));
                        this.moduleInfoListeners.remove(f);
                    }
                    for (File f : roots) {
                        FileUtil.addFileChangeListener((FileChangeListener)this, (File)J2SEProjectUtil.getModuleInfo(f));
                        this.moduleInfoListeners.add(f);
                    }
                }
                if (this.cache == null) {
                    this.cache = res;
                } else {
                    res = this.cache;
                }
            }
        }
        return res;
    }

    public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(@NonNull PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName == null || SourceRoots.PROP_ROOTS.equals(propName) || "javac.test.classpath".equals(propName) || "javac.test.modulepath".equals(propName) || "run.test.classpath".equals(propName) || "run.test.modulepath".equals(propName) || propName.contains(PROP_TEST_MODULE_PATHS_CHECK)) {
            this.reset();
        }
    }

    public void fileDataCreated(FileEvent fe) {
        this.reset();
    }

    public void fileDeleted(FileEvent fe) {
        this.reset();
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.reset();
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        ModulePathsProblemsProvider modulePathsProblemsProvider = this;
        synchronized (modulePathsProblemsProvider) {
            this.cache = null;
        }
        this.listeners.firePropertyChange("problems", null, null);
    }

    private static boolean hasModuleInfo(@NonNull SourceRoots roots, @NonNull Collection<? super File> rootsCollector) {
        boolean res = false;
        for (FileObject root : roots.getRoots()) {
            FileObject mInfo = J2SEProjectUtil.getModuleInfo(root);
            res |= Optional.ofNullable(mInfo).isPresent() && ClassPath.getClassPath((FileObject)root, (String)"classpath/source").contains(mInfo);
            Optional.ofNullable(FileUtil.toFile((FileObject)root)).ifPresent(rootsCollector::add);
        }
        return res;
    }

    private static boolean hasRef(@NonNull EditableProperties ep, @NonNull String pathId, @NonNull String propertyName) {
        return Optional.ofNullable(ep.getProperty(pathId)).map(val -> {
            String ref = J2SEProjectUtil.ref(propertyName, true);
            return Arrays.stream(PropertyUtils.tokenizePath((String)val)).anyMatch(element -> ref.equals(element));
        }).orElse(Boolean.FALSE);
    }

    private static Collection<ProjectProblemsProvider.ProjectProblem> createProblems(@NonNull J2SEProject project, @NonNull boolean modularSources, @NonNull boolean modularTests) {
        EditableProperties ep = project.getUpdateHelper().getProperties("nbproject/project.properties");
        if (modularSources) {
            if (modularTests) {
                return ModulePathsProblemsProvider.hasRef(ep, "javac.test.classpath", "build.classes.dir") || !ModulePathsProblemsProvider.hasRef(ep, "javac.test.modulepath", "build.classes.dir") || ModulePathsProblemsProvider.hasRef(ep, "run.test.classpath", "build.test.classes.dir") || !ModulePathsProblemsProvider.hasRef(ep, "run.test.modulepath", "build.test.classes.dir") ? Collections.singleton(ProjectProblemsProvider.ProjectProblem.createError((String)NbBundle.getMessage(ModulePathsProblemsProvider.class, (String)"TXT_InvalidModulePaths"), (String)NbBundle.getMessage(ModulePathsProblemsProvider.class, (String)"DESC_InvalidModulePathsBlackBox"), (ProjectProblemResolver)new FixBrokenModulePaths(project, modularSources, modularTests))) : Collections.emptySet();
            }
            return ModulePathsProblemsProvider.hasRef(ep, "javac.test.classpath", "build.classes.dir") || !ModulePathsProblemsProvider.hasRef(ep, "javac.test.modulepath", "build.classes.dir") || ModulePathsProblemsProvider.hasRef(ep, "run.test.classpath", "build.test.classes.dir") || ModulePathsProblemsProvider.hasRef(ep, "run.test.modulepath", "build.test.classes.dir") ? Collections.singleton(ProjectProblemsProvider.ProjectProblem.createError((String)NbBundle.getMessage(ModulePathsProblemsProvider.class, (String)"TXT_InvalidModulePaths"), (String)NbBundle.getMessage(ModulePathsProblemsProvider.class, (String)"DESC_InvalidModulePathsWhiteBox"), (ProjectProblemResolver)new FixBrokenModulePaths(project, modularSources, modularTests))) : Collections.emptySet();
        }
        return !ModulePathsProblemsProvider.hasRef(ep, "javac.test.classpath", "build.classes.dir") || ModulePathsProblemsProvider.hasRef(ep, "javac.test.modulepath", "build.classes.dir") || !ModulePathsProblemsProvider.hasRef(ep, "run.test.classpath", "build.test.classes.dir") || ModulePathsProblemsProvider.hasRef(ep, "run.test.modulepath", "build.test.classes.dir") ? Collections.singleton(ProjectProblemsProvider.ProjectProblem.createError((String)NbBundle.getMessage(ModulePathsProblemsProvider.class, (String)"TXT_InvalidClassPaths"), (String)NbBundle.getMessage(ModulePathsProblemsProvider.class, (String)"DESC_InvalidClassPaths"), (ProjectProblemResolver)new FixBrokenModulePaths(project, modularSources, modularTests))) : Collections.emptySet();
    }

    private static final class FixBrokenModulePaths
    implements ProjectProblemResolver {
        private final J2SEProject project;
        private final boolean modularSources;
        private final boolean modularTests;

        FixBrokenModulePaths(@NonNull J2SEProject project, boolean modularSources, boolean modularTests) {
            this.project = project;
            this.modularSources = modularSources;
            this.modularTests = modularTests;
        }

        public boolean equals(@NullAllowed Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof FixBrokenModulePaths)) {
                return false;
            }
            return Objects.equals(this.project.getProjectDirectory(), ((FixBrokenModulePaths)obj).project.getProjectDirectory());
        }

        public int hashCode() {
            return Objects.hashCode(this.project.getProjectDirectory());
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            JButton fix = new JButton(NbBundle.getMessage(ModulePathsProblemsProvider.class, (String)"TXT_Update"));
            JButton ignore = new JButton(NbBundle.getMessage(ModulePathsProblemsProvider.class, (String)"TXT_Ignore"));
            NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(ModulePathsProblemsProvider.class, (String)"MSG_FixPaths", (Object)NbBundle.getMessage(ModulePathsProblemsProvider.class, (String)(this.modularSources ? "MSG_Modular" : "MSG_NonModular"))), NbBundle.getMessage(ModulePathsProblemsProvider.class, (String)"TITLE_FixPaths"), 0, 3, new Object[]{fix, ignore}, (Object)fix);
            Callable<ProjectProblemsProvider.Result> action = DialogDisplayer.getDefault().notify(nd) == fix ? () -> {
                ProjectManager.mutex().writeAccess(() -> {
                    EditableProperties ep = this.project.getUpdateHelper().getProperties("nbproject/project.properties");
                    boolean changed = false;
                    if (this.modularSources) {
                        if (this.modularTests) {
                            changed |= FixBrokenModulePaths.removeRef(ep, "javac.test.classpath", "build.classes.dir");
                            changed |= FixBrokenModulePaths.addRefIfAbsent(ep, "javac.test.modulepath", "build.classes.dir", "javac.modulepath");
                            changed |= FixBrokenModulePaths.removeRef(ep, "run.test.classpath", "build.test.classes.dir");
                            changed |= FixBrokenModulePaths.addRefIfAbsent(ep, "run.test.modulepath", "build.test.classes.dir", "javac.test.modulepath");
                        } else {
                            changed |= FixBrokenModulePaths.removeRef(ep, "javac.test.classpath", "build.classes.dir");
                            changed |= FixBrokenModulePaths.addRefIfAbsent(ep, "javac.test.modulepath", "build.classes.dir", "javac.modulepath");
                            changed |= FixBrokenModulePaths.removeRef(ep, "run.test.classpath", "build.test.classes.dir");
                            changed |= FixBrokenModulePaths.removeRef(ep, "run.test.modulepath", "build.test.classes.dir");
                        }
                    } else {
                        changed |= FixBrokenModulePaths.addRefIfAbsent(ep, "javac.test.classpath", "build.classes.dir", "javac.classpath");
                        changed |= FixBrokenModulePaths.removeRef(ep, "javac.test.modulepath", "build.classes.dir");
                        changed |= FixBrokenModulePaths.addRefIfAbsent(ep, "run.test.classpath", "build.test.classes.dir", "javac.test.classpath");
                        changed |= FixBrokenModulePaths.removeRef(ep, "run.test.modulepath", "build.test.classes.dir");
                    }
                    if (changed) {
                        try {
                            this.project.getUpdateHelper().putProperties("nbproject/project.properties", ep);
                            ProjectManager.getDefault().saveProject((Project)this.project);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
                return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
            } : () -> {
                ProjectManager.mutex().writeAccess(() -> {
                    try {
                        AuxiliaryProperties props = (AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class);
                        props.put(ModulePathsProblemsProvider.PROP_TEST_MODULE_PATHS_CHECK, Boolean.FALSE.toString(), true);
                        ProjectManager.getDefault().saveProject((Project)this.project);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                });
                return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
            };
            return RESOLVER.submit(action);
        }

        private static boolean removeRef(@NonNull EditableProperties ep, @NonNull String pathId, @NonNull String elementToRemove) {
            String elementToRemoveRef = J2SEProjectUtil.ref(elementToRemove, true);
            boolean[] changed = new boolean[1];
            Optional.ofNullable(ep.getProperty(pathId)).map(val -> (String[])Arrays.stream(PropertyUtils.tokenizePath((String)val)).filter(element -> {
                boolean remove = elementToRemoveRef.equals(element);
                changed[0] = changed[0] | remove;
                return !remove;
            }).toArray(String[]::new)).ifPresent(val -> ep.setProperty(pathId, FixBrokenModulePaths.addPathSeparators(val)));
            return changed[0];
        }

        private static boolean addRefIfAbsent(@NonNull EditableProperties ep, @NonNull String pathId, @NonNull String elementToAdd, @NullAllowed String insertAfter) {
            String elementToAddRef = J2SEProjectUtil.ref(elementToAdd, true);
            String insertAfterRef = insertAfter == null ? null : J2SEProjectUtil.ref(insertAfter, true);
            boolean[] changed = new boolean[1];
            Optional.ofNullable(ep.getProperty(pathId)).map(val -> {
                String[] path = PropertyUtils.tokenizePath((String)val);
                if (!Arrays.stream(path).anyMatch(element -> elementToAddRef.equals(element))) {
                    ArrayList<String> newPath = new ArrayList<String>(path.length + 1);
                    boolean added = false;
                    for (int i = 0; i < path.length; ++i) {
                        newPath.add(path[i]);
                        if (insertAfterRef == null || !insertAfterRef.equals(path[i])) continue;
                        added = true;
                        newPath.add(elementToAddRef);
                    }
                    if (!added) {
                        newPath.add(elementToAddRef);
                    }
                    path = newPath.toArray(new String[0]);
                    changed[0] = true;
                }
                return path;
            }).ifPresent(val -> ep.setProperty(pathId, FixBrokenModulePaths.addPathSeparators(val)));
            return changed[0];
        }

        @NonNull
        private static String[] addPathSeparators(String ... path) {
            for (int i = 0; i < path.length; ++i) {
                path[i] = i + 1 == path.length ? path[i] : String.format("%s:", path[i]);
            }
            return path;
        }
    }
}

