/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.tree.Tree;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

public class TreeShims {
    public static List<DocTree> getSnippetDocTreeAttributes(DocTree node) {
        try {
            Class<?> gpt = Class.forName("com.sun.source.doctree.SnippetTree");
            return TreeShims.isJDKVersionRelease18_Or_Above() ? (List)gpt.getDeclaredMethod("getAttributes", new Class[0]).invoke((Object)node, new Object[0]) : null;
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw TreeShims.throwAny(ex);
        }
    }

    public static TextTree getSnippetDocTreeText(DocTree node) {
        try {
            Class<?> gpt = Class.forName("com.sun.source.doctree.SnippetTree");
            return TreeShims.isJDKVersionRelease18_Or_Above() ? (TextTree)gpt.getDeclaredMethod("getBody", new Class[0]).invoke((Object)node, new Object[0]) : null;
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw TreeShims.throwAny(ex);
        }
    }

    public static Element toRecordComponent(Element el) {
        if (el == null || el.getKind() != ElementKind.FIELD) {
            return el;
        }
        TypeElement owner = (TypeElement)el.getEnclosingElement();
        if (!"RECORD".equals(owner.getKind().name())) {
            return el;
        }
        for (Element element : ElementFilter.recordComponentsIn(owner.getEnclosedElements())) {
            if (!element.getSimpleName().equals(el.getSimpleName())) continue;
            return element;
        }
        return el;
    }

    public static boolean isPatternMatch(Tree node) {
        if (TreeShims.isJDKVersionRelease17_Or_Above()) {
            try {
                return node.getClass().getField("patternSwitch").getBoolean(node);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                throw TreeShims.throwAny(ex);
            }
        }
        return false;
    }

    public static boolean isJDKVersionRelease17_Or_Above() {
        return Integer.valueOf(SourceVersion.latest().name().split("_")[1]).compareTo(17) >= 0;
    }

    public static boolean isJDKVersionRelease18_Or_Above() {
        return Integer.valueOf(SourceVersion.latest().name().split("_")[1]).compareTo(18) >= 0;
    }

    public static <T extends Throwable> RuntimeException throwAny(Throwable t) throws T {
        throw t;
    }
}

