/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco.archive;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.java.disco.archive.CommandLineUntar;
import org.netbeans.modules.java.disco.archive.CommandLineUnzip;
import org.netbeans.modules.java.disco.archive.JDKCommonsUnzip;
import org.netbeans.modules.java.disco.archive.Unarchiver;
import org.openide.windows.InputOutput;

public class UnarchiveUtils {
    private static final Unarchiver[] zipUnarchivers = new Unarchiver[]{new CommandLineUnzip(), new CommandLineUntar(), new JDKCommonsUnzip()};

    private static File getSafeOutputDir(File file) {
        File parent = file.getParentFile();
        String name = file.getName();
        int dot = name.lastIndexOf(46);
        String baseName = dot == -1 ? name : name.substring(0, dot);
        File outputFile = new File(parent, baseName);
        int counter = 1;
        while (outputFile.exists()) {
            outputFile = new File(parent, baseName + "_" + counter);
            ++counter;
        }
        outputFile.mkdirs();
        return outputFile;
    }

    public static File unarchive(File file, InputOutput io) throws IOException, InterruptedException {
        File outputDir = UnarchiveUtils.getSafeOutputDir(file);
        UnarchiveUtils.unarchive(file, outputDir, io);
        return outputDir;
    }

    public static void unarchive(File file, File outputDir, InputOutput io) throws IOException, InterruptedException {
        if (!UnarchiveUtils.isArchiveFile(file)) {
            throw new UnsupportedOperationException("Unknown archive");
        }
        UnarchiveUtils.unarchive(file, outputDir, zipUnarchivers, io);
    }

    private static void unarchive(File file, File outputDir, Unarchiver[] zipUnarchivers, InputOutput io) throws IOException, InterruptedException {
        for (Unarchiver u : zipUnarchivers) {
            try {
                u.uncompress(file, outputDir, io);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        throw new UnsupportedOperationException("Could not unarchive " + file);
    }

    public static boolean isArchiveFile(File download) {
        for (Unarchiver u : zipUnarchivers) {
            if (!u.isSupported(download)) continue;
            return true;
        }
        return false;
    }
}

