/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui.customizer.vmo;

import java.util.AbstractMap;
import java.util.Map;

public abstract class OptionValue<V> {
    private boolean present = false;
    private V value;
    private final String kind;

    protected OptionValue(String kind) {
        this.kind = kind;
    }

    public boolean isPresent() {
        return this.present;
    }

    public void setPresent(boolean present) {
        this.present = present;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{present=" + this.present + ", value=" + this.value + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OptionValue)) {
            return false;
        }
        OptionValue that = (OptionValue)o;
        if (!this.kind.equals(that.kind)) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.kind.hashCode();
        return result;
    }

    public static OptionValue<Boolean> createSwitch() {
        return new SwitchOnly(true);
    }

    public static class SwitchOnly
    extends OptionValue<Boolean> {
        private static final String KIND = "Boolean";

        public SwitchOnly(boolean present) {
            super(KIND);
            this.setPresent(present);
        }

        @Override
        public void setValue(Boolean value) {
            this.setPresent(value);
        }

        @Override
        public Boolean getValue() {
            return this.isPresent();
        }
    }

    public static class SimpleString
    extends OptionValue<String> {
        private static final String KIND = "String";

        public SimpleString() {
            super(KIND);
        }

        public SimpleString(String value) {
            this();
            this.setValue(value);
        }

        @Override
        public void setValue(String value) {
            super.setValue(value);
            this.setPresent(value != null && !value.isEmpty());
        }
    }

    public static class StringPair
    extends OptionValue<Map.Entry<String, String>> {
        private static final String KIND = "Map.Entry<String,String>";

        public StringPair() {
            this(null, null);
        }

        public StringPair(String name, String value) {
            super(KIND);
            this.setValue((Map.Entry<String, String>)new AbstractMap.SimpleEntry<String, String>(name, value));
        }

        @Override
        public void setValue(Map.Entry<String, String> value) {
            super.setValue(value);
            this.setPresent(value != null && value.getKey() != null && !value.getKey().isEmpty());
        }
    }
}

