/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.unit;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelDS;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelJdbc;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PersistenceUnitWizardDescriptor
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private PersistenceUnitWizardPanelDS datasourcePanel;
    private PersistenceUnitWizardPanelJdbc jdbcPanel;
    private PersistenceUnitWizardPanel panel;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private WizardDescriptor wizardDescriptor;
    private Project project;
    private boolean isContainerManaged;
    private static String ERROR_MSG_KEY = "WizardPanel_errorMessage";

    public PersistenceUnitWizardDescriptor(Project project) {
        this.project = project;
        this.isContainerManaged = Util.isContainerManaged(project);
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public Component getComponent() {
        if (this.panel == null) {
            if (this.isContainerManaged) {
                this.datasourcePanel = new PersistenceUnitWizardPanelDS(this.project, this, true);
                this.panel = this.datasourcePanel;
            } else {
                this.jdbcPanel = new PersistenceUnitWizardPanelJdbc(this.project, this, true);
                this.panel = this.jdbcPanel;
            }
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Object newvalue;
                    if (evt.getPropertyName().equals("PersistenceUnitWizardPanel_isValid") && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                        PersistenceUnitWizardDescriptor.this.stateChanged(null);
                    }
                }
            });
        }
        return this.panel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(PersistenceUnitWizardDescriptor.class);
    }

    public boolean isValid() {
        if (this.wizardDescriptor == null) {
            return true;
        }
        if (!ProviderUtil.isValidServerInstanceOrNone(this.project)) {
            this.wizardDescriptor.putProperty(ERROR_MSG_KEY, (Object)NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_MissingServer"));
            return false;
        }
        if (this.panel != null && !this.panel.isValidPanel()) {
            try {
                if (!this.panel.isNameUnique()) {
                    this.wizardDescriptor.putProperty(ERROR_MSG_KEY, (Object)NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_PersistenceUnitNameNotUnique"));
                }
            }
            catch (InvalidPersistenceXmlException ipx) {
                this.wizardDescriptor.putProperty(ERROR_MSG_KEY, (Object)NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_InvalidPersistenceXml", (Object)ipx.getPath()));
            }
            return false;
        }
        this.wizardDescriptor.putProperty(ERROR_MSG_KEY, (Object)" ");
        return true;
    }

    public void readSettings(Object settings) {
        this.wizardDescriptor = (WizardDescriptor)settings;
        this.project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void storeSettings(Object settings) {
    }

    public boolean isFinishPanel() {
        return this.isValid();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }

    public String getPersistenceUnitName() {
        return this.panel.getPersistenceUnitName();
    }

    public DatabaseConnection getPersistenceConnection() {
        return this.jdbcPanel == null ? null : this.jdbcPanel.getPersistenceConnection();
    }

    public String getDatasource() {
        return this.datasourcePanel == null ? null : this.datasourcePanel.getDatasource();
    }

    public String getDBResourceSelection() {
        return this.getPersistenceConnection() != null ? this.getPersistenceConnection().getName() : this.getDatasource();
    }

    public boolean isContainerManaged() {
        return this.isContainerManaged;
    }

    public boolean isJTA() {
        return this.datasourcePanel == null ? false : this.datasourcePanel.isJTA();
    }

    boolean isNonDefaultProviderEnabled() {
        return this.datasourcePanel == null ? false : this.datasourcePanel.isNonDefaultProviderEnabled();
    }

    public String getNonDefaultProvider() {
        return this.datasourcePanel == null ? null : this.datasourcePanel.getNonDefaultProvider();
    }

    public String getTableGeneration() {
        return this.panel.getTableGeneration();
    }

    public Provider getSelectedProvider() {
        return this.panel.getSelectedProvider();
    }
}

