/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.rules;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.CallEjbGenerator;
import org.netbeans.modules.j2ee.ejbcore.util._RetoucheUtil;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.ejbverification.HintsUtils;
import org.netbeans.modules.j2ee.ejbverification.rules.Bundle;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.spi.ejbjar.support.EjbReferenceSupport;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class UseInjectionInsteadOfInstantionRule {
    private static final RequestProcessor RP = new RequestProcessor("UseInjectionInsteadOfInstantionFixRP", 1);

    private UseInjectionInsteadOfInstantionRule() {
    }

    public static ErrorDescription useInjectionInsteadOfInstantion(final HintContext ctx) {
        CompilationInfo cpi = ctx.getInfo();
        TreePath clazzTreePath = (TreePath)ctx.getVariables().get("$clazz");
        if (clazzTreePath == null) {
            return null;
        }
        Element element = cpi.getTrees().getElement(clazzTreePath);
        if (!(element instanceof TypeElement)) {
            return null;
        }
        final TypeElement enclosing = UseInjectionInsteadOfInstantionRule.findNearestTypeElement(ctx);
        if (enclosing == null) {
            return null;
        }
        final EJBProblemContext ejbContext = HintsUtils.getOrCacheContext(ctx, enclosing.asType().toString());
        if (ejbContext == null) {
            return null;
        }
        final TypeElement javaClass = (TypeElement)element;
        try {
            return (ErrorDescription)ejbContext.getEjbModule().getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, ErrorDescription>(){

                public ErrorDescription run(EjbJarMetadata metadata) {
                    Ejb ejb = metadata.findByEjbClass(ElementUtilities.getBinaryName((TypeElement)javaClass));
                    if (ejb != null) {
                        ReplaceInstantionByInjectionFix fix = new ReplaceInstantionByInjectionFix(ctx, ejbContext.getEjbModule(), enclosing);
                        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.UseInjectionInsteadOfInstantionRule_error(), (Fix[])new Fix[]{fix});
                    }
                    return null;
                }
            });
        }
        catch (MetadataModelException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private static TypeElement findNearestTypeElement(HintContext ctx) {
        for (Tree next : ctx.getPath()) {
            if (next.getKind() != Tree.Kind.CLASS) continue;
            TreePath path = ctx.getInfo().getTrees().getPath(ctx.getInfo().getCompilationUnit(), next);
            return (TypeElement)ctx.getInfo().getTrees().getElement(path);
        }
        return null;
    }

    private static class ReplaceInstantionByInjectionFix
    implements Fix {
        private final HintContext context;
        private final EjbJar ejbJar;
        private final TypeElement enclosing;

        public ReplaceInstantionByInjectionFix(HintContext context, EjbJar ejbJar, TypeElement enclosing) {
            this.context = context;
            this.ejbJar = ejbJar;
            this.enclosing = enclosing;
        }

        public String getText() {
            return Bundle.UseInjectionInsteadOfInstantionRule_fix();
        }

        public ChangeInfo implement() throws Exception {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        Fix removeFromParent = JavaFixUtilities.removeFromParent((HintContext)ReplaceInstantionByInjectionFix.this.context, null, (TreePath)ReplaceInstantionByInjectionFix.this.context.getPath());
                        removeFromParent.implement();
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    try {
                        TypeElement javaClass = (TypeElement)ReplaceInstantionByInjectionFix.this.context.getInfo().getTrees().getElement((TreePath)ReplaceInstantionByInjectionFix.this.context.getVariables().get("$clazz"));
                        FileObject referencingFO = ReplaceInstantionByInjectionFix.this.context.getInfo().getFileObject();
                        String referencingBN = ElementUtilities.getBinaryName((TypeElement)ReplaceInstantionByInjectionFix.this.enclosing);
                        String referencedSN = javaClass.getSimpleName().toString();
                        String name = _RetoucheUtil.uniqueMemberName((FileObject)referencingFO, (String)referencingBN, (String)referencedSN, (String)referencedSN);
                        CallEjbGenerator generator = CallEjbGenerator.create((EjbReference)EjbReferenceSupport.createEjbReference((EjbJar)ReplaceInstantionByInjectionFix.this.ejbJar, (String)javaClass.toString()), (String)name, (boolean)true);
                        generator.addReference(referencingFO, referencingBN, SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)javaClass), (ClasspathInfo)ReplaceInstantionByInjectionFix.this.context.getInfo().getClasspathInfo()), ElementUtilities.getBinaryName((TypeElement)javaClass), null, EjbReference.EjbRefIType.NO_INTERFACE, false, FileOwnerQuery.getOwner((FileObject)ReplaceInstantionByInjectionFix.this.context.getInfo().getFileObject()));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            return null;
        }
    }
}

