/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class WrapperServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(WrapperServlet.class.getName());
    private static final long serialVersionUID = 8009602136746998361L;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream out = response.getOutputStream();
        try {
            FileObject file = URLMapper.findFileObject((URL)new URL(request.getRequestURL().toString()));
            if (file == null) {
                LOG.log(Level.FINE, "File not found: " + request.getRequestURL().toString());
                response.sendError(404);
                return;
            }
            URL internal = URLMapper.findURL((FileObject)file, (int)0);
            URLConnection conn = internal.openConnection();
            String type = conn.getContentType();
            if (type == null || "content/unknown".equals(type)) {
                type = file.getMIMEType();
            }
            if ((type == null || "content/unknown".equals(type)) && file.getExt().equals("css")) {
                type = "text/css";
            }
            response.setContentType(type);
            try (InputStream in = conn.getInputStream();){
                int len;
                byte[] buff = new byte[256];
                while ((len = in.read(buff)) != -1) {
                    out.write(buff, 0, len);
                    out.flush();
                }
            }
        }
        catch (IllegalArgumentException | MalformedURLException ex) {
            LOG.log(Level.FINE, "Failed to parse target URL from request: " + request.getRequestURL().toString(), ex);
            try {
                response.sendError(404, NbBundle.getMessage(WrapperServlet.class, (String)"MSG_HTTP_NOT_FOUND"));
            }
            catch (IOException iOException) {}
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, "Failed read data for request: " + request.getRequestURL().toString(), ex);
            try {
                response.sendError(500);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

