/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.validation;

import java.util.ArrayList;
import java.util.List;
import nu.validator.htmlparser.common.CharacterHandler;
import org.xml.sax.SAXException;

public class LinesMapper
implements CharacterHandler {
    private final List<Line> lines = new ArrayList<Line>();
    private Line currentLine = null;
    private boolean prevWasCr = false;
    final StringBuilder content = new StringBuilder();

    public CharSequence getSourceText() {
        return this.content;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        int from = this.content.length();
        this.content.append(ch, start, length);
        int to = this.content.length();
        block4: for (int i = from; i < to; ++i) {
            char c = this.content.charAt(i);
            switch (c) {
                case '\r': {
                    this.currentLine.setCR();
                    this.currentLine.setEnd(i + 1);
                    this.prevWasCr = true;
                    continue block4;
                }
                case '\n': {
                    this.currentLine.setLF();
                    this.currentLine.setEnd(i + 1);
                    this.prevWasCr = false;
                    this.newLine(i + 1);
                    continue block4;
                }
                default: {
                    this.currentLine.setEnd(i + 1);
                    if (!this.prevWasCr) continue block4;
                    this.prevWasCr = false;
                    this.newLine(i);
                }
            }
        }
    }

    private void newLine(int from) {
        this.currentLine = new Line(from);
        this.lines.add(this.currentLine);
    }

    public void end() throws SAXException {
    }

    public void start() throws SAXException {
        this.lines.clear();
        this.newLine(0);
        this.prevWasCr = false;
    }

    public int getLinesCount() {
        return this.lines.size();
    }

    public Line getLine(int linenum) {
        return this.lines.get(linenum);
    }

    public int getSourceOffsetForLocation(int line, int column) {
        if (line == -1 || column == -1) {
            throw new IllegalArgumentException();
        }
        Line lline = this.lines.get(line);
        int sourceOffset = lline.getOffset() + column;
        if (sourceOffset > this.content.length()) {
            return this.content.length();
        }
        return sourceOffset;
    }

    public class Line {
        private int start;
        private int end;
        private boolean cr;
        private boolean lf;

        public Line(int offset) {
            this.start = offset;
            this.end = offset;
        }

        public void setCR() {
            this.cr = true;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public void setLF() {
            this.lf = true;
        }

        public CharSequence getText() {
            return LinesMapper.this.content.subSequence(this.start, this.end - this.getNewLineDelimitersLen());
        }

        public CharSequence getTextWithEndLineChars() {
            return LinesMapper.this.content.subSequence(this.start, this.end);
        }

        public int getNewLineDelimitersLen() {
            return (this.cr ? 1 : 0) + (this.lf ? 1 : 0);
        }

        public int getOffset() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String toString() {
            return "Line{" + this.start + "-" + this.end + " " + (this.cr ? "\\r" : "") + (this.lf ? "\\n" : "") + " '" + this.getText() + "'";
        }
    }
}

