/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.ojet.ui.wizard;

import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.html.ojet.ui.wizard.NewJetModuleWizardPanel;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public final class NewJetModuleWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator<WizardDescriptor> {
    private static final Logger LOGGER = Logger.getLogger(NewJetModuleWizardIterator.class.getName());
    private final Type type;
    private WizardDescriptor descriptor;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private int index;

    private NewJetModuleWizardIterator(Type type) {
        assert (type != null);
        this.type = type;
    }

    public static NewJetModuleWizardIterator empty() {
        return new NewJetModuleWizardIterator(Type.EMPTY);
    }

    public static NewJetModuleWizardIterator knockout() {
        return new NewJetModuleWizardIterator(Type.KNOCKOUT);
    }

    public void initialize(WizardDescriptor wizard) {
        this.descriptor = wizard;
        this.init();
        this.panels = this.getPanels();
        String[] beforeSteps = (String[])wizard.getProperty("WizardPanel_contentData");
        int beforeStepLength = beforeSteps.length - 1;
        String[] steps = this.createSteps(beforeSteps);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i + beforeStepLength - 1);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public Set<FileObject> instantiate() throws IOException {
        Project project = Templates.getProject((WizardDescriptor)this.descriptor);
        if (project == null) {
            LOGGER.log(Level.INFO, "Project is required");
            return Collections.emptySet();
        }
        HashSet<FileObject> files = new HashSet<FileObject>();
        FileObject projectDirectory = project.getProjectDirectory();
        String name = (String)this.descriptor.getProperty("FILE_NAME");
        String jsFolder = (String)this.descriptor.getProperty("JS_FOLDER");
        String htmlFolder = (String)this.descriptor.getProperty("HTML_FOLDER");
        Map<String, String> templateParams = Collections.singletonMap("name", name);
        FileObject folder = FileUtil.createFolder((FileObject)projectDirectory, (String)jsFolder);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)folder);
        DataObject dataTemplate = DataObject.find((FileObject)FileUtil.getConfigFile((String)this.type.getJsTemplatePath()));
        DataObject createdFile = dataTemplate.createFromTemplate(dataFolder, name + ".js", templateParams);
        files.add(createdFile.getPrimaryFile());
        folder = FileUtil.createFolder((FileObject)projectDirectory, (String)htmlFolder);
        dataFolder = DataFolder.findFolder((FileObject)folder);
        dataTemplate = DataObject.find((FileObject)FileUtil.getConfigFile((String)this.type.getHtmlTemplatePath()));
        createdFile = dataTemplate.createFromTemplate(dataFolder, name + ".html", templateParams);
        files.add(createdFile.getPrimaryFile());
        return files;
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] getPanels() {
        return new WizardDescriptor.Panel[]{new NewJetModuleWizardPanel()};
    }

    private void init() {
        Project project = Templates.getProject((WizardDescriptor)this.descriptor);
        if (project == null) {
            LOGGER.log(Level.INFO, "Project is required");
            return;
        }
        String jsFolder = this.resolveWebRootPath(project, "js/viewModels");
        String htmlFolder = this.resolveWebRootPath(project, "js/views");
        this.descriptor.putProperty("FILE_NAME", (Object)this.findFreeFilename(project.getProjectDirectory(), jsFolder, htmlFolder, "home"));
        this.descriptor.putProperty("PROJECT", (Object)project);
        this.descriptor.putProperty("JS_FOLDER", (Object)jsFolder);
        this.descriptor.putProperty("HTML_FOLDER", (Object)htmlFolder);
    }

    private String[] createSteps(String[] beforeSteps) {
        int beforeStepLength = beforeSteps.length - 1;
        String[] res = new String[beforeStepLength + this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeStepLength ? beforeSteps[i] : this.panels[i - beforeStepLength].getComponent().getName();
        }
        return res;
    }

    private String resolveWebRootPath(Project project, String path) {
        FileObject webRoot = this.getWebRoot(project);
        String relativePath = FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)webRoot);
        if (relativePath == null) {
            return path;
        }
        if (relativePath.isEmpty()) {
            return path;
        }
        return relativePath + "/" + path;
    }

    @NonNull
    private FileObject getWebRoot(Project project) {
        Collection webRoots = ProjectWebRootQuery.getWebRoots((Project)project);
        if (webRoots.isEmpty()) {
            return project.getProjectDirectory();
        }
        return (FileObject)webRoots.iterator().next();
    }

    private String findFreeFilename(FileObject projectDirectory, String jsFolder, String htmlFolder, String name) {
        String tmpname = name;
        for (int i = 0; i < 100; ++i) {
            if (projectDirectory.getFileObject(jsFolder + "/" + tmpname + ".js") == null && projectDirectory.getFileObject(htmlFolder + "/" + tmpname + ".html") == null) {
                return tmpname;
            }
            tmpname = name + i;
        }
        return name;
    }

    private static enum Type {
        EMPTY{

            @Override
            String getJsTemplatePath() {
                return "Templates/ClientSide/OJET/EmptyJETModule-js";
            }

            @Override
            String getHtmlTemplatePath() {
                return "Templates/ClientSide/OJET/EmptyJETModule-html";
            }
        }
        ,
        KNOCKOUT{

            @Override
            String getJsTemplatePath() {
                return "Templates/ClientSide/OJET/KnockoutJETModule-js";
            }

            @Override
            String getHtmlTemplatePath() {
                return "Templates/ClientSide/OJET/KnockoutJETModule-html";
            }
        };


        abstract String getJsTemplatePath();

        abstract String getHtmlTemplatePath();
    }
}

