/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.custom.hints;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.html.custom.conf.Attribute;
import org.netbeans.modules.html.custom.hints.Bundle;
import org.netbeans.modules.html.custom.hints.Utils;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.util.Exceptions;

public final class AddAttributeToSourceFix
implements HintFix {
    private final Collection<Attribute> attrs;
    private final OpenTag openTag;
    private final Snapshot snapshot;

    public AddAttributeToSourceFix(Collection<Attribute> attrs, OpenTag openTag, Snapshot snapshot) {
        this.attrs = attrs;
        this.openTag = openTag;
        this.snapshot = snapshot;
    }

    public AddAttributeToSourceFix(Attribute attributeName, OpenTag openTag, Snapshot snapshot) {
        this(Collections.singleton(attributeName), openTag, snapshot);
    }

    public String getDescription() {
        return Bundle.addAttributeToSource(Utils.attributes2String(this.attrs), this.openTag.name().toString());
    }

    public void implement() throws Exception {
        final StringBuilder insertText = new StringBuilder();
        insertText.append(' ');
        Iterator<Attribute> i = this.attrs.iterator();
        while (i.hasNext()) {
            Attribute a = i.next();
            insertText.append(a.getName());
            insertText.append("=\"\"");
            if (!i.hasNext()) continue;
            insertText.append(' ');
        }
        final BaseDocument document = (BaseDocument)this.snapshot.getSource().getDocument(true);
        document.runAtomicAsUser(new Runnable(){

            @Override
            public void run() {
                try {
                    int insertOffset = AddAttributeToSourceFix.this.openTag.from() + "<".length() + AddAttributeToSourceFix.this.openTag.name().length();
                    int documentInsertOffset = AddAttributeToSourceFix.this.snapshot.getOriginalOffset(insertOffset);
                    document.insertString(documentInsertOffset, insertText.toString(), null);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        LexerUtils.rebuildTokenHierarchy((Document)document);
    }

    public boolean isSafe() {
        return true;
    }

    public boolean isInteractive() {
        return false;
    }
}

