/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.clone;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitURI;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.clone.Bundle;
import org.netbeans.modules.git.ui.clone.CloneDestinationPanel;
import org.netbeans.modules.git.ui.wizards.AbstractWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CloneDestinationStep
extends AbstractWizardPanel
implements DocumentListener,
ItemListener,
WizardDescriptor.FinishablePanel<WizardDescriptor> {
    static final String CLONE_TARGET_DIRECTORY = "cloneDestinationStep.cloneDirectory";
    private final CloneDestinationPanel panel = new CloneDestinationPanel();

    public CloneDestinationStep() {
        this.panel.directoryField.getDocument().addDocumentListener(this);
        this.panel.nameField.getDocument().addDocumentListener(this);
        this.panel.remoteTextField.getDocument().addDocumentListener(this);
        this.panel.branchesComboBox.addItemListener(this);
        this.panel.branchesComboBox.setRenderer(new BranchRenderer());
        this.validateNoEmptyFields();
    }

    @Override
    public JComponent getJComponent() {
        return this.panel;
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(CloneDestinationStep.class);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateNoEmptyFields();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateNoEmptyFields();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateNoEmptyFields();
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        this.validateNoEmptyFields();
    }

    public boolean isFinishPanel() {
        return true;
    }

    @Override
    protected boolean validateBeforeNext() {
        if (this.validateNoEmptyFields()) {
            return false;
        }
        GitProgressSupport support = new GitProgressSupport(){

            @Override
            protected void perform() {
                CloneDestinationStep.this.setEnabled(false);
                try {
                    File dest = CloneDestinationStep.this.getDestination();
                    if (!dest.exists()) {
                        return;
                    }
                    if (dest.isFile()) {
                        CloneDestinationStep.this.setValid(false, new AbstractWizardPanel.Message(NbBundle.getMessage(CloneDestinationStep.class, (String)"MSG_DEST_IS_FILE_ERROR"), false));
                        return;
                    }
                    File[] files = dest.listFiles();
                    if (files != null && files.length > 0) {
                        CloneDestinationStep.this.setValid(false, new AbstractWizardPanel.Message(NbBundle.getMessage(CloneDestinationStep.class, (String)"MSG_DEST_IS_NOT_EMPTY_ERROR"), false));
                    }
                }
                finally {
                    CloneDestinationStep.this.setEnabled(true);
                }
            }
        };
        support.start(Git.getInstance().getRequestProcessor(), this.getDestination(), NbBundle.getMessage(CloneDestinationStep.class, (String)"MSG_VALIDATING_DESTINATION")).waitFinished();
        return this.isValid();
    }

    private boolean validateNoEmptyFields() throws MissingResourceException {
        String parent = this.panel.getDirectory();
        if (parent == null || parent.trim().isEmpty()) {
            this.setValid(false, new AbstractWizardPanel.Message(NbBundle.getMessage(CloneDestinationStep.class, (String)"MSG_EMPTY_PARENT_ERROR"), true));
            return true;
        }
        String name = this.panel.getCloneName();
        if (name == null || name.trim().isEmpty()) {
            this.setValid(false, new AbstractWizardPanel.Message(NbBundle.getMessage(CloneDestinationStep.class, (String)"MSG_EMPTY_NAME_ERROR"), true));
            return true;
        }
        String remoteName = this.panel.getRemoteName();
        if (remoteName == null || remoteName.trim().isEmpty()) {
            this.setValid(false, new AbstractWizardPanel.Message(NbBundle.getMessage(CloneDestinationStep.class, (String)"MSG_EMPTY_REMOTE_ERROR"), true));
            return true;
        }
        this.setValid(true, null);
        return false;
    }

    void setBranches(List<? extends GitBranch> branches) {
        DefaultComboBoxModel<GitBranch> model;
        if (branches == null) {
            return;
        }
        if (branches.isEmpty()) {
            model = new DefaultComboBoxModel<GitBranch>(new GitBranch[]{null});
            this.panel.branchesComboBox.setEnabled(false);
        } else {
            model = new DefaultComboBoxModel<GitBranch>(branches.toArray(new GitBranch[branches.size()]));
            this.panel.branchesComboBox.setEnabled(true);
        }
        this.panel.branchesComboBox.setModel(model);
        GitBranch activeBranch = null;
        for (GitBranch gitBranch : branches) {
            if (!gitBranch.isActive()) continue;
            activeBranch = gitBranch;
            break;
        }
        if (activeBranch != null) {
            this.panel.branchesComboBox.setSelectedItem(activeBranch);
        }
    }

    void setDestinationFolder(String folder) {
        this.panel.setDirectory(folder);
    }

    File getDestination() {
        return new File(this.panel.getDirectory() + File.separator + this.panel.getCloneName());
    }

    String getRemoteName() {
        return this.panel.remoteTextField.getText();
    }

    GitBranch getBranch() {
        return (GitBranch)this.panel.branchesComboBox.getSelectedItem();
    }

    boolean scanForProjects() {
        return this.panel.scanForProjectsCheckBox.isSelected();
    }

    void initCloneName(GitURI uri) {
        String path = uri.getPath();
        String[] pathElements = path.split("[/\\\\]");
        String lastElem = "";
        for (int i = pathElements.length - 1; i >= 0 && (lastElem = pathElements[i]).isEmpty(); --i) {
        }
        if (!lastElem.isEmpty()) {
            if (lastElem.endsWith(".git")) {
                lastElem = lastElem.substring(0, lastElem.length() - 4);
            }
            if (!lastElem.isEmpty()) {
                this.panel.nameField.setText(lastElem);
            }
        }
    }

    private void setEnabled(boolean en) {
        this.panel.branchesComboBox.setEnabled(en);
        this.panel.directoryField.setEnabled(en);
        this.panel.nameField.setEnabled(en);
        this.panel.remoteTextField.setEnabled(en);
        this.panel.scanForProjectsCheckBox.setEnabled(en);
    }

    private class BranchRenderer
    extends DefaultListCellRenderer {
        private BranchRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jlist, Object o, int i, boolean bln, boolean bln1) {
            if (o instanceof GitBranch) {
                GitBranch b = (GitBranch)o;
                return super.getListCellRendererComponent((JList<?>)jlist, b.getName() + (b.isActive() ? "*" : ""), i, bln, bln1);
            }
            if (o == null) {
                o = Bundle.CTL_CloneDestinationStep_branch_noBranch();
            }
            return super.getListCellRendererComponent((JList<?>)jlist, o, i, bln, bln1);
        }
    }
}

