/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.node;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.ui.node.DockerContainersChildFactory;
import org.netbeans.modules.docker.ui.node.DockerContainersNode;
import org.netbeans.modules.docker.ui.node.DockerImagesChildFactory;
import org.netbeans.modules.docker.ui.node.DockerImagesNode;
import org.netbeans.modules.docker.ui.node.NodeClosingFactory;
import org.netbeans.modules.docker.ui.node.StatefulDockerInstance;
import org.openide.nodes.Node;

public class DockerInstanceChildFactory
extends NodeClosingFactory<Boolean>
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(DockerInstanceChildFactory.class.getName());
    private final StatefulDockerInstance instance;
    private final Set<Node> current = new HashSet<Node>();

    public DockerInstanceChildFactory(StatefulDockerInstance instance) {
        this.instance = instance;
        instance.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DockerInstanceChildFactory.this.refresh(false);
            }
        });
        instance.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node[] createNodesForKey(Boolean key) {
        Node[] ret;
        if (key.booleanValue()) {
            DockerInstance dockerInstance = this.instance.getInstance();
            DockerImagesChildFactory factoryRepo = new DockerImagesChildFactory(dockerInstance);
            DockerContainersChildFactory factoryCont = new DockerContainersChildFactory(dockerInstance);
            ret = new Node[]{new DockerImagesNode(dockerInstance, factoryRepo), new DockerContainersNode(dockerInstance, factoryCont)};
        } else {
            ret = new Node[]{};
        }
        Set<Node> set = this.current;
        synchronized (set) {
            this.current.clear();
            Collections.addAll(this.current, ret);
        }
        return ret;
    }

    protected boolean createKeys(List<Boolean> toPopulate) {
        toPopulate.add(this.instance.isAvailable());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HashSet<Node> nodes;
        Set<Node> set = this.current;
        synchronized (set) {
            nodes = new HashSet<Node>(this.current);
        }
        for (Node n : nodes) {
            for (Closeable c : n.getLookup().lookupAll(Closeable.class)) {
                try {
                    c.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
        }
    }
}

