/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAWatchImpl;
import org.openide.util.NbBundle;

class JPDAObjectWatchImpl
extends AbstractObjectVariable
implements JPDAWatch,
ObjectVariable {
    private JPDADebuggerImpl debugger;
    private Watch watch;
    private String exceptionDescription;

    JPDAObjectWatchImpl(JPDADebuggerImpl debugger, Watch watch, Value v) {
        super(debugger, v, watch + (v instanceof ObjectReference ? "^" : ""));
        this.debugger = debugger;
        this.watch = watch;
    }

    JPDAObjectWatchImpl(JPDADebuggerImpl debugger, Watch watch, String exceptionDescription) {
        super(debugger, null, "" + watch);
        this.debugger = debugger;
        this.watch = watch;
        this.exceptionDescription = exceptionDescription;
    }

    public Watch getWatch() {
        return this.watch;
    }

    public String getExpression() {
        return this.watch.getExpression();
    }

    public void setExpression(String expression) {
        this.watch.setExpression(expression);
    }

    public void remove() {
        this.watch.remove();
    }

    public String getExceptionDescription() {
        return this.exceptionDescription;
    }

    @Override
    protected void setValue(Value value) throws InvalidExpressionException {
        EvaluationContext.VariableInfo vi = JPDAWatchImpl.getInfo(this.debugger, this.getInnerValue());
        if (vi != null) {
            try {
                vi.setValue(value);
            }
            catch (IllegalStateException isex) {
                if (isex.getCause() instanceof InvalidExpressionException) {
                    throw (InvalidExpressionException)isex.getCause();
                }
                throw new InvalidExpressionException((Throwable)isex);
            }
        } else {
            throw new InvalidExpressionException(NbBundle.getMessage(JPDAWatchImpl.class, (String)"MSG_CanNotSetValue", (Object)this.getExpression()));
        }
    }

    @Override
    protected void setInnerValue(Value v) {
        super.setInnerValue(v);
        this.exceptionDescription = null;
    }

    void setException(String exceptionDescription) {
        super.setInnerValue(null);
        this.exceptionDescription = exceptionDescription;
    }

    boolean isPrimitive() {
        return !(this.getInnerValue() instanceof ObjectReference);
    }

    @Override
    public JPDAObjectWatchImpl clone() {
        JPDAObjectWatchImpl clon = this.exceptionDescription == null ? new JPDAObjectWatchImpl(this.getDebugger(), this.watch, this.getJDIValue()) : new JPDAObjectWatchImpl(this.getDebugger(), this.watch, this.exceptionDescription);
        return clon;
    }
}

