/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.spi;

import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.jpda.visual.spi.ComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.spi.RemoteScreenshot;
import org.netbeans.modules.debugger.jpda.visual.ui.ScreenshotComponent;

public final class ScreenshotUIManager {
    public static final String ACTION_TAKE_SCREENSHOT = "takeScreenshot";
    private RemoteScreenshot rs;
    private ScreenshotComponent sc;

    ScreenshotUIManager(RemoteScreenshot rs) {
        this.rs = rs;
    }

    public static ScreenshotUIManager getActive() {
        ScreenshotComponent activeComponent = ScreenshotComponent.getActive();
        if (activeComponent != null) {
            return activeComponent.getManager();
        }
        return null;
    }

    public RemoteScreenshot getScreenshot() {
        return this.rs;
    }

    public void open() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenshotUIManager.this.open();
                }
            });
            return;
        }
        if (this.sc == null) {
            this.sc = new ScreenshotComponent(this.rs, this);
        }
        this.sc.open();
        this.sc.requestActive();
    }

    public void requestActive() {
        this.sc.requestActive();
    }

    public boolean close() {
        return this.sc.close();
    }

    public ComponentInfo getSelectedComponent() {
        if (this.sc == null) {
            return null;
        }
        return this.sc.getSelectedComponent();
    }

    public void markBreakpoint(ComponentInfo ci) {
        if (this.sc == null) {
            return;
        }
        this.sc.markBreakpoint(ci);
    }

    public void unmarkBreakpoint(ComponentInfo ci) {
        if (this.sc == null) {
            return;
        }
        this.sc.unmarkBreakpoint(ci);
    }
}

