/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projectsui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.jpda.projectsui.MainProjectManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class RunToCursorActionProvider
extends ActionsProviderSupport {
    private static final RequestProcessor RP = new RequestProcessor(RunToCursorActionProvider.class.getName());
    private final EditorContextDispatcher editorContext;
    private final Map<Project, LineBreakpoint> projectBreakpoints = new HashMap<Project, LineBreakpoint>();

    public RunToCursorActionProvider() {
        this.editorContext = EditorContextDispatcher.getDefault();
        Listener listener = new Listener();
        MainProjectManager.getDefault().addPropertyChangeListener((PropertyChangeListener)((Object)listener));
        this.editorContext.addPropertyChangeListener("text/x-java", WeakListeners.propertyChange((PropertyChangeListener)((Object)listener), (Object)this.editorContext));
        DebuggerManager.getDebuggerManager().addDebuggerListener("debuggerEngines", (DebuggerManagerListener)listener);
        this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, this.shouldBeEnabled());
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_TO_CURSOR);
    }

    public void doAction(Object action) {
        LineBreakpoint newBreakpoint = LineBreakpoint.create((String)this.editorContext.getCurrentURLAsString(), (int)this.editorContext.getCurrentLineNumber());
        this.createBreakpoint(newBreakpoint);
        this.invokeAction(newBreakpoint);
    }

    public void postAction(Object action, final Runnable actionPerformedNotifier) {
        final LineBreakpoint newBreakpoint = LineBreakpoint.create((String)this.editorContext.getCurrentURLAsString(), (int)this.editorContext.getCurrentLineNumber());
        this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, false);
        RP.post(new Runnable(){

            @Override
            public void run() {
                RunToCursorActionProvider.this.createBreakpoint(newBreakpoint);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            RunToCursorActionProvider.this.invokeAction(newBreakpoint);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException itex) {
                    ErrorManager.getDefault().notify((Throwable)itex);
                }
                finally {
                    actionPerformedNotifier.run();
                    RunToCursorActionProvider.this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, RunToCursorActionProvider.this.shouldBeEnabled());
                }
            }
        });
    }

    private void invokeAction(LineBreakpoint newBreakpoint) {
        this.debugProject(MainProjectManager.getDefault().getMainProject(), newBreakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugProject(final Project p, LineBreakpoint newBreakpoint) {
        Map<Project, LineBreakpoint> map = this.projectBreakpoints;
        synchronized (map) {
            this.projectBreakpoints.put(p, newBreakpoint);
        }
        ActionProgress progress = new ActionProgress(){

            protected void started() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finished(boolean success) {
                LineBreakpoint lb;
                Map<Project, LineBreakpoint> map = RunToCursorActionProvider.this.projectBreakpoints;
                synchronized (map) {
                    lb = RunToCursorActionProvider.this.projectBreakpoints.remove(p);
                }
                if (lb != null) {
                    RunToCursorActionProvider.this.removeBreakpoint(lb);
                }
                RunToCursorActionProvider.this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, RunToCursorActionProvider.this.shouldBeEnabled());
            }
        };
        ((ActionProvider)p.getLookup().lookup(ActionProvider.class)).invokeAction("debug", (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{progress}), p.getLookup()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldBeEnabled() {
        int i;
        if (this.editorContext.getCurrentLineNumber() < 0) {
            return false;
        }
        FileObject fo = this.editorContext.getCurrentFile();
        if (fo == null || !fo.hasExt("java")) {
            return false;
        }
        Project p = MainProjectManager.getDefault().getMainProject();
        if (p == null) {
            return false;
        }
        Map<Project, LineBreakpoint> map = this.projectBreakpoints;
        synchronized (map) {
            if (this.projectBreakpoints.containsKey(p)) {
                return false;
            }
        }
        ActionProvider actionProvider = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
        if (actionProvider == null) {
            return false;
        }
        String[] sa = actionProvider.getSupportedActions();
        int k = sa.length;
        for (i = 0; i < k && !"debug".equals(sa[i]); ++i) {
        }
        if (i == k) {
            return false;
        }
        return actionProvider.isActionEnabled("debug", p.getLookup());
    }

    private void createBreakpoint(LineBreakpoint breakpoint) {
        breakpoint.setHidden(true);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)breakpoint);
    }

    private void removeBreakpoint(LineBreakpoint breakpoint) {
        if (breakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)breakpoint);
        }
    }

    private class Listener
    extends DebuggerManagerAdapter {
        private final Map<JPDADebugger, Pair<LineBreakpoint, Project>> debuggerBreakpoints = new HashMap<JPDADebugger, Pair<LineBreakpoint, Project>>();
        private final Map<JPDADebugger, Integer> debuggerEngines = new HashMap<JPDADebugger, Integer>();

        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == "state") {
                int state = (Integer)e.getNewValue();
                if (state == 4 || state == 3) {
                    Pair<LineBreakpoint, Project> lbp;
                    JPDADebugger debugger = (JPDADebugger)e.getSource();
                    Map<JPDADebugger, Pair<LineBreakpoint, Project>> map = this.debuggerBreakpoints;
                    synchronized (map) {
                        lbp = this.debuggerBreakpoints.remove(debugger);
                    }
                    if (lbp != null) {
                        RunToCursorActionProvider.this.removeBreakpoint((LineBreakpoint)lbp.first());
                        map = RunToCursorActionProvider.this.projectBreakpoints;
                        synchronized (map) {
                            RunToCursorActionProvider.this.projectBreakpoints.put((Project)lbp.second(), null);
                        }
                    }
                }
                return;
            }
            RunToCursorActionProvider.this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, RunToCursorActionProvider.this.shouldBeEnabled());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void engineAdded(DebuggerEngine engine) {
            File baseDir;
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            Map<JPDADebugger, Integer> map = this.debuggerEngines;
            synchronized (map) {
                Integer num = this.debuggerEngines.get(debugger);
                if (num != null) {
                    this.debuggerEngines.put(debugger, num + 1);
                    return;
                }
                this.debuggerEngines.put(debugger, 1);
            }
            Map setupMap = (Map)engine.lookupFirst(null, Map.class);
            if (setupMap != null && (baseDir = (File)setupMap.get("baseDir")) != null) {
                Project prj = null;
                LineBreakpoint lb = null;
                Map<Project, LineBreakpoint> map2 = RunToCursorActionProvider.this.projectBreakpoints;
                synchronized (map2) {
                    for (Project p : RunToCursorActionProvider.this.projectBreakpoints.keySet()) {
                        if (!baseDir.equals(FileUtil.toFile((FileObject)p.getProjectDirectory()))) continue;
                        prj = p;
                        lb = RunToCursorActionProvider.this.projectBreakpoints.get(p);
                        break;
                    }
                }
                if (lb != null) {
                    map2 = this.debuggerBreakpoints;
                    synchronized (map2) {
                        this.debuggerBreakpoints.put(debugger, (Pair<LineBreakpoint, Project>)Pair.of(lb, (Object)prj));
                    }
                }
            }
            debugger.addPropertyChangeListener("state", (PropertyChangeListener)((Object)this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void engineRemoved(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            Map<JPDADebugger, Integer> map = this.debuggerEngines;
            synchronized (map) {
                Integer num = this.debuggerEngines.get(debugger);
                if (num != null) {
                    if (num > 1) {
                        this.debuggerEngines.put(debugger, num - 1);
                        return;
                    }
                    this.debuggerEngines.remove(debugger);
                }
            }
            debugger.removePropertyChangeListener("state", (PropertyChangeListener)((Object)this));
        }
    }
}

