/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jsui.frames.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeExpansionModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class DebuggingJSTreeExpansionModelFilter
implements TreeExpansionModelFilter,
PropertyChangeListener {
    private static final Reference<JPDAThread> NO_THREAD = new WeakReference<Object>(null);
    private final JPDADebugger debugger;
    private final DebuggingView.DVSupport dvSupport;
    private volatile Reference<JPDAThread> suspendedNashornThread = NO_THREAD;
    private final Set<Object> collapsedExplicitly = Collections.newSetFromMap(new WeakHashMap());
    private final Set<ModelListener> listeners = Collections.synchronizedSet(new HashSet());

    public DebuggingJSTreeExpansionModelFilter(ContextProvider context) {
        this.debugger = (JPDADebugger)context.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("currentCallStackFrame", WeakListeners.propertyChange((PropertyChangeListener)this, (String)"currentCallStackFrame", (Object)this.debugger));
        this.dvSupport = (DebuggingView.DVSupport)context.lookupFirst(null, DebuggingView.DVSupport.class);
        this.currentStackFrameChanged(this.debugger.getCurrentCallStackFrame());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpanded(TreeExpansionModel original, Object node) throws UnknownTypeException {
        if (node instanceof DebuggingView.DVThread) {
            DebuggingJSTreeExpansionModelFilter debuggingJSTreeExpansionModelFilter = this;
            synchronized (debuggingJSTreeExpansionModelFilter) {
                if (this.collapsedExplicitly.contains(node)) {
                    return false;
                }
            }
            try {
                JPDAThread thread = (JPDAThread)node.getClass().getMethod("getKey", new Class[0]).invoke(node, new Object[0]);
                if (thread == this.suspendedNashornThread.get()) {
                    return true;
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return original.isExpanded(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeExpanded(Object node) {
        if (node instanceof DebuggingView.DVThread) {
            DebuggingJSTreeExpansionModelFilter debuggingJSTreeExpansionModelFilter = this;
            synchronized (debuggingJSTreeExpansionModelFilter) {
                this.collapsedExplicitly.remove(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeCollapsed(Object node) {
        if (node instanceof DebuggingView.DVThread) {
            DebuggingJSTreeExpansionModelFilter debuggingJSTreeExpansionModelFilter = this;
            synchronized (debuggingJSTreeExpansionModelFilter) {
                this.collapsedExplicitly.add(node);
            }
        }
    }

    private void fireNodeExpanded(Object node) {
        ModelListener[] ls = this.listeners.toArray(new ModelListener[0]);
        if (ls.length > 0) {
            ModelEvent.NodeChanged event = new ModelEvent.NodeChanged((Object)this, node, 16);
            for (ModelListener ml : ls) {
                ml.modelChanged((ModelEvent)event);
            }
        }
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        CallStackFrame csf = (CallStackFrame)evt.getNewValue();
        this.currentStackFrameChanged(csf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void currentStackFrameChanged(CallStackFrame csf) {
        if (csf != null && (csf.getClassName().startsWith("jdk.nashorn.internal.scripts.Script$") || csf.getClassName().startsWith("org.openjdk.nashorn.internal.scripts.Script$"))) {
            JPDAThread thread = csf.getThread();
            this.suspendedNashornThread = new WeakReference<JPDAThread>(thread);
            try {
                boolean explicitCollaps;
                Object node = this.dvSupport.getClass().getMethod("get", JPDAThread.class).invoke((Object)this.dvSupport, thread);
                DebuggingJSTreeExpansionModelFilter debuggingJSTreeExpansionModelFilter = this;
                synchronized (debuggingJSTreeExpansionModelFilter) {
                    explicitCollaps = this.collapsedExplicitly.contains(node);
                }
                if (!explicitCollaps) {
                    this.fireNodeExpanded(node);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            this.suspendedNashornThread = NO_THREAD;
        }
    }
}

