/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.heapwalk.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.heapwalk.views.ClassesCountsView;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class InstancesView
extends TopComponent {
    private JPanel hfwPanel;
    private HeapFragmentWalker hfw;
    private HeapFragmentWalkerProvider provider;
    private DebuggerSessionListener listener;

    public InstancesView() {
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/debugger/jpda/resources/root.gif"));
        this.setLayout(new BorderLayout());
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
    }

    protected void componentShowing() {
        super.componentShowing();
        this.listener = new DebuggerSessionListener();
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)this.listener);
        this.showContent(this.listener.getState());
    }

    protected void componentClosed() {
        super.componentClosed();
        this.provider = null;
    }

    private void showContent(final int state) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showTheContent(state);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InstancesView.this.showTheContent(state);
                }
            });
        }
    }

    private void showTheContent(int state) {
        if (state == 3) {
            HeapFragmentWalker hfw;
            ClassesCountsView cc = (ClassesCountsView)WindowManager.getDefault().findTopComponent("classes");
            if (cc != null && (hfw = cc.getCurrentFragmentWalker()) != null) {
                this.setHeapFragmentWalker(hfw);
                this.provider = null;
            } else if (this.provider != null) {
                this.setHeapFragmentWalker(this.provider.getHeapFragmentWalker());
            } else if (this.hfw != null) {
                this.setHeapFragmentWalker(this.hfw);
            } else {
                this.close();
            }
        } else if (state == 2) {
            if (this.hfwPanel != null) {
                this.remove(this.hfwPanel);
            }
            this.hfw = null;
            this.hfwPanel = new SuspendInfoPanel();
            this.add(this.hfwPanel, "Center");
        } else {
            if (this.hfwPanel != null) {
                this.remove(this.hfwPanel);
                this.hfwPanel = null;
            }
            this.hfw = null;
            this.close();
        }
    }

    protected void componentHidden() {
        super.componentHidden();
        if (this.hfwPanel != null) {
            this.remove(this.hfwPanel);
            this.hfwPanel = null;
        }
        this.hfw = null;
        DebuggerManager.getDebuggerManager().removeDebuggerListener((DebuggerManagerListener)this.listener);
        this.listener = null;
    }

    public void setHeapFragmentWalkerProvider(HeapFragmentWalkerProvider hfwp) {
        this.provider = hfwp;
        this.setHeapFragmentWalker(hfwp.getHeapFragmentWalker());
    }

    private void setHeapFragmentWalker(HeapFragmentWalker hfw) {
        if (this.hfwPanel != null) {
            this.remove(this.hfwPanel);
            this.hfwPanel = null;
        }
        this.hfw = hfw;
        if (hfw == null) {
            return;
        }
        this.hfwPanel = hfw.getInstancesController().getPanel();
        this.add(this.hfwPanel, "Center");
        this.revalidate();
        this.repaint();
    }

    void assureSubViewsVisible() {
        this.hfw.getInstancesController().getInstancesListController().getPanel().setVisible(true);
        this.hfw.getInstancesController().getFieldsBrowserController().getPanel().setVisible(true);
        this.hfw.getInstancesController().getReferencesBrowserController().getPanel().setVisible(true);
    }

    public HeapFragmentWalker getCurrentFragmentWalker() {
        return this.hfw;
    }

    public String getName() {
        return NbBundle.getMessage(InstancesView.class, (String)"CTL_Instances_view");
    }

    public String getToolTipText() {
        return NbBundle.getMessage(InstancesView.class, (String)"CTL_Instances_tooltip");
    }

    public int getPersistenceType() {
        return 2;
    }

    private class DebuggerSessionListener
    extends DebuggerManagerAdapter {
        private Set<JPDADebugger> attachedTo = new WeakSet();
        private int lastState = -1;

        private DebuggerSessionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getState() {
            int state = this.getTheState();
            DebuggerSessionListener debuggerSessionListener = this;
            synchronized (debuggerSessionListener) {
                this.lastState = state;
            }
            return state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getTheState() {
            JPDADebugger d;
            int state = 4;
            DebuggerEngine de = DebuggerManager.getDebuggerManager().getCurrentEngine();
            if (de != null && (d = (JPDADebugger)de.lookupFirst(null, JPDADebugger.class)) != null) {
                state = this.getThreadsState(d);
                DebuggerSessionListener debuggerSessionListener = this;
                synchronized (debuggerSessionListener) {
                    if (!this.attachedTo.contains(d)) {
                        this.attachedTo.add(d);
                        d.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                    }
                }
            }
            return state;
        }

        private int getThreadsState(JPDADebugger d) {
            if (d.getState() != 3) {
                return d.getState();
            }
            try {
                Method allThreadsMethod = d.getClass().getMethod("getAllThreads", new Class[0]);
                List threads = (List)allThreadsMethod.invoke((Object)d, new Object[0]);
                for (JPDAThread t : threads) {
                    if (t.isSuspended()) continue;
                    return 2;
                }
                return 3;
            }
            catch (Exception ex) {
                return d.getState();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("currentEngine") || propertyName.equals("state")) {
                int state = this.getTheState();
                DebuggerSessionListener debuggerSessionListener = this;
                synchronized (debuggerSessionListener) {
                    if (state == this.lastState) {
                        return;
                    }
                    this.lastState = state;
                }
                InstancesView.this.showContent(state);
            }
        }
    }

    public static interface HeapFragmentWalkerProvider {
        public HeapFragmentWalker getHeapFragmentWalker();
    }

    private static class SuspendInfoPanel
    extends JPanel {
        public SuspendInfoPanel() {
            this.setLayout(new GridBagLayout());
            JTextArea infoText = new JTextArea(NbBundle.getMessage(InstancesView.class, (String)"MSG_NotSuspendedApp"));
            infoText.setEditable(false);
            infoText.setEnabled(false);
            infoText.setBackground(this.getBackground());
            infoText.setDisabledTextColor(new JLabel().getForeground());
            infoText.setLineWrap(true);
            infoText.setWrapStyleWord(true);
            infoText.setPreferredSize(new Dimension(infoText.getFontMetrics(infoText.getFont()).stringWidth(infoText.getText()), infoText.getPreferredSize().height));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)infoText, gridBagConstraints);
            infoText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstancesView.class, (String)"MSG_NotSuspendedApp"));
            JButton pauseButton = new JButton();
            pauseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.doStopCurrentDebugger();
                }
            });
            Mnemonics.setLocalizedText((AbstractButton)pauseButton, (String)NbBundle.getMessage(InstancesView.class, (String)"CTL_Pause"));
            pauseButton.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/actions/Pause.gif", (boolean)false));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)pauseButton, gridBagConstraints);
        }

        private void doStopCurrentDebugger() {
            DebuggerEngine de = DebuggerManager.getDebuggerManager().getCurrentEngine();
            if (de != null) {
                de.getActionsManager().postAction(ActionsManager.ACTION_PAUSE);
            }
        }
    }
}

