/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataAccessor;
import org.netbeans.modules.db.metadata.model.MetadataUtilities;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCCatalog;
import org.netbeans.modules.db.metadata.model.spi.MetadataImplementation;

public class JDBCMetadata
extends MetadataImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCMetadata.class.getName());
    private final Connection conn;
    private final String defaultSchemaName;
    private final DatabaseMetaData dmd;
    protected Catalog defaultCatalog;
    protected Map<String, Catalog> catalogs;

    public JDBCMetadata(Connection conn, String defaultSchemaName) {
        LOGGER.log(Level.FINE, "Creating metadata for default schema ''{0}''", defaultSchemaName);
        this.conn = conn;
        this.defaultSchemaName = defaultSchemaName;
        try {
            this.dmd = conn.getMetaData();
        }
        catch (SQLException e) {
            throw new MetadataException(e);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            try {
                LOGGER.log(Level.FINE, "Retrieved DMD for product ''{0}'' version ''{1}'', driver ''{2}'' version ''{3}''", new Object[]{this.dmd.getDatabaseProductName(), this.dmd.getDatabaseProductVersion(), this.dmd.getDriverName(), this.dmd.getDriverVersion()});
            }
            catch (SQLException e) {
                LOGGER.log(Level.FINE, "Exception while logging metadata information", e);
            }
        }
    }

    @Override
    public final Catalog getDefaultCatalog() {
        this.initCatalogs();
        return this.defaultCatalog;
    }

    @Override
    public final Collection<Catalog> getCatalogs() {
        return this.initCatalogs().values();
    }

    @Override
    public final Catalog getCatalog(String name) {
        Catalog catalog = MetadataUtilities.find(name, this.initCatalogs());
        if (catalog == null && name == null) {
            return this.getDefaultCatalog();
        }
        return catalog;
    }

    @Override
    public Schema getDefaultSchema() {
        Catalog catalog = this.getDefaultCatalog();
        if (catalog != null) {
            return ((JDBCCatalog)MetadataAccessor.getDefault().getCatalogImpl(catalog)).getDefaultSchema();
        }
        return null;
    }

    @Override
    public final void refresh() {
        LOGGER.fine("Refreshing metadata");
        this.defaultCatalog = null;
        this.catalogs = null;
    }

    public String toString() {
        return "JDBCMetadata";
    }

    protected JDBCCatalog createJDBCCatalog(String name, boolean _default, String defaultSchemaName) {
        return new JDBCCatalog(this, name, _default, defaultSchemaName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createCatalogs() {
        LinkedHashMap<String, Catalog> newCatalogs;
        block10: {
            newCatalogs = new LinkedHashMap<String, Catalog>();
            try {
                if (this.driverReportsBogusCatalogNames()) break block10;
                String defaultCatalogName = this.conn.getCatalog();
                ResultSet rs = this.dmd.getCatalogs();
                try {
                    while (rs.next()) {
                        String catalogName = MetadataUtilities.trimmed(rs.getString("TABLE_CAT"));
                        LOGGER.log(Level.FINE, "Read catalog ''{0}''", catalogName);
                        if (MetadataUtilities.equals(catalogName, defaultCatalogName)) {
                            this.defaultCatalog = this.createJDBCCatalog(catalogName, true, this.defaultSchemaName).getCatalog();
                            newCatalogs.put(this.defaultCatalog.getName(), this.defaultCatalog);
                            LOGGER.log(Level.FINE, "Created default catalog {0}", this.defaultCatalog);
                            continue;
                        }
                        Catalog catalog = this.createJDBCCatalog(catalogName, false, null).getCatalog();
                        newCatalogs.put(catalogName, catalog);
                        LOGGER.log(Level.FINE, "Created catalog {0}", catalog);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.INFO, "Could not load catalogs list from database (getCatalogs failed).");
            }
        }
        if (this.defaultCatalog == null) {
            this.defaultCatalog = this.createJDBCCatalog(null, true, this.defaultSchemaName).getCatalog();
            if (newCatalogs.isEmpty()) {
                newCatalogs.put(null, this.defaultCatalog);
            }
            LOGGER.log(Level.FINE, "Created fallback default catalog {0}", this.defaultCatalog);
        }
        this.catalogs = Collections.unmodifiableMap(newCatalogs);
    }

    private Map<String, Catalog> initCatalogs() {
        if (this.catalogs != null) {
            return this.catalogs;
        }
        LOGGER.fine("Initializing catalogs");
        this.createCatalogs();
        return this.catalogs;
    }

    public final Connection getConnection() {
        return this.conn;
    }

    public final DatabaseMetaData getDmd() {
        return this.dmd;
    }

    private boolean driverReportsBogusCatalogNames() throws SQLException {
        return "PointBase JDBC Driver".equals(this.dmd.getDriverName());
    }
}

