/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc.mysql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.Procedure;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCCatalog;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCProcedure;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCSchema;
import org.netbeans.modules.db.metadata.model.jdbc.mysql.MySQLProcedure;

public class MySQLSchema
extends JDBCSchema {
    private static final Logger LOGGER = Logger.getLogger(MySQLSchema.class.getName());

    public MySQLSchema(JDBCCatalog jdbcCatalog, String name, boolean _default, boolean synthetic) {
        super(jdbcCatalog, name, _default, synthetic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createProcedures() {
        Procedure procedure;
        String procedureName;
        ResultSet rs;
        Statement stmt;
        DatabaseMetaData dmd;
        LOGGER.log(Level.FINE, "Initializing MySQL procedures in {0}", this);
        LinkedHashMap<String, Procedure> newProcedures = new LinkedHashMap<String, Procedure>();
        try {
            dmd = this.jdbcCatalog.getJDBCMetadata().getDmd();
            stmt = dmd.getConnection().createStatement();
            rs = stmt.executeQuery("SELECT NAME, TYPE FROM mysql.proc WHERE DB='" + this.jdbcCatalog.getName() + "' AND ( TYPE = 'PROCEDURE' OR TYPE = 'FUNCTION' )");
            try {
                while (rs.next()) {
                    procedureName = rs.getString("NAME");
                    procedure = this.createJDBCProcedure(procedureName).getProcedure();
                    newProcedures.put(procedureName, procedure);
                    LOGGER.log(Level.FINE, "Created MySQL procedure: {0}, type: {1}", new Object[]{procedure, rs.getString("TYPE")});
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new MetadataException(e);
        }
        try {
            dmd = this.jdbcCatalog.getJDBCMetadata().getDmd();
            stmt = dmd.getConnection().createStatement();
            rs = stmt.executeQuery("SELECT TRIGGER_NAME FROM information_schema.triggers WHERE TRIGGER_SCHEMA='" + this.jdbcCatalog.getName() + "'");
            try {
                while (rs.next()) {
                    procedureName = rs.getString("TRIGGER_NAME");
                    procedure = this.createJDBCProcedure(procedureName).getProcedure();
                    newProcedures.put(procedureName, procedure);
                    LOGGER.log(Level.FINE, "Created MySQL trigger: {0}", new Object[]{procedure});
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new MetadataException(e);
        }
        this.procedures = Collections.unmodifiableMap(newProcedures);
    }

    @Override
    protected JDBCProcedure createJDBCProcedure(String procedureName) {
        return new MySQLProcedure(this, procedureName);
    }

    @Override
    public String toString() {
        return "MySQLSchema[jdbcCatalog=" + this.jdbcCatalog.getName() + ", name=" + this.getName() + "]";
    }
}

