/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table.celleditor;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.table.ResultSetTableCellEditor;
import org.netbeans.modules.db.dataview.table.ResultSetTableModel;
import org.netbeans.modules.db.dataview.util.DBReadWriteHelper;
import org.openide.util.Exceptions;

public class NumberFieldEditor
extends ResultSetTableCellEditor {
    private final JTextField textField;
    private DBColumn dbColumn;
    private Object oldValue;
    private final InputVerifier verifier = new InputVerifier(){

        @Override
        public boolean verify(JComponent input) {
            if (NumberFieldEditor.this.dbColumn != null && input instanceof JTextComponent) {
                String inputText = ((JTextComponent)input).getText();
                try {
                    DBReadWriteHelper.validate(inputText, NumberFieldEditor.this.dbColumn);
                }
                catch (DBException ex) {
                    return false;
                }
                return true;
            }
            return true;
        }
    };

    public NumberFieldEditor(JTextField textField) {
        super(textField);
        this.textField = textField;
        ((JTextField)this.getComponent()).setHorizontalAlignment(4);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.oldValue = value;
        int modelColumn = table.convertColumnIndexToModel(column);
        TableModel tm = table.getModel();
        this.dbColumn = null;
        if (tm instanceof ResultSetTableModel) {
            this.textField.setInputVerifier(this.verifier);
            this.dbColumn = ((ResultSetTableModel)tm).getColumn(modelColumn);
        } else {
            this.textField.setInputVerifier(null);
        }
        Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        if (suppressEditorBorder && c instanceof JComponent) {
            ((JComponent)c).setBorder(BorderFactory.createEmptyBorder());
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Object getCellEditorValue() {
        try {
            Object superVal = super.getCellEditorValue();
            if (this.dbColumn != null) {
                try {
                    Object object = DBReadWriteHelper.validate(superVal, this.dbColumn);
                    return object;
                }
                catch (DBException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    Object object = this.oldValue;
                    this.oldValue = null;
                    return object;
                }
            }
            Object object = superVal;
            return object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.oldValue = null;
        }
    }

    @Override
    public boolean stopCellEditing() {
        try {
            Object value = super.getCellEditorValue();
            DBReadWriteHelper.validate(value, this.dbColumn);
            return super.stopCellEditing();
        }
        catch (DBException ex) {
            return false;
        }
    }

    @Override
    public void cancelCellEditing() {
        this.oldValue = null;
        super.cancelCellEditing();
    }
}

