/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output.dataexport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.dhatim.fastexcel.Workbook;
import org.dhatim.fastexcel.Worksheet;
import org.netbeans.modules.db.dataview.output.dataexport.Bundle;
import org.netbeans.modules.db.dataview.output.dataexport.DataExporter;
import org.openide.util.Exceptions;

public class XLSXDataExporter
extends DataExporter {
    private final String DATE_FORMAT = "yyyy-mm-dd";
    private final String TIME_FORMAT = "hh:mm:ss";
    private final String TIMESTAMP_FORMAT = "yyyy-mm-dd hh:mm:ss.000";
    private final int MAX_XLSX_CELL_LENGTH = Short.MAX_VALUE;
    private final String EXCESS_LENGTH_SUFFIX = " [...]";
    private final String APP_VERSION = "Apache NetBeans IDE " + System.getProperty("netbeans.buildnumber");

    public XLSXDataExporter() {
        super(new String[]{"xlsx"}, Bundle.XLSX_DESCRIPTION());
    }

    @Override
    public void exportData(String[] headers, Object[][] contents, File file) {
        int columns = headers.length;
        int rows = contents.length;
        try (FileOutputStream os = new FileOutputStream(file);){
            int row = 0;
            Workbook wb = new Workbook((OutputStream)os, this.APP_VERSION, null);
            Worksheet ws = wb.newWorksheet("Sheet1");
            for (int j = 0; j < columns; ++j) {
                ws.value(row, j, (Object)headers[j]);
            }
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < columns; ++j) {
                    Object value = contents[i][j];
                    if (value instanceof Number) {
                        ws.value(i + 1, j, (Object)((Number)value).doubleValue());
                        continue;
                    }
                    if (value instanceof Time) {
                        ws.value(i + 1, j, (Object)((Time)value));
                        ws.style(i + 1, j).format("hh:mm:ss").set();
                        continue;
                    }
                    if (value instanceof Timestamp) {
                        ws.value(i + 1, j, (Object)((Timestamp)value));
                        ws.style(i + 1, j).format("yyyy-mm-dd hh:mm:ss.000").set();
                        continue;
                    }
                    if (value instanceof Date) {
                        ws.value(i + 1, j, (Object)((Date)value));
                        ws.style(i + 1, j).format("yyyy-mm-dd").set();
                        continue;
                    }
                    if (value instanceof Boolean) {
                        ws.value(i + 1, j, (Object)((Boolean)value));
                        continue;
                    }
                    if (value == null) continue;
                    String stringValue = value.toString().length() > Short.MAX_VALUE ? value.toString().subSequence(0, Short.MAX_VALUE - " [...]".length()) + " [...]" : value.toString();
                    ws.value(i + 1, j, (Object)stringValue);
                }
            }
            wb.finish();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

