/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.amazon.ui.serverplugin;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.cloud.amazon.AmazonInstance;
import org.netbeans.modules.cloud.amazon.AmazonInstanceManager;
import org.netbeans.modules.cloud.amazon.serverplugin.AmazonJ2EEInstance;
import org.netbeans.modules.cloud.amazon.ui.serverplugin.AmazonJ2EEServerWizardPanel;
import org.openide.util.NbBundle;

public class AmazonJ2EEServerWizardComponent
extends JPanel
implements DocumentListener {
    private AmazonJ2EEServerWizardPanel wizardPanel;
    private String suggestedName;
    private Map<String, List<String>> templates;
    private static final String SUFFIX = "-dev-env";
    private final String CONTAINER_FILER = "Tomcat";
    private JComboBox accountComboBox;
    private JLabel accountLavel;
    private JComboBox appNameComboBox;
    private JLabel appNameLabel;
    private JComboBox containerComboBox;
    private JLabel containerLabel;
    private JLabel endNameLabel;
    private JLabel envFullURLLabel;
    private JTextField envNameTextField;
    private JLabel envURLLabel;
    private JTextField envURLTextField;
    private JComboBox templateComboBox;
    private JLabel templateLabel;

    public AmazonJ2EEServerWizardComponent(AmazonJ2EEServerWizardPanel wizardPanel, String suggestedName, AmazonJ2EEInstance aji) {
        this.wizardPanel = wizardPanel;
        this.suggestedName = suggestedName;
        this.initComponents();
        this.setName(NbBundle.getMessage(AmazonJ2EEServerWizardComponent.class, (String)"AmazonJ2EEServerWizardComponent.name"));
        if (suggestedName != null) {
            if (suggestedName.length() > 23 - SUFFIX.length()) {
                this.envNameTextField.setText(suggestedName.substring(0, 23 - SUFFIX.length()) + SUFFIX);
            } else {
                this.envNameTextField.setText(suggestedName + SUFFIX);
            }
            this.envURLTextField.setText(suggestedName + SUFFIX);
            this.envFullURLLabel.setText("<html>" + this.envURLTextField.getText() + ".elasticbeanstalk.com");
        }
        if (aji != null) {
            this.accountComboBox.setEditable(false);
            this.accountComboBox.getModel().setSelectedItem(aji.getAmazonInstance().getName());
            ((JTextField)this.appNameComboBox.getEditor().getEditorComponent()).setText(aji.getApplicationName());
            this.appNameComboBox.setEditable(false);
            this.envNameTextField.setText(aji.getEnvironmentName());
            this.envNameTextField.setEditable(false);
            this.templateComboBox.setVisible(false);
            this.templateLabel.setVisible(false);
            this.envURLTextField.setVisible(false);
            this.envURLLabel.setVisible(false);
            this.envFullURLLabel.setVisible(false);
            this.containerComboBox.getModel().setSelectedItem(aji.getContainerType());
            this.containerComboBox.setEditable(false);
        }
    }

    void init() {
        this.initAccounts();
        this.initApplications();
        this.enableApplicationComponent(this.hasAccount());
        this.hookEnvironmentURL();
        if (this.hasAccount()) {
            this.initContainersModel();
            this.accountComboBox.setSelectedIndex(0);
            this.reloadApplications();
        }
    }

    private void enableApplicationComponent(boolean enable) {
        this.appNameComboBox.setEnabled(enable);
        this.appNameLabel.setEnabled(enable);
        this.containerComboBox.setEnabled(enable);
        this.containerLabel.setEnabled(enable);
        this.endNameLabel.setEnabled(enable);
        this.envURLLabel.setEnabled(enable);
        this.envFullURLLabel.setEnabled(enable);
        this.envNameTextField.setEnabled(enable);
        this.envURLTextField.setEnabled(enable);
    }

    public String getApplicationName() {
        return ((JTextField)this.appNameComboBox.getEditor().getEditorComponent()).getText();
    }

    public String getTemplateName() {
        if (!this.templateComboBox.isEnabled()) {
            return null;
        }
        String templ = (String)this.templateComboBox.getModel().getSelectedItem();
        if (templ != null && templ.length() > 0) {
            return templ;
        }
        return null;
    }

    public String getEnvironmentName() {
        return this.envNameTextField.getText();
    }

    public String getURL() {
        return this.envURLTextField.getText();
    }

    public AmazonInstance getAmazonInstance() {
        return (AmazonInstance)this.accountComboBox.getSelectedItem();
    }

    public String getContainerType() {
        return (String)this.containerComboBox.getSelectedItem();
    }

    public boolean hasAccount() {
        return this.accountComboBox.getModel().getSize() > 0;
    }

    private void initComponents() {
        this.accountLavel = new JLabel();
        this.accountComboBox = new JComboBox();
        this.appNameLabel = new JLabel();
        this.appNameComboBox = new JComboBox();
        this.endNameLabel = new JLabel();
        this.envNameTextField = new JTextField();
        this.envURLLabel = new JLabel();
        this.envURLTextField = new JTextField();
        this.envFullURLLabel = new JLabel();
        this.containerLabel = new JLabel();
        this.containerComboBox = new JComboBox();
        this.templateLabel = new JLabel();
        this.templateComboBox = new JComboBox();
        this.accountLavel.setText(NbBundle.getMessage(AmazonJ2EEServerWizardComponent.class, (String)"AmazonJ2EEServerWizardComponent.accountLavel.text"));
        this.appNameLabel.setText(NbBundle.getMessage(AmazonJ2EEServerWizardComponent.class, (String)"AmazonJ2EEServerWizardComponent.appNameLabel.text"));
        this.appNameComboBox.setEditable(true);
        this.endNameLabel.setText(NbBundle.getMessage(AmazonJ2EEServerWizardComponent.class, (String)"AmazonJ2EEServerWizardComponent.endNameLabel.text"));
        this.envNameTextField.setText(NbBundle.getMessage(AmazonJ2EEServerWizardComponent.class, (String)"AmazonJ2EEServerWizardComponent.envNameTextField.text"));
        this.envURLLabel.setText(NbBundle.getMessage(AmazonJ2EEServerWizardComponent.class, (String)"AmazonJ2EEServerWizardComponent.envURLLabel.text"));
        this.envFullURLLabel.setFont(this.envFullURLLabel.getFont().deriveFont((float)this.envFullURLLabel.getFont().getSize() - 2.0f));
        this.envFullURLLabel.setText(NbBundle.getMessage(AmazonJ2EEServerWizardComponent.class, (String)"AmazonJ2EEServerWizardComponent.envFullURLLabel.text"));
        this.containerLabel.setText(NbBundle.getMessage(AmazonJ2EEServerWizardComponent.class, (String)"AmazonJ2EEServerWizardComponent.containerLabel.text"));
        this.templateLabel.setText(NbBundle.getMessage(AmazonJ2EEServerWizardComponent.class, (String)"AmazonJ2EEServerWizardComponent.templateLabel.text"));
        this.templateLabel.setEnabled(false);
        this.templateComboBox.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.accountLavel).addComponent(this.appNameLabel).addComponent(this.templateLabel).addComponent(this.endNameLabel).addComponent(this.envURLLabel).addComponent(this.containerLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.envFullURLLabel, -1, 251, Short.MAX_VALUE).addComponent(this.containerComboBox, GroupLayout.Alignment.LEADING, 0, 251, Short.MAX_VALUE).addComponent(this.envURLTextField, GroupLayout.Alignment.LEADING, -1, 251, Short.MAX_VALUE).addComponent(this.envNameTextField, GroupLayout.Alignment.LEADING, -1, 251, Short.MAX_VALUE).addComponent(this.templateComboBox, GroupLayout.Alignment.LEADING, 0, 251, Short.MAX_VALUE).addComponent(this.accountComboBox, GroupLayout.Alignment.LEADING, 0, 251, Short.MAX_VALUE).addComponent(this.appNameComboBox, GroupLayout.Alignment.LEADING, 0, 251, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.accountLavel).addComponent(this.accountComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.appNameLabel).addComponent(this.appNameComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.templateLabel).addComponent(this.templateComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.endNameLabel).addComponent(this.envNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.envURLLabel).addComponent(this.envURLTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.envFullURLLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.containerLabel).addComponent(this.containerComboBox, -2, -1, -2))));
    }

    private void initAccounts() {
        List<AmazonInstance> l = AmazonInstanceManager.getDefault().getInstances();
        DefaultComboBoxModel<AmazonInstance> model = new DefaultComboBoxModel<AmazonInstance>(l.toArray(new AmazonInstance[l.size()]));
        this.accountComboBox.setModel(model);
        this.accountComboBox.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String s = value instanceof AmazonInstance ? ((AmazonInstance)value).getName() : (String)value;
                return new JLabel(s);
            }
        });
        this.accountComboBox.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                AmazonJ2EEServerWizardComponent.this.reloadApplications();
            }
        });
    }

    private void initApplications() {
        JTextField tf = (JTextField)this.appNameComboBox.getEditor().getEditorComponent();
        tf.getDocument().addDocumentListener(this);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(new String[]{this.suggestedName == null ? "" : this.suggestedName});
        this.appNameComboBox.setModel(model);
        this.appNameComboBox.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof String) {
                    return new JLabel((String)value);
                }
                assert (false);
                return null;
            }
        });
        ((JTextField)this.appNameComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AmazonJ2EEServerWizardComponent.this.reloadTemplates();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AmazonJ2EEServerWizardComponent.this.reloadTemplates();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AmazonJ2EEServerWizardComponent.this.reloadTemplates();
            }
        });
    }

    private void reloadTemplates() {
        List<String> templateNames;
        String appName = this.getApplicationName();
        if (appName != null && (templateNames = this.templates.get(appName)) != null && templateNames.size() > 0) {
            templateNames = new ArrayList<String>(templateNames);
            templateNames.add(0, "");
            this.templateComboBox.setModel(new DefaultComboBoxModel<String>(templateNames.toArray(new String[templateNames.size()])));
            this.templateComboBox.setSelectedIndex(0);
            this.templateComboBox.setEnabled(true);
            this.templateLabel.setEnabled(true);
            return;
        }
        this.templateComboBox.setModel(new DefaultComboBoxModel());
        this.templateComboBox.setEnabled(false);
        this.templateLabel.setEnabled(false);
    }

    private void reloadApplications() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(new String[]{this.suggestedName == null ? "" : this.suggestedName, NbBundle.getMessage(AmazonJ2EEServerWizardComponent.class, (String)"AmazonJ2EEServerWizardComponent.loadingApplications")});
        this.appNameComboBox.setModel(model);
        final AmazonInstance ai = (AmazonInstance)this.accountComboBox.getSelectedItem();
        AmazonInstance.runAsynchronously(new Callable<Void>(){

            @Override
            public Void call() {
                AmazonJ2EEServerWizardComponent.this.templates = ai.readApplicationTemplates();
                final ArrayList apps = new ArrayList(AmazonJ2EEServerWizardComponent.this.templates.keySet());
                apps.add(0, AmazonJ2EEServerWizardComponent.this.suggestedName == null ? "" : AmazonJ2EEServerWizardComponent.this.suggestedName);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AmazonJ2EEServerWizardComponent.this.appNameComboBox.setModel(new DefaultComboBoxModel<String>(apps.toArray(new String[apps.size()])));
                        AmazonJ2EEServerWizardComponent.this.appNameComboBox.setSelectedIndex(0);
                    }
                });
                return null;
            }
        }, ai);
    }

    private void hookEnvironmentURL() {
        this.envNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AmazonJ2EEServerWizardComponent.this.suggestNewURL();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AmazonJ2EEServerWizardComponent.this.suggestNewURL();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AmazonJ2EEServerWizardComponent.this.suggestNewURL();
            }
        });
        this.envURLTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AmazonJ2EEServerWizardComponent.this.updateFullURL();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AmazonJ2EEServerWizardComponent.this.updateFullURL();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AmazonJ2EEServerWizardComponent.this.updateFullURL();
            }
        });
    }

    private void suggestNewURL() {
        this.envURLTextField.setText(this.envNameTextField.getText());
        if (this.wizardPanel != null) {
            this.wizardPanel.fireChange();
        }
    }

    private void updateFullURL() {
        this.envFullURLLabel.setText(this.envURLTextField.getText().length() > 0 ? "<html>" + this.envURLTextField.getText() + ".elasticbeanstalk.com" : " ");
        if (this.wizardPanel != null) {
            this.wizardPanel.fireChange();
        }
    }

    private void initContainersModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(AmazonJ2EEServerWizardComponent.class, (String)"AmazonJ2EEServerWizardComponent.loadingApplications")});
        final AmazonInstance ai = (AmazonInstance)this.accountComboBox.getSelectedItem();
        this.containerComboBox.setModel(model);
        AmazonInstance.runAsynchronously(new Callable<Void>(){

            @Override
            public Void call() {
                final List<String> containers = ai.readContainerTypes();
                containers.removeIf(c -> !c.contains("Tomcat"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AmazonJ2EEServerWizardComponent.this.containerComboBox.setModel(new DefaultComboBoxModel<String>(containers.toArray(new String[containers.size()])));
                    }
                });
                return null;
            }
        }, ai);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateState();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateState();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateState();
    }

    private void updateState() {
        if (this.wizardPanel != null) {
            this.wizardPanel.fireChange();
        }
    }

    public void attachSingleListener(ChangeListener changeListener) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

