/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.commands;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;

public class GetConfigurationCommand
extends BugtrackingCommand {
    private final boolean forceRefresh;
    private BugzillaRepository repository;
    private RepositoryConfiguration conf;

    public GetConfigurationCommand(boolean forceRefresh, BugzillaRepository repository) {
        this.forceRefresh = forceRefresh;
        this.repository = repository;
    }

    public void execute() throws CoreException, IOException, MalformedURLException {
        boolean refresh = this.forceRefresh;
        String b = System.getProperty("org.netbeans.modules.bugzilla.persistentRepositoryConfiguration", "false");
        if ("true".equals(b)) {
            refresh = true;
        }
        Bugzilla.LOG.log(Level.FINE, " Refresh bugzilla configuration [{0}, forceRefresh={1}]", new Object[]{this.repository.getUrl(), refresh});
        this.conf = Bugzilla.getInstance().getRepositoryConfiguration(this.repository, refresh);
    }

    public RepositoryConfiguration getConf() {
        return this.hasFailed() ? null : this.conf;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GetConfigurationCommand [repository=");
        sb.append(this.repository.getUrl());
        sb.append("]");
        return sb.toString();
    }
}

