/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.Collection;
import javax.lang.model.element.Element;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.beans.beaninfo.BIDataLoader;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.spi.DiffElement;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandler;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandlerFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;

public final class BIGuardedBlockHandlerFactory
implements GuardedBlockHandlerFactory {
    public GuardedBlockHandler createInstance(AbstractRefactoring refactoring) {
        return new BIGuardedBlockHandler();
    }

    private static final class BIGuardedBlockHandler
    implements GuardedBlockHandler {
        private BIGuardedBlockHandler() {
        }

        public Problem handleChange(RefactoringElementImplementation proposedChange, Collection<RefactoringElementImplementation> replacements, Collection<Transaction> transaction) {
            ModificationResult.Difference diff;
            DiffElement diffel;
            FileObject fo;
            if (proposedChange instanceof DiffElement && BIDataLoader.isBeanInfo(fo = (diffel = (DiffElement)proposedChange).getParentFile()) && this.checkChange(fo, diffel.getPosition()) && (diff = (ModificationResult.Difference)diffel.getLookup().lookup(ModificationResult.Difference.class)) != null) {
                diffel.setEnabled(true);
                diff.setCommitToGuards(true);
                replacements.add(proposedChange);
            }
            return null;
        }

        private boolean checkChange(FileObject bifile, final PositionBounds span) {
            final boolean[] result = new boolean[]{false};
            JavaSource js = JavaSource.forFileObject((FileObject)bifile);
            if (js != null) {
                try {
                    js.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController javac) throws Exception {
                            javac.toPhase(JavaSource.Phase.RESOLVED);
                            result[0] = BIGuardedBlockHandler.this.checkChange(javac, span);
                        }
                    }, true);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return result[0];
        }

        public void run(CompilationController javac) throws Exception {
        }

        private boolean checkChange(CompilationController javac, PositionBounds span) throws IOException, BadLocationException {
            int begin = span.getBegin().getOffset();
            Trees trees = javac.getTrees();
            TreePath path = javac.getTreeUtilities().pathFor(begin + 1);
            if (path == null) {
                return false;
            }
            Element element = trees.getElement(path);
            if (element == null) {
                return false;
            }
            TreePath decl = trees.getPath(element);
            if (decl != null) {
                SourcePositions sourcePositions = trees.getSourcePositions();
                long declBegin = sourcePositions.getStartPosition(decl.getCompilationUnit(), decl.getLeaf());
                FileObject fo = SourceUtils.getFile((Element)element, (ClasspathInfo)javac.getClasspathInfo());
                Document doc = javac.getDocument();
                GuardedSectionManager guards = GuardedSectionManager.getInstance((StyledDocument)((StyledDocument)doc));
                return fo != javac.getFileObject() || guards != null && !this.isGuarded(guards, doc.createPosition((int)declBegin));
            }
            return true;
        }

        private boolean isGuarded(GuardedSectionManager guards, Position pos) {
            for (GuardedSection guard : guards.getGuardedSections()) {
                if (!guard.contains(pos, true)) continue;
                return true;
            }
            return false;
        }
    }
}

