/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.awt.AWTPermission;
import java.awt.datatransfer.Clipboard;
import java.io.FileDescriptor;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.LoggingPermission;
import org.netbeans.ExitSecurityException;
import org.openide.util.Lookup;

public class TopSecurityManager
extends SecurityManager {
    private static final boolean check = !Boolean.getBoolean("netbeans.security.nocheck");
    private static final Logger LOG = Logger.getLogger(TopSecurityManager.class.getName());
    private Permission allPermission;
    private static final Class<?> classLoaderClass = ClassLoader.class;
    private static final Class URLClass = URL.class;
    private static final Class runtimePermissionClass = RuntimePermission.class;
    private static final Class accessControllerClass = AccessController.class;
    private static final Class awtPermissionClass = AWTPermission.class;
    private static SecurityManager fsSecManager;
    private static final List<SecurityManager> delegates;
    static boolean officialExit;
    private final Set<String> warnedClassesNDE = new HashSet<String>(25);
    private static final Set<String> warnedClassesNH;
    private static Field urlField;
    private static ThreadLocal<Object> CLIPBOARD_FORBIDDEN;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(SecurityManager sm) throws SecurityException {
        List<SecurityManager> list = delegates;
        synchronized (list) {
            if (delegates.contains(sm)) {
                throw new SecurityException();
            }
            delegates.add(sm);
            if (fsSecManager == null) {
                for (Lookup.Item item : Lookup.getDefault().lookupResult(SecurityManager.class).allItems()) {
                    if (item == null || !"org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager".equals(item.getId())) continue;
                    fsSecManager = (SecurityManager)item.getInstance();
                    break;
                }
                assert (fsSecManager != null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(SecurityManager sm) throws SecurityException {
        List<SecurityManager> list = delegates;
        synchronized (list) {
            if (!delegates.contains(sm)) {
                throw new SecurityException();
            }
            delegates.remove(sm);
        }
    }

    public TopSecurityManager() {
        this.allPermission = new AllPermission();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkExit(int status) throws SecurityException {
        if (!check) {
            return;
        }
        List<SecurityManager> list = delegates;
        synchronized (list) {
            Iterator<SecurityManager> it = delegates.iterator();
            while (it.hasNext()) {
                it.next().checkExit(status);
            }
        }
        PrivilegedCheck.checkExit(status, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecurityManager getSecurityManager() {
        if (fsSecManager == null) {
            List<SecurityManager> list = delegates;
            synchronized (list) {
                return fsSecManager;
            }
        }
        return fsSecManager;
    }

    private void notifyDelete(String file) {
        SecurityManager s = this.getSecurityManager();
        if (s != null) {
            s.checkDelete(file);
        }
    }

    private void notifyRead(String file) {
        SecurityManager s = this.getSecurityManager();
        if (s != null) {
            s.checkRead(file);
        }
    }

    private void notifyWrite(String file) {
        SecurityManager s = this.getSecurityManager();
        if (s != null) {
            s.checkWrite(file);
        }
    }

    static Class[] getStack() {
        SecurityManager s = System.getSecurityManager();
        TopSecurityManager t = s instanceof TopSecurityManager ? (TopSecurityManager)s : new TopSecurityManager();
        return t.getClassContext();
    }

    public static void exit(int status) {
        if (officialExit) {
            return;
        }
        officialExit = true;
        System.exit(status);
    }

    final void checkExitImpl(int status, AccessControlContext acc) throws SecurityException {
        if (!officialExit) {
            throw new ExitSecurityException("Illegal attempt to exit early");
        }
        super.checkExit(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTopLevelWindow(Object window) {
        List<SecurityManager> list = delegates;
        synchronized (list) {
            for (SecurityManager sm : delegates) {
                sm.checkTopLevelWindow(window);
            }
        }
        return super.checkTopLevelWindow(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void checkPropertyAccess(String x) {
        Set<String> set;
        String n;
        if ("netbeans.debug.exceptions".equals(x)) {
            for (Class<?> c : this.getClassContext()) {
                if (c == TopSecurityManager.class || c == System.class || c == Boolean.class) continue;
                n = c.getName();
                set = this.warnedClassesNDE;
                synchronized (set) {
                    if (this.warnedClassesNDE.add(n)) {
                        LOG.log(Level.WARNING, "use of system property netbeans.debug.exceptions has been obsoleted in favor of java.util.logging.Logger at {0}", TopSecurityManager.findCallStackLine(n));
                    }
                    break;
                }
            }
        }
        if ("netbeans.home".equals(x) || "netbeans.user".equals(x)) {
            for (Class<?> c : this.getClassContext()) {
                if (c == TopSecurityManager.class || c == System.class || c == Boolean.class) continue;
                n = c.getName();
                set = warnedClassesNH;
                synchronized (set) {
                    if (warnedClassesNH.add(n)) {
                        LOG.log(Level.WARNING, "use of system property {0} has been obsoleted in favor of InstalledFileLocator at {1}", new Object[]{x, TopSecurityManager.findCallStackLine(n)});
                    }
                    break;
                }
            }
        }
    }

    private static String findCallStackLine(String callerClazz) {
        for (StackTraceElement line : Thread.currentThread().getStackTrace()) {
            if (!line.getClassName().equals(callerClazz)) continue;
            return line.toString();
        }
        return callerClazz;
    }

    @Override
    public void checkRead(String file) {
        this.notifyRead(file);
    }

    @Override
    public void checkRead(FileDescriptor fd) {
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
    }

    @Override
    public void checkDelete(String file) {
        this.notifyDelete(file);
        try {
            this.checkPermission(this.allPermission);
            return;
        }
        catch (SecurityException e) {
            super.checkDelete(file);
            return;
        }
    }

    @Override
    public void checkWrite(String file) {
        this.notifyWrite(file);
        try {
            this.checkPermission(this.allPermission);
            return;
        }
        catch (SecurityException e) {
            super.checkWrite(file);
            return;
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        if (!check) {
            return;
        }
        try {
            this.checkPermission(this.allPermission);
            return;
        }
        catch (SecurityException e) {
            try {
                super.checkConnect(host, port);
                return;
            }
            catch (SecurityException securityException) {
                PrivilegedCheck.checkConnect(host, port, this);
                return;
            }
        }
    }

    final void checkConnectImpl(String host, int port) {
        Class insecure = this.getInsecureClass();
        if (insecure != null) {
            URL ctx = TopSecurityManager.getClassURL(insecure);
            if (ctx != null) {
                try {
                    String fromHost = ctx.getHost();
                    InetAddress ia2 = InetAddress.getByName(host);
                    InetAddress ia3 = InetAddress.getByName(fromHost);
                    if (ia2.equals(ia3)) {
                        return;
                    }
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            }
            throw new SecurityException();
        }
    }

    @Override
    public void checkConnect(String s, int port, Object context) {
        this.checkConnect(s, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkPermission(Permission perm) {
        this.checkSetSecurityManager(perm);
        if (!awtPermissionClass.isInstance(perm) || !"accessClipboard".equals(perm.getName())) return;
        Class<TopSecurityManager> clazz = TopSecurityManager.class;
        synchronized (TopSecurityManager.class) {
            ThreadLocal<Object> t = CLIPBOARD_FORBIDDEN;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (t == null) {
                return;
            }
            if (t.get() != null) {
                t.set(this);
                throw new SecurityException();
            }
            this.checkWhetherAccessedFromSwingTransfer();
            return;
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        this.checkSetSecurityManager(perm);
    }

    private boolean checkLogger(Permission perm) {
        if (LoggingPermission.class.isInstance(perm)) {
            Throwable t = new Exception().fillInStackTrace();
            for (StackTraceElement e : t.getStackTrace()) {
                if ("java.util.logging.LogManager".equals(e.getClassName()) && "reset".equals(e.getMethodName())) {
                    SecurityException se = new SecurityException("Illegal attempt to reset system logger");
                    throw se;
                }
                if (!"java.util.logging.LogManager".equals(e.getClassName()) || !"readConfiguration".equals(e.getMethodName())) continue;
                SecurityException se = new SecurityException("Illegal attempt to replace system logger configuration");
                throw se;
            }
        }
        return true;
    }

    public static void install() {
        try {
            System.setSecurityManager(new TopSecurityManager());
        }
        catch (SecurityException ex) {
            LOG.log(Level.WARNING, "Cannot associated own security manager");
            LOG.log(Level.INFO, "Cannot associated own security manager", ex);
        }
    }

    static void uninstall() {
        System.setSecurityManager(null);
    }

    private void checkSetSecurityManager(Permission perm) {
        if (runtimePermissionClass.isInstance(perm) && perm.getName().equals("setSecurityManager")) {
            Class<?>[] arr = this.getClassContext();
            boolean seenJava = false;
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i].getName().equals("org.netbeans.TopSecurityManager")) {
                    if (!seenJava) continue;
                    return;
                }
                if (arr[i] != System.class) break;
                seenJava = true;
            }
            throw new SecurityException();
        }
    }

    private Class getInsecureClass() {
        Class<?>[] ctx = this.getClassContext();
        boolean firstACClass = false;
        for (int i = 0; i < ctx.length; ++i) {
            if (ctx[i] == accessControllerClass) {
                if (firstACClass) {
                    return null;
                }
                firstACClass = true;
                continue;
            }
            if (ctx[i].getClassLoader() != null) {
                if (TopSecurityManager.isSecureClass(ctx[i])) {
                    if (!classLoaderClass.isAssignableFrom(ctx[i])) continue;
                    return null;
                }
                return ctx[i];
            }
            if (!classLoaderClass.isAssignableFrom(ctx[i])) continue;
            return null;
        }
        return null;
    }

    static boolean isSecureClass(Class clazz) {
        URL source = TopSecurityManager.getClassURL(clazz);
        if (source != null) {
            return TopSecurityManager.isSecureProtocol(source.getProtocol());
        }
        return true;
    }

    static URL getClassURL(Class clazz) {
        CodeSource cs = clazz.getProtectionDomain().getCodeSource();
        if (cs != null) {
            URL url = cs.getLocation();
            return url;
        }
        return null;
    }

    static Field getUrlField(Class clazz) {
        if (urlField == null) {
            try {
                Field[] fds = clazz.getDeclaredFields();
                for (int i = 0; i < fds.length; ++i) {
                    if (fds[i].getType() != URLClass) continue;
                    fds[i].setAccessible(true);
                    urlField = fds[i];
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return urlField;
    }

    static boolean isSecureProtocol(String protocol) {
        return !protocol.equals("http") && !protocol.equals("ftp") && !protocol.equals("rmi");
    }

    /*
     * Exception decompiling
     */
    public static void makeSwingUseSpecialClipboard(Clipboard clip) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkWhetherAccessedFromSwingTransfer() throws SecurityException {
        for (Class<?> c : this.getClassContext()) {
            if (!c.getName().equals("javax.swing.TransferHandler$TransferAction")) continue;
            throw new SecurityException("All swing access to clipboard should be redirected to ExClipboard");
        }
    }

    static {
        delegates = new ArrayList<SecurityManager>();
        officialExit = false;
        warnedClassesNH = new HashSet<String>(25);
        warnedClassesNH.add("org.openide.modules.Places");
        warnedClassesNH.add("org.netbeans.MainImpl");
        warnedClassesNH.add("org.netbeans.MainImpl$BootClassLoader");
        warnedClassesNH.add("org.netbeans.org.netbeans.CLIHandler");
        warnedClassesNH.add("org.netbeans.Stamps");
        warnedClassesNH.add("org.netbeans.core.startup.InstalledFileLocatorImpl");
        warnedClassesNH.add("org.netbeans.core.startup.CLIOptions");
        warnedClassesNH.add("org.netbeans.updater.UpdateTracking");
        warnedClassesNH.add("org.netbeans.core.ui.ProductInformationPanel");
        warnedClassesNH.add("org.netbeans.lib.uihandler.LogFormatter");
        warnedClassesNH.add("org.netbeans.modules.j2ee.sun.ide.j2ee.PluginProperties");
        warnedClassesNH.add("org.netbeans.modules.apisupport.project.universe.NbPlatform");
    }

    private static final class PrivilegedCheck
    implements PrivilegedExceptionAction<Object> {
        int action;
        TopSecurityManager tsm;
        int status;
        AccessControlContext acc;
        String host;
        int port;

        public PrivilegedCheck(int action, TopSecurityManager tsm) {
            this.action = action;
            this.tsm = tsm;
            if (action == 0) {
                this.acc = AccessController.getContext();
            }
        }

        @Override
        public Object run() throws Exception {
            switch (this.action) {
                case 0: {
                    this.tsm.checkExitImpl(this.status, this.acc);
                    break;
                }
                case 1: {
                    this.tsm.checkConnectImpl(this.host, this.port);
                    break;
                }
            }
            return null;
        }

        static void checkExit(int status, TopSecurityManager tsm) {
            PrivilegedCheck pea = new PrivilegedCheck(0, tsm);
            pea.status = status;
            PrivilegedCheck.check(pea);
        }

        static void checkConnect(String host, int port, TopSecurityManager tsm) {
            PrivilegedCheck pea = new PrivilegedCheck(1, tsm);
            pea.host = host;
            pea.port = port;
            PrivilegedCheck.check(pea);
        }

        private static void check(PrivilegedCheck action) {
            try {
                AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                Exception orig = e.getException();
                if (orig instanceof RuntimeException) {
                    throw (RuntimeException)orig;
                }
                orig.printStackTrace();
            }
        }
    }
}

